/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.sourceid.saml20.domain.SessionTimeUnit;
import org.sourceid.saml20.domain.UserDeviceType;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;

public class AuthnSessionPolicy {
    private String id;
    private AuthnSourceKey.AuthnSourceType authnSourceType;
    private String authnSourceId;
    private boolean enableSessions;
    private boolean persistent;
    private Integer maxTimeoutMins;
    private Integer idleTimeoutMins;
    private SessionTimeUnit timeoutDisplayUnit = SessionTimeUnit.MINUTES;
    private UserDeviceType userDeviceType = UserDeviceType.PRIVATE;
    private boolean authnContextSensitive = false;

    @XmlAttribute
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlAttribute
    public AuthnSourceKey.AuthnSourceType getAuthnSourceType() {
        return this.authnSourceType;
    }

    public void setAuthnSourceType(AuthnSourceKey.AuthnSourceType authnSourceType) {
        this.authnSourceType = authnSourceType;
    }

    @XmlAttribute
    public String getAuthnSourceId() {
        return this.authnSourceId;
    }

    public void setAuthnSourceId(String authnSourceId) {
        this.authnSourceId = authnSourceId;
    }

    @XmlTransient
    public AuthnSourceKey getAuthnSourceKey() {
        return AuthnSessionPolicy.makeAuthnSourceKey(this.authnSourceType, this.authnSourceId);
    }

    public static AuthnSourceKey makeAuthnSourceKey(AuthnSourceKey.AuthnSourceType sourceType, String sourceId) {
        switch (sourceType) {
            case ADAPTER: {
                return new AdapterAuthnSourceKey(sourceId);
            }
            case IDP_CONN: {
                return new IdpConnAuthnSourceKey(sourceId);
            }
        }
        throw new RuntimeException("Unrecognized authn source type: " + sourceType);
    }

    public void setAuthnSourceKey(AuthnSourceKey authnSource) {
        this.authnSourceType = authnSource.getType();
        this.authnSourceId = authnSource.getId();
    }

    @XmlAttribute
    public boolean isEnableSessions() {
        return this.enableSessions;
    }

    public void setEnableSessions(boolean enableSessions) {
        this.enableSessions = enableSessions;
    }

    @XmlAttribute
    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @XmlAttribute
    public Integer getMaxTimeoutMins() {
        return this.maxTimeoutMins;
    }

    public void setMaxTimeoutMins(Integer maxTimeoutMins) {
        this.maxTimeoutMins = maxTimeoutMins;
    }

    @XmlAttribute
    public SessionTimeUnit getTimeoutDisplayUnit() {
        return this.timeoutDisplayUnit;
    }

    public void setTimeoutDisplayUnit(SessionTimeUnit timeoutDisplayUnit) {
        this.timeoutDisplayUnit = timeoutDisplayUnit;
    }

    @XmlAttribute
    public Integer getIdleTimeoutMins() {
        return this.idleTimeoutMins;
    }

    public void setIdleTimeoutMins(Integer idleTimeoutMins) {
        this.idleTimeoutMins = idleTimeoutMins;
    }

    @XmlAttribute
    public boolean isAuthnContextSensitive() {
        return this.authnContextSensitive;
    }

    public void setAuthnContextSensitive(boolean authnContextSensitive) {
        this.authnContextSensitive = authnContextSensitive;
    }

    public UserDeviceType getUserDeviceType() {
        return this.userDeviceType;
    }

    public void setUserDeviceType(UserDeviceType userDeviceType) {
        this.userDeviceType = userDeviceType;
    }
}

