/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.Set;
import org.sourceid.saml20.domain.GlobalAuthnSessionPolicy;
import org.sourceid.saml20.domain.UserDeviceType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.IdpHashableAuthnBean;

public class AuthnSessionSettings {
    private boolean enableSessions = false;
    private boolean persistent = false;
    private UserDeviceType userDeviceType;
    private int idleTimeoutMins = -1;
    private int maxTimeoutMins = -1;
    private boolean authnContextSensitive = false;

    public AuthnSessionSettings() {
    }

    public AuthnSessionSettings(GlobalAuthnSessionPolicy policy) {
        this.enableSessions = policy.isEnableSessions();
        this.persistent = policy.isPersistentSessions();
        this.idleTimeoutMins = policy.getIdleTimeoutMins();
        this.maxTimeoutMins = policy.getMaxTimeoutMins();
        if (this.enableSessions) {
            this.userDeviceType = UserDeviceType.getDefaultUserDevice();
        }
    }

    public AuthnSessionSettings(AuthnSessionSettings authnSessionSettings) {
        this.enableSessions = authnSessionSettings.enableSessions;
        this.persistent = authnSessionSettings.persistent;
        this.userDeviceType = authnSessionSettings.userDeviceType;
        this.idleTimeoutMins = authnSessionSettings.idleTimeoutMins;
        this.maxTimeoutMins = authnSessionSettings.maxTimeoutMins;
        this.authnContextSensitive = authnSessionSettings.authnContextSensitive;
    }

    public boolean isEnableSessions() {
        return this.enableSessions;
    }

    public void setEnableSessions(boolean enableSessions) {
        this.enableSessions = enableSessions;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public UserDeviceType getUserDeviceType() {
        return this.userDeviceType;
    }

    public void setUserDeviceType(UserDeviceType userDeviceType) {
        this.userDeviceType = userDeviceType;
    }

    public boolean hasIdleTimeout() {
        return this.idleTimeoutMins != -1;
    }

    public int getIdleTimeoutMins() {
        return this.idleTimeoutMins;
    }

    public void setIdleTimeoutMins(int idleTimeoutMins) {
        this.idleTimeoutMins = idleTimeoutMins;
    }

    public long getIdleTimeoutMillis() {
        return (long)this.idleTimeoutMins * 60L * 1000L;
    }

    public boolean hasMaxTimeout() {
        return this.maxTimeoutMins != -1;
    }

    public int getMaxTimeoutMins() {
        return this.maxTimeoutMins;
    }

    public void setMaxTimeoutMins(int maxTimeoutMins) {
        this.maxTimeoutMins = maxTimeoutMins;
    }

    public long getMaxTimeoutMillis() {
        return (long)this.maxTimeoutMins * 60L * 1000L;
    }

    public boolean isAuthnContextSensitive() {
        return this.authnContextSensitive;
    }

    public void setAuthnContextSensitive(boolean authnContextSensitive) {
        this.authnContextSensitive = authnContextSensitive;
    }

    public boolean isSessionValid(IdpHashableAuthnBean session, long lastActivityTimeMillis, long currentTimeMillis) {
        long expiryTimeMillis = this.getExpiryTimeMillis(session, lastActivityTimeMillis);
        return expiryTimeMillis > currentTimeMillis;
    }

    public long getExpiryTimeMillis(IdpHashableAuthnBean session, long lastActivityTimeMillis) {
        long expiryTimeMillis = lastActivityTimeMillis + (long)MgmtFactory.getAuthnSessionPolicyManager().getTimeoutCapMins() * 60L * 1000L;
        if (this.hasIdleTimeout()) {
            expiryTimeMillis = Math.min(expiryTimeMillis, lastActivityTimeMillis + this.getIdleTimeoutMillis());
        }
        if (this.hasMaxTimeout()) {
            expiryTimeMillis = Math.min(expiryTimeMillis, session.getCreationTimeMillis() + this.getMaxTimeoutMillis());
        }
        expiryTimeMillis = Math.min(expiryTimeMillis, session.getNotOnOrAfterMillis());
        return expiryTimeMillis;
    }

    public static long getOverallExpiryTimeMillis(Set<IdpHashableAuthnBean> sessions, long lastActivityTimeMillis) {
        long result = 0L;
        for (IdpHashableAuthnBean bean : sessions) {
            result = Math.max(result, AuthnSessionSettings.getSessionExpiryTimeMillis(bean, lastActivityTimeMillis));
        }
        return result;
    }

    public static long getSessionExpiryTimeMillis(IdpHashableAuthnBean bean, long lastActivityTimeMillis) {
        AuthnSessionSettings settings = MgmtFactory.getAuthnSessionPolicyManager().getEffectiveSettings(bean.getAuthnSourceKey(), bean.getDeviceSharingType());
        if (!settings.isEnableSessions()) {
            return 0L;
        }
        return settings.getExpiryTimeMillis(bean, lastActivityTimeMillis);
    }
}

