/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.VirtualServerIdsReferencer;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.util.log.AttributeMap;

public abstract class AuthnSourceToAssertionMapping
implements VirtualServerIdsReferencer,
Serializable {
    private static final transient Log log = LogFactory.getLog(AuthnSourceToAssertionMapping.class);
    private static final long serialVersionUID = 1L;
    private List<AttributeMapping> attributeMappingList = new ArrayList<AttributeMapping>();
    private AttributeMapping defaultAttributeMapping;
    private boolean abortIfNotFoundInAnyDataSources;
    private boolean restrictVirtualServerIds;
    private List<String> restrictedVirtualServerIds = Collections.emptyList();

    public AuthnSourceToAssertionMapping() {
    }

    public AuthnSourceToAssertionMapping(AuthnSourceToAssertionMapping copy) {
        this.attributeMappingList = new ArrayList<AttributeMapping>(copy.attributeMappingList);
        this.defaultAttributeMapping = new AttributeMapping(copy.defaultAttributeMapping);
        this.abortIfNotFoundInAnyDataSources = copy.abortIfNotFoundInAnyDataSources;
        this.restrictVirtualServerIds = copy.restrictVirtualServerIds;
        this.restrictedVirtualServerIds = new ArrayList<String>(copy.restrictedVirtualServerIds);
    }

    @Override
    public List<String> getRestrictedVirtualServerIds() {
        return this.restrictedVirtualServerIds;
    }

    @Override
    public void setRestrictedVirtualServerIds(List<String> restrictedVirtualServerIds) {
        this.restrictedVirtualServerIds = restrictedVirtualServerIds;
    }

    @Override
    public boolean isRestrictVirtualServerIds() {
        return this.restrictVirtualServerIds;
    }

    @Override
    public void setRestrictVirtualServerIds(boolean restrictVirtualServerIds) {
        this.restrictVirtualServerIds = restrictVirtualServerIds;
    }

    public List<AttributeMapping> getAttributeMappingList() {
        return this.attributeMappingList;
    }

    public void setAttributeMappingList(List<AttributeMapping> attributeMappingList) {
        this.attributeMappingList = attributeMappingList;
    }

    public AttributeMapping getDefaultAttributeMapping() {
        return this.defaultAttributeMapping;
    }

    public void setDefaultAttributeMapping(AttributeMapping defaultAttributeMapping) {
        this.defaultAttributeMapping = defaultAttributeMapping;
    }

    public boolean isAbortIfNotFoundInAnyDataSources() {
        return this.abortIfNotFoundInAnyDataSources;
    }

    public void setAbortIfNotFoundInAnyDataSources(boolean abortIfNotFoundInAnyDataSources) {
        this.abortIfNotFoundInAnyDataSources = abortIfNotFoundInAnyDataSources;
    }

    public AttributeMap executeAttributeMapping(AttributeMap attributesFromAdapter, Set<String> targetNames, AttributeMap contextAttributes) throws StatusResponseException {
        AttributeMap resultantMap = new AttributeMap();
        boolean canHaveMultipleMappings = this.attributeMappingList.size() > 0;
        StringBuilder problems = new StringBuilder();
        for (AttributeMapping mapping : this.attributeMappingList) {
            try {
                resultantMap = mapping.executeMapping(attributesFromAdapter, targetNames, contextAttributes, false, canHaveMultipleMappings);
                if (!resultantMap.isEmpty()) break;
                problems.append("Mapping lookup '").append(mapping.getDescription()).append("' returned empty result.  ");
            }
            catch (AuthorizationException e) {
                problems.append(e.getErrorDetail());
            }
            catch (AttrLookupException e) {
                StringBuilder msg = new StringBuilder();
                msg.append("Error occurred in attribute mapping lookup '").append(mapping.getDescription());
                msg.append("' ").append(e.getMessage()).append(". ");
                String s = msg.toString();
                log.error((Object)s, (Throwable)e);
                problems.append((CharSequence)msg);
            }
        }
        if (resultantMap.isEmpty()) {
            if (this.abortIfNotFoundInAnyDataSources || this.defaultAttributeMapping == null) {
                String msg = "Unable to provide subject and attribute info.  Attribute mapping(s) failed: " + problems;
                throw new StatusResponseException(TopLevelStatusCode.RESPONDER, msg);
            }
            try {
                return this.defaultAttributeMapping.executeMapping(attributesFromAdapter, targetNames, contextAttributes);
            }
            catch (AuthorizationException e) {
                throw new StatusResponseException(TopLevelStatusCode.RESPONDER, new String[]{"urn:oasis:names:tc:SAML:2.0:status:RequestDenied"}, e.getErrorDetail(), e);
            }
            catch (AttrLookupException e) {
                throw new StatusResponseException(TopLevelStatusCode.RESPONDER, new String[]{"urn:oasis:names:tc:SAML:2.0:status:RequestDenied"}, e.getMessage(), e);
            }
        }
        return resultantMap;
    }

    public boolean hasExpressions() {
        AttributeMapping defaultMapping;
        List<AttributeMapping> mappings = this.getAttributeMappingList();
        if (mappings.size() > 0) {
            for (AttributeMapping mapping : mappings) {
                if (!mapping.hasExpressions()) continue;
                return true;
            }
        }
        return (defaultMapping = this.getDefaultAttributeMapping()) != null && defaultMapping.hasExpressions();
    }
}

