/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.util.DateUtil;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConfigAbstract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;

public class BasePluginInstance
extends ConfigAbstract
implements ConfigurablePluginInstance {
    private static final long serialVersionUID = 20050515L;
    private String name;
    private PluginDescriptor pluginDescriptor;
    private AttributeContract attributeContract = new AttributeContract();
    private Configuration configuration;
    private String parentInstanceId;
    private Set<String> immutableAttrNames = new HashSet<String>();
    private Set<String> mutableAttrNames = null;
    private boolean isInheritingAttributes = false;
    private String connectionId;
    private boolean defaultInstance;
    private boolean virtualInstance = false;
    private Set<String> multiValuedContractAttributes;
    private Calendar lastModified = null;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public AttributeContract getAttributeContract() {
        if (this.parentInstanceId == null) {
            return this.attributeContract;
        }
        return ConfigurationUtil.findEffectiveAttributeContract(this, this.getCoreAttributeNames());
    }

    @Override
    public Set<String> getExtendedContractAttributes() {
        return this.mutableAttrNames;
    }

    @Override
    public void setExtendedContractAttributes(Set<String> extendedAttrs) {
        this.mutableAttrNames = extendedAttrs;
        this.updateAttributeContract();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration == null ? new Configuration() : this.configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.updateAttributeContract();
    }

    @Override
    public GuiConfigDescriptor getGuiDescriptor() {
        return this.pluginDescriptor == null ? new GuiConfigDescriptor() : this.pluginDescriptor.getGuiConfigDescriptor();
    }

    @Override
    public PluginDescriptor getDescriptor() {
        return this.pluginDescriptor;
    }

    @Override
    public void setDescriptor(PluginDescriptor pluginDescriptor) {
        this.setImmutableAttributeContract(pluginDescriptor.getAttributeContractSet());
        this.pluginDescriptor = pluginDescriptor;
    }

    public void setImmutableAttributeContract(Set<String> attrNames) {
        this.immutableAttrNames = attrNames;
        this.updateAttributeContract();
    }

    @Override
    public String getParentId() {
        return this.parentInstanceId;
    }

    @Override
    public void setParentId(String parentId) {
        this.parentInstanceId = parentId;
    }

    @Override
    public Configuration getAdminCompositeConfiguration() {
        return ConfigurationUtil.createAdminCompositeConfiguration(this);
    }

    @Override
    public Configuration getRuntimeCompositeConfiguration() {
        return ConfigurationUtil.createRuntimeCompositeConfiguration(this);
    }

    @Override
    public boolean isInheritingExtendedContractAttributes() {
        return this.isInheritingAttributes;
    }

    @Override
    public void setInheritingExtendedContractAttributes(boolean inheritAttributes) {
        this.isInheritingAttributes = inheritAttributes;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    @Override
    public boolean isConnectionBasedPlugin() {
        return this.connectionId != null;
    }

    @Override
    public boolean isDefaultInstance() {
        return this.defaultInstance;
    }

    @Override
    public void setDefaultInstance(boolean defaultInstance) {
        this.defaultInstance = defaultInstance;
    }

    @Override
    public boolean isVirtualInstance() {
        return this.virtualInstance;
    }

    @Override
    public void setVirtualInstance(boolean virtualInstance) {
        this.virtualInstance = virtualInstance;
    }

    @Override
    public Set<String> getMultiValuedContractAttributes() {
        if (this.parentInstanceId == null) {
            return this.multiValuedContractAttributes;
        }
        return ConfigurationUtil.findEffectiveMultiValuedAttributes(this);
    }

    @Override
    public void setMultiValuedContractAttributes(Set<String> multiValuedContractAttributes) {
        this.multiValuedContractAttributes = multiValuedContractAttributes;
    }

    @Override
    public Set<String> getOwnMultiValuedContractAttributes() {
        return this.multiValuedContractAttributes;
    }

    protected List<String> getAdditionalCoreAttributeNames(Configuration configuration) {
        return Collections.emptyList();
    }

    private void updateAttributeContract() {
        AttributeContract tempAttributeContract = new AttributeContract(this.getCoreAttributeNames());
        if (this.mutableAttrNames != null) {
            tempAttributeContract.setMutableAttributeNames(this.mutableAttrNames);
        }
        this.attributeContract = tempAttributeContract;
    }

    private Set<String> getCoreAttributeNames() {
        List<String> additionalAttributes = null;
        if (this.configuration != null) {
            additionalAttributes = this.getAdditionalCoreAttributeNames(this.configuration);
        }
        if (additionalAttributes == null || additionalAttributes.isEmpty()) {
            return this.immutableAttrNames;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.immutableAttrNames != null) {
            result.addAll(this.immutableAttrNames);
        }
        result.addAll(additionalAttributes);
        return result;
    }

    @Override
    public Calendar getLastModified() {
        return DateUtil.copyCalendar(this.lastModified);
    }

    @Override
    public void setLastModified(Calendar lastModified) {
        this.lastModified = DateUtil.copyCalendar(lastModified);
    }
}

