/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.domain.BasePluginInstance;
import org.sourceid.saml20.domain.TokenEndpointAttributeContract;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.util.HierarchicalResourceMatchingUtil;

public class BearerAccessTokenMgmtPluginInstance
extends BasePluginInstance {
    private static final long serialVersionUID = 1L;
    private static final BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    private boolean inheritSelectionSettings = false;
    private boolean inheritAccessControlSettings = false;
    private boolean inheritSessionValidationSettings = false;
    private boolean isRestrictClients = false;
    private boolean includeSessionIdentifier = false;
    private boolean checkSessionValidationStatus = false;
    private boolean checkSessionRevocationStatus = false;
    private boolean updateAuthSessionActivity = false;
    private String defaultSubjectAttribute;
    private TokenEndpointAttributeContract tokenEndpointAttributeContract = new TokenEndpointAttributeContract();
    private boolean inheritTokenEndpointAttributes = false;
    private List<String> allowedClients = new ArrayList<String>();
    private List<String> resourceUris = new ArrayList<String>();

    public boolean isInheritSelectionSettings() {
        return this.inheritSelectionSettings;
    }

    public void setInheritSelectionSettings(boolean inheritSelectionSettings) {
        this.inheritSelectionSettings = inheritSelectionSettings;
    }

    public boolean isInheritAccessControlSettings() {
        return this.inheritAccessControlSettings;
    }

    public void setInheritAccessControlSettings(boolean inheritAccessControlSettings) {
        this.inheritAccessControlSettings = inheritAccessControlSettings;
    }

    public boolean isInheritSessionValidationSettings() {
        return this.inheritSessionValidationSettings;
    }

    public void setInheritSessionValidationSettings(boolean inheritSessionValidationSettings) {
        this.inheritSessionValidationSettings = inheritSessionValidationSettings;
    }

    public boolean isRestrictClients() {
        return this.findEffectiveRestrictClients();
    }

    public boolean isOwnRestrictClients() {
        return this.isRestrictClients;
    }

    public void setOwnRestrictClients(boolean isRestrictClients) {
        this.isRestrictClients = isRestrictClients;
    }

    public List<String> getAllowedClients() {
        return this.findEffectiveAllowedClients();
    }

    public List<String> getOwnAllowedClients() {
        return this.allowedClients;
    }

    public void setOwnAllowedClients(List<String> allowedClients) {
        this.allowedClients = allowedClients;
    }

    public boolean isClientAllowed(String clientId) {
        String defaultAtmId;
        if (clientId == null) {
            return !this.isRestrictClients();
        }
        Client client = MgmtFactory.getClientManager().getCachedClient(clientId);
        if (client == null) {
            return !this.isRestrictClients();
        }
        if (client.isRestrictToDefaultAccessTokenManager() && ((defaultAtmId = client.getDefaultAccessTokenManagerId()) != null ? !defaultAtmId.equals(this.getId()) : !this.isDefaultInstance())) {
            return false;
        }
        return !this.isRestrictClients() || this.getAllowedClients().contains(clientId);
    }

    public List<String> getResourceUris() {
        return this.findEffectiveResourceUris(null);
    }

    public List<String> getOwnResourceUris() {
        return this.resourceUris;
    }

    public void setOwnResourceUris(List<String> resourceUris) {
        this.resourceUris = resourceUris;
    }

    public boolean isInheritTokenEndpointAttributeContract() {
        return this.inheritTokenEndpointAttributes;
    }

    public void setInheritTokenEndpointAttributeContract(boolean inheritTokenEndpointContractAttributes) {
        this.inheritTokenEndpointAttributes = inheritTokenEndpointContractAttributes;
    }

    public TokenEndpointAttributeContract getTokenEndpointAttributeContract() {
        if (this.getParentId() == null) {
            return this.tokenEndpointAttributeContract;
        }
        return this.findEffectiveTokenEndpointAttributeContract();
    }

    public void setTokenEndpointAttributeContract(TokenEndpointAttributeContract tokenEndpointAttributeContract) {
        this.tokenEndpointAttributeContract = tokenEndpointAttributeContract;
    }

    public TokenEndpointAttributeContract getOwnTokenEndpointAttributeContract() {
        return this.tokenEndpointAttributeContract;
    }

    public List<String> findEffectiveResourceUris(PluginManager<PluginDescriptor, BearerAccessTokenMgmtPluginInstance> pluginMgr) {
        if (pluginMgr == null) {
            pluginMgr = bearerAccessTokenMgmtPluginManager;
        }
        LinkedList<BearerAccessTokenMgmtPluginInstance> ancestors = ConfigurationUtil.getAncestors(this, pluginMgr);
        Iterator<BearerAccessTokenMgmtPluginInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            BearerAccessTokenMgmtPluginInstance instance = reverseIt.next();
            if (instance.isInheritSelectionSettings()) continue;
            return instance.getOwnResourceUris();
        }
        return new ArrayList<String>();
    }

    public List<String> findEffectiveAllowedClients() {
        LinkedList<BearerAccessTokenMgmtPluginInstance> ancestors = ConfigurationUtil.getAncestors(this, bearerAccessTokenMgmtPluginManager);
        Iterator<BearerAccessTokenMgmtPluginInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            BearerAccessTokenMgmtPluginInstance instance = reverseIt.next();
            if (instance.isInheritAccessControlSettings()) continue;
            return instance.getOwnAllowedClients();
        }
        return new ArrayList<String>();
    }

    public String findEffectiveDefaultSubjectAttribute() {
        LinkedList<BearerAccessTokenMgmtPluginInstance> ancestors = ConfigurationUtil.getAncestors(this, bearerAccessTokenMgmtPluginManager);
        Iterator<BearerAccessTokenMgmtPluginInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            BearerAccessTokenMgmtPluginInstance instance = reverseIt.next();
            if (instance.isInheritingExtendedContractAttributes()) continue;
            return instance.getDefaultSubjectAttribute();
        }
        return this.defaultSubjectAttribute;
    }

    public boolean findEffectiveRevocationStatus() {
        LinkedList<BearerAccessTokenMgmtPluginInstance> ancestors = ConfigurationUtil.getAncestors(this, bearerAccessTokenMgmtPluginManager);
        Iterator<BearerAccessTokenMgmtPluginInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            BearerAccessTokenMgmtPluginInstance instance = reverseIt.next();
            if (instance.isInheritSessionValidationSettings()) continue;
            return instance.isCheckSessionRevocationStatus();
        }
        return this.checkSessionRevocationStatus;
    }

    public boolean findEffectiveSessionValidationStatus() {
        LinkedList<BearerAccessTokenMgmtPluginInstance> ancestors = ConfigurationUtil.getAncestors(this, bearerAccessTokenMgmtPluginManager);
        Iterator<BearerAccessTokenMgmtPluginInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            BearerAccessTokenMgmtPluginInstance instance = reverseIt.next();
            if (instance.isInheritSessionValidationSettings()) continue;
            return instance.isCheckSessionValidationStatus();
        }
        return this.checkSessionValidationStatus;
    }

    public boolean findEffectiveUpdateSessionStatus() {
        LinkedList<BearerAccessTokenMgmtPluginInstance> ancestors = ConfigurationUtil.getAncestors(this, bearerAccessTokenMgmtPluginManager);
        Iterator<BearerAccessTokenMgmtPluginInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            BearerAccessTokenMgmtPluginInstance instance = reverseIt.next();
            if (instance.isInheritSessionValidationSettings()) continue;
            return instance.isUpdateAuthSessionActivity();
        }
        return this.updateAuthSessionActivity;
    }

    public boolean findEffectiveIncludeSessionIdentifier() {
        LinkedList<BearerAccessTokenMgmtPluginInstance> ancestors = ConfigurationUtil.getAncestors(this, bearerAccessTokenMgmtPluginManager);
        Iterator<BearerAccessTokenMgmtPluginInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            BearerAccessTokenMgmtPluginInstance instance = reverseIt.next();
            if (instance.isInheritSessionValidationSettings()) continue;
            return instance.isIncludeSessionIdentifier();
        }
        return this.includeSessionIdentifier;
    }

    public boolean findEffectiveRestrictClients() {
        LinkedList<BearerAccessTokenMgmtPluginInstance> ancestors = ConfigurationUtil.getAncestors(this, bearerAccessTokenMgmtPluginManager);
        Iterator<BearerAccessTokenMgmtPluginInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            BearerAccessTokenMgmtPluginInstance instance = reverseIt.next();
            if (instance.isInheritAccessControlSettings()) continue;
            return instance.isOwnRestrictClients();
        }
        return false;
    }

    public TokenEndpointAttributeContract findEffectiveTokenEndpointAttributeContract() {
        LinkedList<BearerAccessTokenMgmtPluginInstance> ancestors = ConfigurationUtil.getAncestors(this, bearerAccessTokenMgmtPluginManager);
        TokenEndpointAttributeContract tokenEndpointAttributeContract = new TokenEndpointAttributeContract();
        Set<String> mutableAttrs = null;
        Set<String> multiValuedAttrs = null;
        Map<String, Set<String>> mappedScopes = null;
        Iterator<BearerAccessTokenMgmtPluginInstance> reverseIt = ancestors.descendingIterator();
        while (reverseIt.hasNext()) {
            BearerAccessTokenMgmtPluginInstance instance = reverseIt.next();
            if (instance.isInheritTokenEndpointAttributeContract()) continue;
            mutableAttrs = instance.getOwnTokenEndpointAttributeContract().getMutableAttributeNames();
            multiValuedAttrs = instance.getOwnTokenEndpointAttributeContract().getMultiValued();
            mappedScopes = instance.getOwnTokenEndpointAttributeContract().getMappedScopes();
            break;
        }
        if (mutableAttrs != null) {
            tokenEndpointAttributeContract.setMutableAttributeNames(mutableAttrs);
        }
        if (multiValuedAttrs != null) {
            tokenEndpointAttributeContract.setMultiValued(multiValuedAttrs);
        }
        if (mappedScopes != null) {
            tokenEndpointAttributeContract.setMappedScopes(mappedScopes);
        }
        return tokenEndpointAttributeContract;
    }

    public boolean isIncludeSessionIdentifier() {
        return this.includeSessionIdentifier;
    }

    public void setIncludeSessionIdentifier(boolean includeSessionIdentifier) {
        this.includeSessionIdentifier = includeSessionIdentifier;
    }

    public boolean isCheckSessionValidationStatus() {
        return this.checkSessionValidationStatus;
    }

    public void setCheckSessionValidationStatus(boolean checkSessionValidationStatus) {
        this.checkSessionValidationStatus = checkSessionValidationStatus;
    }

    public boolean isCheckSessionRevocationStatus() {
        return this.checkSessionRevocationStatus;
    }

    public void setCheckSessionRevocationStatus(boolean checkSessionRevocationStatus) {
        this.checkSessionRevocationStatus = checkSessionRevocationStatus;
    }

    public boolean isUpdateAuthSessionActivity() {
        return this.updateAuthSessionActivity;
    }

    public void setUpdateAuthSessionActivity(boolean updateAuthSessionActivity) {
        this.updateAuthSessionActivity = updateAuthSessionActivity;
    }

    public String getDefaultSubjectAttribute() {
        return this.defaultSubjectAttribute;
    }

    public void setDefaultSubjectAttribute(String defaultSubjectAttribute) {
        this.defaultSubjectAttribute = defaultSubjectAttribute;
    }

    public boolean isSessionValidationEnabled() {
        return this.findEffectiveRevocationStatus() || this.findEffectiveSessionValidationStatus() || this.findEffectiveUpdateSessionStatus();
    }

    public boolean isIssueSri() {
        return this.findEffectiveIncludeSessionIdentifier() || this.findEffectiveRevocationStatus() || this.findEffectiveSessionValidationStatus() || this.findEffectiveUpdateSessionStatus();
    }

    public boolean isExpandScopeGroups() {
        boolean isExpandScopeGroups = false;
        Field expandScopeGroupsField = this.getConfiguration().getField("Expand Scope Groups");
        if (expandScopeGroupsField != null) {
            isExpandScopeGroups = expandScopeGroupsField.getValueAsBoolean();
        }
        return isExpandScopeGroups;
    }

    public boolean matchRequestedResource(String requestedResource) {
        return HierarchicalResourceMatchingUtil.match(requestedResource, this.getResourceUris());
    }
}

