/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.DNtoIdpMap;

public class DNtoIdPMappings {
    private static final Log log = LogFactory.getLog(DNtoIdPMappings.class);
    private List<DNtoIdpMap> issuerDNMapList = new ArrayList<DNtoIdpMap>();
    private List<DNtoIdpMap> subjectDNMapList = new ArrayList<DNtoIdpMap>();
    private String defaultIdp;

    public List<DNtoIdpMap> getIssuerDNMapList() {
        return this.issuerDNMapList;
    }

    public void setIssuerDNMapList(List<DNtoIdpMap> isserDNMapList) {
        this.issuerDNMapList = isserDNMapList;
    }

    public List<DNtoIdpMap> getSubjectDNMapList() {
        return this.subjectDNMapList;
    }

    public void setSubjectDNMapList(List<DNtoIdpMap> subjectDNMapList) {
        this.subjectDNMapList = subjectDNMapList;
    }

    public String getDefaultIdp() {
        return this.defaultIdp;
    }

    public void setDefaultIdp(String defaultIdp) {
        this.defaultIdp = defaultIdp;
    }

    private static String regexMap(List<DNtoIdpMap> mapList, String inputDN, String context) {
        String idpId = null;
        if (inputDN != null && !Util.isEmpty(mapList)) {
            String c14nDn = Util.canonicalizeX500DN(inputDN);
            log.debug((Object)(context + "DN[" + inputDN + "] is canonicalized to [" + c14nDn + "]"));
            for (DNtoIdpMap map : mapList) {
                if (map.matches(c14nDn)) {
                    idpId = map.getIdpId();
                    log.debug((Object)("canonicalized  " + context + " DN[" + c14nDn + "] matches [" + map.getDn() + "]"));
                    break;
                }
                log.debug((Object)("canonicalized  " + context + " DN" + c14nDn + "] does NOT match [" + map.getDn() + "]"));
            }
        }
        return idpId;
    }

    public String getIdpId(String issuerDN, String subjectDN) {
        String idpId = DNtoIdPMappings.regexMap(this.issuerDNMapList, issuerDN, "issuer");
        if (idpId == null) {
            idpId = DNtoIdPMappings.regexMap(this.subjectDNMapList, subjectDN, "subject");
        }
        if (idpId == null) {
            log.debug((Object)("No match found. Use default IdP " + this.defaultIdp));
            idpId = this.defaultIdp;
        }
        return idpId;
    }
}

