/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.crypto.KeyAlgorithmInfo;
import com.pingidentity.pingcommons.crypto.X509CertificateValueHelper;
import java.security.cert.X509Certificate;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.KeyRotationSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DSignRotationSetting
extends KeyRotationSettings {
    private static final long serialVersionUID = 1L;
    private int activationBufferMins = 129600;
    private String certAlias;
    private String keyAlgorithm;
    private String pendingCertAlias;
    private boolean enableCertRotation;

    public DSignRotationSetting(String certAlias, boolean enableCertRotation) {
        this.certAlias = certAlias;
        this.enableCertRotation = enableCertRotation;
    }

    public DSignRotationSetting(DSignRotationSetting dsignRotation, String certAlais) {
        this.certAlias = certAlais;
        this.validityPeriodDays = dsignRotation.validityPeriodDays;
        this.keySize = dsignRotation.keySize;
        this.signatureAlgorithm = dsignRotation.signatureAlgorithm;
        this.rotationBufferMins = dsignRotation.rotationBufferMins;
        this.activationBufferMins = dsignRotation.activationBufferMins;
        this.keyAlgorithm = dsignRotation.keyAlgorithm;
        this.enableCertRotation = dsignRotation.enableCertRotation;
    }

    public int getActivationBufferMins() {
        return this.activationBufferMins;
    }

    public Double getActivationBufferDays() {
        return (double)this.activationBufferMins / 1440.0;
    }

    public void setActivationBufferMins(int activationBufferMins) {
        this.activationBufferMins = activationBufferMins;
    }

    public Double getRotationBufferDays() {
        return (double)this.getRotationBufferMins() / 1440.0;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public String getPendingCertAlias() {
        return this.pendingCertAlias;
    }

    public void setPendingCertAlias(String pendingCertAlias) {
        this.pendingCertAlias = pendingCertAlias;
    }

    public boolean isEnableCertRotation() {
        return this.enableCertRotation;
    }

    public void setEnableCertRotation(boolean enableCertRotation) {
        this.enableCertRotation = enableCertRotation;
    }

    public boolean hasBufferTimeStarted(long expires, int bufferMin) {
        return this.getRemainingMillis(expires, bufferMin) <= 0L;
    }

    public long getRemainingMillis(long expires, int bufferMin) {
        long milliSeconds = this.minsToMilliSeconds(bufferMin);
        long rotationTime = expires - milliSeconds;
        long remaining = rotationTime - this.getCurrentTimeMillis();
        return remaining;
    }

    private long minsToMilliSeconds(int mins) {
        long milliSecs = (long)mins * 60L * 1000L;
        return milliSecs;
    }

    private long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public void initializeDefaultFromOriginalCert(Cert originalCert, boolean setDeafultValidityDays) {
        X509CertificateValueHelper x509Helper;
        Long validDays;
        if (originalCert == null) {
            return;
        }
        CertificateService certService = MgmtFactory.getCertificateService();
        X509Certificate originalX509 = originalCert.getX509Certificate();
        if (StringUtils.isBlank((String)this.signatureAlgorithm)) {
            this.signatureAlgorithm = originalX509.getSigAlgName();
        }
        if (StringUtils.isBlank((String)this.keyAlgorithm)) {
            this.keyAlgorithm = originalX509.getPublicKey().getAlgorithm();
        }
        if ((validDays = (x509Helper = new X509CertificateValueHelper(originalX509)).getValidDays()) != null && setDeafultValidityDays) {
            this.validityPeriodDays = validDays.intValue();
        }
        Integer originalCertKeySize = originalCert.getPublicKeySize();
        boolean invalidSelectedKeySize = true;
        KeyAlgorithmInfo info = certService.getKeyAlgorithmInfo(this.keyAlgorithm);
        for (Integer availableKeySize : info.getKeySizes()) {
            if (availableKeySize.intValue() != originalCertKeySize.intValue()) continue;
            invalidSelectedKeySize = false;
            break;
        }
        this.keySize = invalidSelectedKeySize ? info.getDefaultKeySize() : originalCertKeySize.intValue();
    }
}

