/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.util.DateUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.ConfigAbstract;
import org.sourceid.saml20.domain.impl.CustomAttributeSource;
import org.sourceid.saml20.domain.impl.JdbcAttributeSource;
import org.sourceid.saml20.domain.impl.LdapAttributeSource;

public abstract class DataSource
extends ConfigAbstract
implements Cloneable,
Serializable,
ServiceInformation {
    private String dsName;
    private Calendar lastModified = null;
    protected String description = "";
    private boolean maskAttributeValues;

    public abstract String getDescription();

    public void setDescription(String description) {
        this.description = description;
    }

    public abstract String getDataSourceType();

    public abstract DSType getDSType();

    public static String getTypeDescription(DSType type) {
        return type.getName();
    }

    public String toString() {
        return this.getDataSourceType();
    }

    public boolean isMaskAttributeValues() {
        return this.maskAttributeValues;
    }

    public void setMaskAttributeValues(boolean maskAttributeValues) {
        this.maskAttributeValues = maskAttributeValues;
    }

    public void checkSetMasked(AttributeValue attributeValue) {
        if (this.isMaskAttributeValues()) {
            AttrValueSupport.setMasked((AttributeValue)attributeValue);
        }
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public String getServiceName() {
        return "data-source";
    }

    public Calendar getLastModified() {
        return DateUtil.copyCalendar(this.lastModified);
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = DateUtil.copyCalendar(lastModified);
    }

    public static enum DSType {
        JDBC("JDBC", Collections.emptySet()){

            @Override
            public AttributeSource getAttributeSource() {
                return new JdbcAttributeSource();
            }
        }
        ,
        LDAP("LDAP", Collections.emptySet()){

            @Override
            public AttributeSource getAttributeSource() {
                return new LdapAttributeSource();
            }
        }
        ,
        Other("Other", new HashSet<String>(Collections.singletonList("Custom"))){

            @Override
            public AttributeSource getAttributeSource() {
                return new CustomAttributeSource();
            }
        }
        ,
        None("None", Collections.emptySet());

        private String name;
        private Set<String> deprecatedAliases;
        private static Map<String, DSType> lookup;

        private DSType(String name, Set<String> deprecatedAliases) {
            this.name = name;
            this.deprecatedAliases = deprecatedAliases;
        }

        public String getName() {
            return this.name;
        }

        public AttributeSource getAttributeSource() {
            return null;
        }

        public static DSType fromName(String name) {
            return lookup.get(name);
        }

        static {
            lookup = new HashMap<String, DSType>();
            for (DSType dsType : DSType.values()) {
                lookup.put(dsType.getName(), dsType);
                for (String alias : dsType.deprecatedAliases) {
                    lookup.put(alias, dsType);
                }
            }
        }
    }
}

