/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EncryptionPolicy
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String encryptionAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    private String keyTransportAlgorithm = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    private boolean encryptAssertion = false;
    private boolean encryptSubjectNameID = false;
    private Set<String> encryptAttributeList = new HashSet<String>();
    private boolean sloEncryptSubjectNameID;

    public boolean isEncryptAssertion() {
        return this.encryptAssertion;
    }

    public void setEncryptAssertion(boolean encryptAssertion) {
        this.encryptAssertion = encryptAssertion;
    }

    public List<String> getEncryptAttributeList() {
        return new ArrayList<String>(this.encryptAttributeList);
    }

    public void setEncryptAttributeList(List<String> encryptAttribList) {
        this.encryptAttributeList.clear();
        this.encryptAttributeList.addAll(encryptAttribList);
    }

    public void setEncryptAttributeList(String[] encryptAttributeList) {
        this.setEncryptAttributeList(Arrays.asList(encryptAttributeList));
    }

    public void addEncryptAttribute(String attrib) {
        this.encryptAttributeList.add(attrib);
    }

    public boolean wantToEncryptAttribute(String attrib) {
        return this.encryptAttributeList.contains(attrib);
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public boolean isEncryptSubjectNameID() {
        return this.encryptSubjectNameID;
    }

    public void setEncryptSubjectNameID(boolean encryptSubjectNameID) {
        this.encryptSubjectNameID = encryptSubjectNameID;
    }

    public String getKeyTransportAlgorithm() {
        return this.keyTransportAlgorithm;
    }

    public void setKeyTransportAlgorithm(String keyTransportAlgorithm) {
        this.keyTransportAlgorithm = keyTransportAlgorithm;
    }

    public boolean isSloEncryptSubjectNameID() {
        return this.sloEncryptSubjectNameID;
    }

    public void setSloEncryptSubjectNameID(boolean sloEncryptSubjectNameID) {
        this.sloEncryptSubjectNameID = sloEncryptSubjectNameID;
    }

    public EncryptionPolicy clone() {
        EncryptionPolicy clone = new EncryptionPolicy();
        clone.encryptionAlgorithm = this.encryptionAlgorithm;
        clone.keyTransportAlgorithm = this.keyTransportAlgorithm;
        clone.encryptAssertion = this.encryptAssertion;
        clone.encryptSubjectNameID = this.encryptSubjectNameID;
        clone.encryptAttributeList = new HashSet<String>(this.encryptAttributeList);
        clone.sloEncryptSubjectNameID = this.sloEncryptSubjectNameID;
        return clone;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptAssertion || this.encryptAttributeList.size() > 0 || this.sloEncryptSubjectNameID || this.encryptSubjectNameID;
    }
}

