/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

public class Endpoint
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private String binding;
    private String location;
    private String responseLocation;
    private String fullLocation;
    private String fullResponseLocation;

    public Endpoint(String binding, String location) {
        this(binding, location, null, null);
    }

    public Endpoint(String binding, String location, String responseLocation) {
        this(binding, location, responseLocation, null);
    }

    public Endpoint(String binding, String location, URL baseUrl) {
        this(binding, location, null, baseUrl);
    }

    public Endpoint(String binding, String location, String responseLocation, URL baseUrl) {
        this.binding = binding;
        this.location = location;
        this.responseLocation = responseLocation;
        if (baseUrl != null) {
            this.fullLocation = this.compose(baseUrl, location);
            if (this.hasResponseLocation()) {
                this.fullResponseLocation = this.compose(baseUrl, responseLocation);
            }
        } else {
            this.fullLocation = location;
            this.fullResponseLocation = responseLocation;
        }
    }

    private String compose(URL base, String path) {
        try {
            URL check = new URL(path);
            return check.toExternalForm();
        }
        catch (MalformedURLException e) {
            String url = base.toExternalForm();
            return url + path;
        }
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String b) {
        this.binding = b;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean hasResponseLocation() {
        return !StringUtils.isBlank((String)this.responseLocation);
    }

    public String getResponseLocation() {
        return this.hasResponseLocation() ? this.responseLocation : this.location;
    }

    public String getFullLocation() {
        return this.fullLocation;
    }

    public String getFullResponseLocation() {
        return this.fullResponseLocation != null ? this.fullResponseLocation : this.fullLocation;
    }
}

