/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.Endpoints;

public class EndpointGroup
extends Endpoints
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20050515L;
    private List<Endpoint> endpoints = new LinkedList<Endpoint>();

    public EndpointGroup() {
    }

    public EndpointGroup(Endpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public Endpoint getPrimaryEndpoint() {
        Iterator<Endpoint> iterator = this.endpoints.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public String getBindingsAsCommaDelimList(String placeholderForEmptyEntry) {
        ArrayList<String> temp = new ArrayList<String>();
        for (Endpoint e : this.getEndpoints()) {
            temp.add(e.getBinding());
        }
        return Util.listToCommaDelimString(temp);
    }

    public String getFullLocationAsCommaDelimList(String placeholderForEmptyEntry) {
        ArrayList<String> temp = new ArrayList<String>();
        for (Endpoint e : this.getEndpoints()) {
            temp.add(e.getFullLocation());
        }
        return Util.listToCommaDelimString(temp);
    }

    public String getFullResponseLocationAsCommaDelimList(String placeholderForEmptyEntry) {
        ArrayList<String> temp = new ArrayList<String>();
        for (Endpoint e : this.getEndpoints()) {
            temp.add(e.getFullResponseLocation());
        }
        return Util.listToCommaDelimString(temp);
    }

    public EndpointGroup clone() {
        EndpointGroup clone = new EndpointGroup();
        clone.endpoints = new LinkedList<Endpoint>(this.endpoints);
        return clone;
    }
}

