/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum GroupConstants {
    ID("id"),
    EXTERNAL_ID("externalId"),
    DISPLAY_NAME("displayName"),
    META_VERSION("meta.version"),
    META_LOCATION("meta.location"),
    META_CREATED("meta.created"),
    META_LAST_MODIFIED("meta.lastModified");

    private String id;
    private static final Map<String, GroupConstants> m;
    public static final String SCIM_GROUP_MEMBERS = "members";

    private GroupConstants(String id) {
        this.id = id;
    }

    public static GroupConstants getGroupConstant(String strToConvert) {
        return m.get(strToConvert);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public static List<String> getAllIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (GroupConstants c : GroupConstants.values()) {
            ids.add(c.getId());
        }
        Collections.sort(ids);
        return ids;
    }

    public static List<String> getAllIdsForReadGroups() {
        ArrayList<GroupConstants> notReadable = new ArrayList<GroupConstants>();
        notReadable.add(ID);
        notReadable.add(META_VERSION);
        notReadable.add(META_LOCATION);
        notReadable.add(META_CREATED);
        notReadable.add(META_LAST_MODIFIED);
        ArrayList<String> ids = new ArrayList<String>();
        for (GroupConstants c : GroupConstants.values()) {
            if (notReadable.contains((Object)c)) continue;
            ids.add(c.getId());
        }
        Collections.sort(ids);
        return ids;
    }

    public static List<String> getAllMappableIdsForWriteGroups() {
        ArrayList<GroupConstants> notMappable = new ArrayList<GroupConstants>();
        notMappable.add(ID);
        notMappable.add(META_VERSION);
        notMappable.add(META_LOCATION);
        notMappable.add(META_CREATED);
        notMappable.add(META_LAST_MODIFIED);
        ArrayList<String> ids = new ArrayList<String>();
        for (GroupConstants c : GroupConstants.values()) {
            if (notMappable.contains((Object)c)) continue;
            ids.add(c.getId());
        }
        Collections.sort(ids);
        return ids;
    }

    public static List<String> getAllMappableIdsForIdentityStorePluginWriteGroups() {
        ArrayList<String> ids = new ArrayList<String>();
        for (GroupConstants c : GroupConstants.values()) {
            ids.add(c.getId());
        }
        Collections.sort(ids);
        return ids;
    }

    static {
        m = new HashMap<String, GroupConstants>();
        for (GroupConstants c : GroupConstants.values()) {
            m.put(c.toString(), c);
        }
    }
}

