/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.util.ConfigurationUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.adapter.AuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpAdapter;
import org.sourceid.saml20.domain.IdpConfigurablePluginInstance;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;

public class IdpAuthnAdapterInstance
extends AuthnAdapterInstance
implements IdpConfigurablePluginInstance,
IdpAdapter {
    private static final long serialVersionUID = 20050515L;
    public static final String UNIQUE_USER_KEY_ATTRIBUTE_NONE_VALUE = "pf_none";
    private String authnCtxClassRef;
    private String uniqueUserKeyAttribute;
    private List<String> uniqueKeyFields = new LinkedList<String>();
    private Set<String> maskedFields = new HashSet<String>();
    private boolean maskOgnlValues;
    private boolean isInheritingAttributeSettings;
    private boolean isInheritingAttributeMapping;
    private AttributeMapping attributeMapping;

    public IdpAuthnAdapterInstance() {
    }

    public IdpAuthnAdapterInstance(IdpAuthnAdapterDescriptor descriptor) {
        super((AuthnAdapterDescriptor)descriptor);
    }

    public IdpAuthnAdapterDescriptor getDescriptor() {
        return (IdpAuthnAdapterDescriptor)super.getDescriptor();
    }

    public String getAuthnCtxClassRef() {
        return this.authnCtxClassRef;
    }

    public void setAuthnCtxClassRef(String authnCtxClassRef) {
        this.authnCtxClassRef = authnCtxClassRef;
    }

    public String getUniqueUserKeyAttribute() {
        if (this.isInheritingAttributeSettings) {
            return ConfigurationUtil.findEffectiveUniqueUserKeyField(this);
        }
        if (this.uniqueUserKeyAttribute != null) {
            return this.uniqueUserKeyAttribute;
        }
        return UNIQUE_USER_KEY_ATTRIBUTE_NONE_VALUE;
    }

    public void setUniqueUserKeyAttributeAsIs(String uniqueUserKeyAttribute) {
        this.uniqueUserKeyAttribute = uniqueUserKeyAttribute;
    }

    public void setUniqueUserKeyAttribute(String uniqueUserKeyAttribute) {
        this.uniqueUserKeyAttribute = uniqueUserKeyAttribute != null ? uniqueUserKeyAttribute : UNIQUE_USER_KEY_ATTRIBUTE_NONE_VALUE;
    }

    public List<String> getUniqueKeyFields() {
        if (this.isInheritingAttributeSettings) {
            return ConfigurationUtil.findEffectiveUniqueKeyFields(this);
        }
        return this.uniqueKeyFields;
    }

    public List<String> getOwnUniqueKeyFields() {
        return this.uniqueKeyFields;
    }

    public void setOwnUniqueKeyFields(List<String> uniqueKeyFields) {
        this.uniqueKeyFields = uniqueKeyFields;
    }

    @Override
    public Set<String> getMaskedFields() {
        if (this.isInheritingAttributeSettings) {
            return ConfigurationUtil.findEffectiveMaskedFields(this);
        }
        return this.maskedFields;
    }

    @Override
    public AttributeMapping getEffectiveAttributeMap() {
        return ConfigurationUtil.findEffectiveAttributeMapForAdapter(this);
    }

    @Override
    public Set<String> getOwnMaskedFields() {
        return this.maskedFields;
    }

    @Override
    public void setOwnMaskedFields(Set<String> maskedFields) {
        this.maskedFields = maskedFields;
    }

    @Override
    public boolean getMaskOgnlValues() {
        if (this.isInheritingAttributeSettings) {
            return ConfigurationUtil.findEffectiveMaskOgnlValues(this);
        }
        return this.maskOgnlValues;
    }

    @Override
    public boolean getOwnMaskOgnlValues() {
        return this.maskOgnlValues;
    }

    @Override
    public void setOwnMaskOgnlValues(boolean maskOgnlValues) {
        this.maskOgnlValues = maskOgnlValues;
    }

    @Override
    public boolean isInheritingAttributeSettings() {
        return this.isInheritingAttributeSettings;
    }

    @Override
    public void setInheritingAttributeSettings(boolean isInheritingUniqueKeyFields) {
        this.isInheritingAttributeSettings = isInheritingUniqueKeyFields;
    }

    @Override
    public AttributeMapping getAttributeMapping() {
        if (this.isInheritingAttributeMapping()) {
            return ConfigurationUtil.findEffectiveAttributeMapForAdapter(this);
        }
        return this.attributeMapping == null ? new AttributeMapping() : this.attributeMapping;
    }

    @Override
    public void setAttributeMapping(AttributeMapping attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    public AttributeMapping getNullableAttributeMapping() {
        if (this.isInheritingAttributeMapping()) {
            return ConfigurationUtil.findEffectiveAttributeMapForAdapter(this);
        }
        return this.attributeMapping;
    }

    @Override
    public boolean isInheritingAttributeMapping() {
        return this.isInheritingAttributeMapping;
    }

    @Override
    public void setInheritingAttributeMapping(boolean inheritingAttributeMapping) {
        this.isInheritingAttributeMapping = inheritingAttributeMapping;
    }

    public AdapterAuthnSourceKey getAdapterAuthnSourceKey() {
        if (this.getConnectionId() == null) {
            return new AdapterAuthnSourceKey(this.getId());
        }
        return new AdapterAuthnSourceKey(this.getParentId(), this.getConnectionId());
    }
}

