/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.UserKeyAttrMapping;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeAuthority;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.AuthnContextMapping;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.BasePluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.Endpoints;
import org.sourceid.saml20.domain.LoggingMode;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.OAuthSettings;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.domain.scim.ScimUserProvisioning;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class IdpConnection
extends ConnectionBase
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private boolean wantAuthnRequestsSigned;
    private EndpointGroup singleSignOnServices = new EndpointGroup();
    private Collection<TargetAttributeMapping> targetAttributeMappings = new ArrayList<TargetAttributeMapping>();
    private Collection<C2cContractAttributeMapping> c2cContractMappings = new ArrayList<C2cContractAttributeMapping>();
    private boolean linking = false;
    private boolean assertionSigned;
    private AttributeAuthority attributeAuthority;
    private Set<String> maskedAttributeNames = new HashSet<String>();
    private UserProvisioning userProvisioning;
    private String defaultTargetResource;
    private String errorPageMsg;
    private WsTrustFederatedWspSettings wsTrustSettings;
    private UserKeyAttrMapping ssoToOAuthAttrMapping;
    private String oAuthApcId = null;
    private OAuthSettings oAuthSettings;
    private ScimUserProvisioning inboundProvisioning;
    private BiMap<String, String> authnContextMapping = HashBiMap.create();
    private BiMap<String, String> authnContextWildcardMapping = HashBiMap.create();
    private List<AuthnContextMapping> authnContextMappings = new ArrayList<AuthnContextMapping>();
    private OIDCSettings oidcSettings;

    public IdpConnection() {
        this((String)null);
    }

    public IdpConnection(String entityId) {
        super(entityId);
    }

    public IdpConnection(IdpConnection conn) {
        super(conn);
        this.wantAuthnRequestsSigned = conn.wantAuthnRequestsSigned;
        this.singleSignOnServices = conn.singleSignOnServices != null ? conn.singleSignOnServices.clone() : null;
        this.targetAttributeMappings = conn.targetAttributeMappings != null ? new ArrayList<TargetAttributeMapping>(conn.targetAttributeMappings) : null;
        this.c2cContractMappings = conn.c2cContractMappings != null ? new ArrayList<C2cContractAttributeMapping>(conn.c2cContractMappings) : null;
        this.linking = conn.linking;
        this.assertionSigned = conn.assertionSigned;
        this.attributeAuthority = conn.attributeAuthority != null ? conn.attributeAuthority.clone() : null;
        this.maskedAttributeNames = conn.maskedAttributeNames != null ? new HashSet<String>(conn.maskedAttributeNames) : null;
        this.userProvisioning = conn.userProvisioning != null ? new UserProvisioning(conn.userProvisioning) : null;
        this.inboundProvisioning = conn.inboundProvisioning != null ? new ScimUserProvisioning(conn.inboundProvisioning) : null;
        this.errorPageMsg = conn.errorPageMsg;
        this.wsTrustSettings = conn.wsTrustSettings != null ? conn.wsTrustSettings.clone() : null;
        this.ssoToOAuthAttrMapping = conn.ssoToOAuthAttrMapping != null ? new UserKeyAttrMapping(conn.ssoToOAuthAttrMapping) : null;
        this.oAuthSettings = conn.oAuthSettings != null ? conn.oAuthSettings.clone() : null;
        this.defaultTargetResource = conn.defaultTargetResource != null ? conn.getDefaultTargetResource() : null;
        this.oAuthApcId = conn.oAuthApcId;
        this.authnContextMapping = conn.authnContextMapping != null ? HashBiMap.create(conn.authnContextMapping) : null;
        this.authnContextWildcardMapping = conn.authnContextWildcardMapping != null ? HashBiMap.create(conn.authnContextWildcardMapping) : null;
        this.authnContextMappings = conn.authnContextMappings != null ? new ArrayList<AuthnContextMapping>(conn.authnContextMappings) : null;
        this.oidcSettings = conn.oidcSettings != null ? conn.oidcSettings.clone() : null;
    }

    public EndpointGroup getSingleSignOnServices() {
        return this.singleSignOnServices;
    }

    public void setSingleSignOnServices(EndpointGroup singleSignOnServices) {
        this.singleSignOnServices = singleSignOnServices;
    }

    public boolean isWantAuthnRequestsSigned() {
        return this.wantAuthnRequestsSigned;
    }

    public void setWantAuthnRequestsSigned(boolean wantAuthnRequestsSigned) {
        this.wantAuthnRequestsSigned = wantAuthnRequestsSigned;
    }

    public Collection<TargetAttributeMapping> getTargetAttributeMappings() {
        return this.targetAttributeMappings;
    }

    public Collection<C2cContractAttributeMapping> getC2cContractMappings() {
        return this.c2cContractMappings;
    }

    public String getDefaultTargetResource() {
        return this.defaultTargetResource;
    }

    public void setDefaultTargetResource(String defaultTargetResource) {
        this.defaultTargetResource = defaultTargetResource;
    }

    public void setTargetAttributeMappings(Collection<TargetAttributeMapping> targetAttributeMappings) {
        this.targetAttributeMappings = targetAttributeMappings;
    }

    public void setC2cContractMappings(Collection<C2cContractAttributeMapping> connContractMappings) {
        this.c2cContractMappings = connContractMappings;
    }

    public boolean hasC2cContractMappings() {
        return this.c2cContractMappings != null && this.c2cContractMappings.size() != 0;
    }

    public AttributeMap executeAdapterMapping(AttributeMap assertionAttributes, String adapterId, AttributeMap contextAttributes) {
        AttributeMap attributes = null;
        TargetAttributeMapping targetAttributeMapping = null;
        AuthnAdapterInstance instance = (AuthnAdapterInstance)MgmtFactory.getSpAdapterManager().getInstanceWithConnectionOverride(adapterId, this.getEntityId());
        if (instance != null) {
            adapterId = instance.getId();
        }
        for (TargetAttributeMapping tempTargetAppMapping : this.getTargetAttributeMappings()) {
            if (!tempTargetAppMapping.getAdapterInstanceId().equals(adapterId)) continue;
            targetAttributeMapping = tempTargetAppMapping;
            break;
        }
        if (targetAttributeMapping == null) {
            String msg = "No target attribute mapping found for connection (" + this.getEntityId() + ") and adapterId (" + adapterId + ")";
            throw new ProcessRuntimeException(msg);
        }
        try {
            this.addExtendedPropertiesToContext(contextAttributes);
            attributes = targetAttributeMapping.executeMapping(assertionAttributes, contextAttributes);
            if (this.connectiontype == ConnectionBase.ConnectionType.DYNAMIC) {
                this.mergeUnMappedAttributes(attributes, targetAttributeMapping, assertionAttributes);
            }
        }
        catch (AttrLookupException | AuthorizationException e) {
            throw new ProcessRuntimeException(e);
        }
        return attributes;
    }

    public AttributeMap executeC2cMapping(AttributeMap assertionAttributes, String c2cContractId, AttributeMap contextAttributes) {
        C2cContractAttributeMapping c2cAttributeMapping = null;
        if (c2cContractId == null) {
            return null;
        }
        for (C2cContractAttributeMapping tempC2cMapping : this.getC2cContractMappings()) {
            if (!tempC2cMapping.getContractId().equals(c2cContractId)) continue;
            c2cAttributeMapping = tempC2cMapping;
            break;
        }
        if (c2cAttributeMapping == null) {
            String msg = "No authentication policy contract mapping found for connection (" + this.getEntityId() + ") and authentication policy contract (" + c2cContractId + ")";
            throw new ProcessRuntimeException(msg);
        }
        try {
            this.addExtendedPropertiesToContext(contextAttributes);
            return c2cAttributeMapping.executeMapping(assertionAttributes, contextAttributes);
        }
        catch (AttrLookupException | AuthorizationException e) {
            throw new ProcessRuntimeException(e);
        }
    }

    public static String getLocalIdSubstitutionKey() {
        ConfigStore config = ConfigStoreFarm.getConfig(IdpConnection.class);
        return config.getStringValue("LocalIdSubstitutionKey", "Local User ID");
    }

    public boolean doAccountLinking() {
        return this.isLinking();
    }

    @Override
    public Role getRoleType() {
        return Role.IDP;
    }

    public boolean isLinking() {
        return this.linking;
    }

    public void setLinking(boolean linking) {
        this.linking = linking;
    }

    public boolean isAssertionSigned() {
        return this.assertionSigned;
    }

    public void setAssertionSigned(boolean assertionSigned) {
        this.assertionSigned = assertionSigned;
    }

    @Override
    protected Endpoints getEndpoints() {
        return this.singleSignOnServices;
    }

    public AttributeAuthority getAttributeAuthority() {
        return this.attributeAuthority;
    }

    public void setAttributeAuthority(AttributeAuthority attributeQuerySettings) {
        this.attributeAuthority = attributeQuerySettings;
    }

    public UserProvisioning getUserProvisioning() {
        return this.userProvisioning;
    }

    public void setUserProvisioning(UserProvisioning userProvisioning) {
        this.userProvisioning = userProvisioning;
    }

    public boolean hasUserProvisioning() {
        return this.getUserProvisioning() != null;
    }

    public String getErrorPageMsg() {
        return this.errorPageMsg;
    }

    public void setErrorPageMsg(String errorPageMsg) {
        this.errorPageMsg = errorPageMsg;
    }

    @Override
    public LoggingMode getLoggingMode() {
        IdpConnection idpConnection = this;
        if (idpConnection.loggingMode.isIdpOverrideOn()) {
            IdpConnection idpConnection2 = this;
            return idpConnection2.loggingMode.getIdpOverrideMode();
        }
        return this.loggingMode;
    }

    public Set<String> getMaskedAttributeNames() {
        return this.maskedAttributeNames;
    }

    public void setMaskedAttributeNames(Set<String> maskedAttributeNames) {
        this.maskedAttributeNames = maskedAttributeNames;
    }

    private void mergeUnMappedAttributes(AttributeMap attributes, TargetAttributeMapping targetAttributeMapping, AttributeMap assertionAttributes) {
        if (assertionAttributes != null && !assertionAttributes.isEmpty()) {
            for (Map.Entry attribute : assertionAttributes.entrySet()) {
                String name = (String)attribute.getKey();
                if (targetAttributeMapping.isMapped(name) || attributes.containsKey((Object)name) || name.equals(AssertionMapKeys.getAuthnCtxKey()) || name.equals(AssertionMapKeys.getAuthnInstantKey()) || name.equals(AssertionMapKeys.getNameIdFormatKey())) continue;
                attributes.put(name, (AttributeValue)attribute.getValue());
            }
        }
    }

    @Override
    boolean specificHasExpressions() {
        if (this.targetAttributeMappings != null) {
            for (TargetAttributeMapping targetAttributeMapping : this.targetAttributeMappings) {
                if (!targetAttributeMapping.hasExpressions()) continue;
                return true;
            }
        }
        for (C2cContractAttributeMapping c2cContractAttributeMapping : this.c2cContractMappings) {
            if (!c2cContractAttributeMapping.hasExpressions()) continue;
            return true;
        }
        if (this.userProvisioning != null) {
            return this.userProvisioning.hasExpressions();
        }
        return false;
    }

    public OAuthSettings getOAuthSettings() {
        return this.oAuthSettings;
    }

    public void setOAuthSettings(OAuthSettings oAuthSettings) {
        this.oAuthSettings = oAuthSettings;
    }

    public ScimUserProvisioning getInboundProvisioning() {
        return this.inboundProvisioning;
    }

    public void setInboundProvisioning(ScimUserProvisioning inboundProvisioning) {
        this.inboundProvisioning = inboundProvisioning;
    }

    public WsTrustFederatedWspSettings getWsTrustSettings() {
        return this.wsTrustSettings;
    }

    public void setWsTrustSettings(WsTrustFederatedWspSettings wsTrustSettings) {
        this.wsTrustSettings = wsTrustSettings;
    }

    @Override
    public boolean doesWsTrustSettingsExist() {
        return this.wsTrustSettings != null;
    }

    public boolean doesOAuthSettingsExist() {
        return this.oAuthSettings != null;
    }

    @Override
    public boolean doesInboundProvisioningExist() {
        return this.inboundProvisioning != null;
    }

    public boolean doesOIDCRPSettingsExist() {
        return this.oidcSettings != null;
    }

    @Override
    public boolean doesInboundGroupProvisioningExist() {
        return this.doesInboundProvisioningExist() && this.inboundProvisioning.getWriteGroupsAttributeMapping() != null && this.inboundProvisioning.getWriteGroupsAttributeMapping().getAttributeMapping() != null && !this.inboundProvisioning.getWriteGroupsAttributeMapping().getAttributeMapping().isEmpty();
    }

    @Override
    public boolean isBrowserSsoProfileConfigured() {
        return this.getEnabledProfiles().isIdpInitiatedSSOEnabled() || this.getEnabledProfiles().isSpInitiatedSSOEnabled() || this.getAttributeAuthority() != null;
    }

    public UserKeyAttrMapping getSsoToOAuthAttrMapping() {
        return this.ssoToOAuthAttrMapping;
    }

    public void setSsoToOAuthAttrMapping(UserKeyAttrMapping ssoToOAuthAttrMapping) {
        this.ssoToOAuthAttrMapping = ssoToOAuthAttrMapping;
    }

    public boolean hasSsoToOAuthAttrMapping() {
        return this.getSsoToOAuthAttrMapping() != null;
    }

    public UserKeyAttributes mapOAuthAttributesFromSso(AttributeMap assertionAttributes, AttributeMap contextAttributes, boolean skipAuthorization) throws AttrLookupException, AuthorizationException {
        return this.getSsoToOAuthAttrMapping().execMapping(assertionAttributes, contextAttributes, skipAuthorization);
    }

    public String getOAuthApcId() {
        return this.oAuthApcId;
    }

    public void setOAuthApcId(String oAuthApcId) {
        this.oAuthApcId = oAuthApcId;
    }

    public boolean hasOAuthApcId() {
        return this.oAuthApcId != null;
    }

    public AttributeMap mapOAuthAttributesFromSAML(String tokenManagerId, AttributeMap assertionAttributes, AttributeMap contextAttributes) throws AttrLookupException, AuthorizationException {
        List<OAuthAssertionGrantMapping> mappingList = this.getOAuthSettings().getOAuthAssertionGrantMappingList();
        for (OAuthAssertionGrantMapping oAuthSAMLBearerMapping : mappingList) {
            if (!oAuthSAMLBearerMapping.getTokenManagerId().equals(tokenManagerId)) continue;
            return oAuthSAMLBearerMapping.executeMapping(assertionAttributes, null, contextAttributes);
        }
        return null;
    }

    public String getAuthnContextLocalToRemoteMapping(String localValue) {
        return this.getAuthnContextMappedValue(localValue, this.authnContextMapping, this.authnContextWildcardMapping);
    }

    public String getAuthnContextRemoteToLocalMapping(String remoteValue) {
        return this.getAuthnContextMappedValue(remoteValue, (BiMap<String, String>)this.authnContextMapping.inverse(), (BiMap<String, String>)this.authnContextWildcardMapping.inverse());
    }

    private String getAuthnContextMappedValue(String sourceValue, BiMap<String, String> mappings, BiMap<String, String> wildcardMappings) {
        if (mappings.containsKey((Object)sourceValue)) {
            String targetValue = (String)mappings.get((Object)sourceValue);
            return this.mapAuthnContextValue(sourceValue, targetValue);
        }
        if (wildcardMappings.containsKey((Object)sourceValue)) {
            String targetValue = (String)wildcardMappings.get((Object)sourceValue);
            return this.mapAuthnContextValue(sourceValue, targetValue);
        }
        if (wildcardMappings.containsKey((Object)"*")) {
            String targetValue = (String)wildcardMappings.get((Object)"*");
            return this.mapAuthnContextValue(sourceValue, targetValue);
        }
        return sourceValue;
    }

    private String mapAuthnContextValue(String sourceValue, String targetValue) {
        if ("*".equals(targetValue)) {
            return sourceValue;
        }
        return targetValue;
    }

    public List<AuthnContextMapping> getAuthnContextMappings() {
        return this.authnContextMappings;
    }

    public void setAuthnContextMappings(List<AuthnContextMapping> authnContextMappings) {
        this.authnContextMappings = Collections.emptyList();
        this.authnContextWildcardMapping = HashBiMap.create();
        this.authnContextMapping = HashBiMap.create();
        if (authnContextMappings != null) {
            this.authnContextMappings = authnContextMappings;
            for (AuthnContextMapping mapping : this.authnContextMappings) {
                if (mapping.getLocal().contains("*") || mapping.getRemote().contains("*")) {
                    this.authnContextWildcardMapping.put((Object)mapping.getLocal(), (Object)mapping.getRemote());
                    continue;
                }
                this.authnContextMapping.put((Object)mapping.getLocal(), (Object)mapping.getRemote());
            }
        }
    }

    public OIDCSettings getOidcSettings() {
        return this.oidcSettings;
    }

    public void setOidcSettings(OIDCSettings oidcSettings) {
        this.oidcSettings = oidcSettings;
    }

    @Override
    public Collection<ConfigurablePluginInstance> getConnBasedPluginOverrides(PluginManagementSupport.PluginManagementType pluginManagementType) {
        BasePluginInstance instance;
        ArrayList<ConfigurablePluginInstance> instances = new ArrayList<ConfigurablePluginInstance>();
        if (pluginManagementType == null || pluginManagementType == PluginManagementSupport.PluginManagementType.SP_ADAPTER) {
            for (TargetAttributeMapping targetAttributeMapping : this.getTargetAttributeMappings()) {
                instance = targetAttributeMapping.getConnectionOverrideInstance();
                if (instance == null) continue;
                instances.add(instance);
            }
        }
        if ((pluginManagementType == null || pluginManagementType == PluginManagementSupport.PluginManagementType.TOKEN_GENERATOR) && this.doesWsTrustSettingsExist()) {
            for (TokenPluginAttributeMapping tokenPluginAttributeMapping : this.getWsTrustSettings().getAssertionToTokenMappingsMappings()) {
                instance = tokenPluginAttributeMapping.getConnectionOverrideInstance();
                if (instance == null) continue;
                instances.add(instance);
            }
        }
        return instances;
    }
}

