/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.Endpoints;
import org.sourceid.util.Defense;

public class IndexedEndpoints
extends Endpoints
implements Cloneable {
    private static final long serialVersionUID = 20050515L;
    private SortedMap<Integer, Endpoint> endpoints = new TreeMap<Integer, Endpoint>();
    private Integer defaultIndex;

    public Endpoint getEndpoint(int index) {
        return (Endpoint)this.endpoints.get(index);
    }

    public void setEndpoint(int index, Endpoint endpoint) {
        this.endpoints.put(index, endpoint);
    }

    public boolean hasDefault() {
        return this.defaultIndex != null;
    }

    public Endpoint getDefault() {
        Defense.notNull(this.defaultIndex, "No default indexed endpoint available.");
        return this.getEndpoint(this.defaultIndex);
    }

    public void setDefault(int indexOfDefault) {
        if (this.getEndpoint(indexOfDefault) == null) {
            throw new IllegalArgumentException("Cannot set default: no endpoint indexed at " + indexOfDefault);
        }
        this.defaultIndex = indexOfDefault;
    }

    public Map<Integer, Endpoint> getEndpointsMap() {
        return this.endpoints;
    }

    @Override
    public Collection<Endpoint> getEndpoints() {
        return this.getEndpointsMap().values();
    }

    public Endpoint getFirstEndpoint() {
        Endpoint endpoint;
        block0: {
            Endpoint ept;
            Collection<Endpoint> endPts;
            block1: {
                endpoint = null;
                endPts = this.getEndpoints();
                if (endPts == null || endPts.isEmpty()) break block0;
                if (this.getEndpoint(0) == null) break block1;
                endpoint = this.getEndpoint(0);
                break block0;
            }
            Iterator<Endpoint> iterator = endPts.iterator();
            if (!iterator.hasNext()) break block0;
            endpoint = ept = iterator.next();
        }
        return endpoint;
    }

    public boolean isDefault(int index) {
        return this.defaultIndex != null && index == this.defaultIndex;
    }

    public boolean hasEndpoint(String url) {
        boolean match = false;
        for (Endpoint endpoint : this.endpoints.values()) {
            if (!endpoint.getFullLocation().equals(url)) continue;
            match = true;
        }
        return match;
    }

    public Integer getDefaultIndex() {
        return this.defaultIndex;
    }

    public String getBindingsAsCommaDelimList(String placeholderForEmptyEntry) {
        ArrayList<String> bindings = new ArrayList<String>();
        for (Endpoint e : this.getEndpoints()) {
            bindings.add(e.getBinding());
        }
        return Util.listToCommaDelimString(bindings);
    }

    public String getFullLocationAsCommaDelimList(String placeholderForEmptyEntry) {
        ArrayList<String> fullLocations = new ArrayList<String>();
        for (Endpoint e : this.getEndpoints()) {
            fullLocations.add(e.getFullLocation());
        }
        return Util.listToCommaDelimString(fullLocations);
    }

    public String getFullResponseLocationAsCommaDelimList(String placeholderForEmptyEntry) {
        ArrayList<String> fullResponseLocation = new ArrayList<String>();
        for (Endpoint e : this.getEndpoints()) {
            fullResponseLocation.add(e.getFullResponseLocation());
        }
        return Util.listToCommaDelimString(fullResponseLocation);
    }

    public IndexedEndpoints clone() {
        IndexedEndpoints clone = new IndexedEndpoints();
        clone.endpoints = new TreeMap<Integer, Endpoint>(this.endpoints);
        clone.defaultIndex = this.defaultIndex;
        return clone;
    }
}

