/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.security.KerberosCallbackHandler;
import java.util.Set;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.sourceid.saml20.domain.KerberosRealm;

public class KerberosContext {
    private KerberosRealm kerberosRealm;
    private LoginContext loginContext;
    private KerberosCallbackHandler kerberosCallbackHandler;

    public KerberosContext(KerberosRealm kerberosRealm) {
        this.kerberosRealm = kerberosRealm;
    }

    public KerberosRealm getKerberosRealm() {
        return this.kerberosRealm;
    }

    public void setKerberosRealm(KerberosRealm kerberosRealm) {
        this.kerberosRealm = kerberosRealm;
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    public KerberosCallbackHandler getKerberosCallbackHandler() {
        return this.kerberosCallbackHandler;
    }

    public void setKerberosCallbackHandler(KerberosCallbackHandler kerberosCallbackHandler) {
        this.kerberosCallbackHandler = kerberosCallbackHandler;
    }

    public boolean checkLoginContext() {
        if (this.loginContext != null && this.loginContext.getSubject() != null && this.loginContext.getSubject().getPrivateCredentials() != null) {
            boolean isCurrent = true;
            Set<Object> creds = this.loginContext.getSubject().getPrivateCredentials();
            for (Object e : creds) {
                if (!(e instanceof KerberosTicket)) continue;
                isCurrent &= ((KerberosTicket)e).isCurrent();
            }
            return isCurrent;
        }
        return false;
    }

    public void logout() {
        if (this.loginContext != null) {
            try {
                this.loginContext.login();
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
    }

    public Set<KerberosKey> getLoginContextKeySet() {
        if (this.loginContext == null) {
            throw new IllegalStateException("Login context not yet initialized");
        }
        return this.loginContext.getSubject().getPrivateCredentials(KerberosKey.class);
    }
}

