/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.AbstractPasswordCredentialValidatorResult;
import org.sourceid.saml20.domain.ActiveDirectoryPasswordCredentialValidatorResult;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.saml20.domain.GenericDirectoryPasswordCredentialValidatorResult;
import org.sourceid.saml20.domain.LDAPUsernamePasswordCredentialValidator;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.OracleDirectoryPasswordCredentialValidatorResult;
import org.sourceid.saml20.domain.OracleUnifiedDirectoryPasswordCredentialValidatorResult;
import org.sourceid.saml20.domain.PingDirectoryPasswordCredentialValidatorResult;

public class LDAPPasswordCredentialValidatorResult
extends AbstractPasswordCredentialValidatorResult {
    private static final long serialVersionUID = 20121119L;
    private static final Log log = LogFactory.getLog(LDAPPasswordCredentialValidatorResult.class);
    public static final String PASSWORD_RESET = "Password was reset and must be changed.";
    private String dataStoreName = "null";
    private String explanation = null;

    protected LDAPPasswordCredentialValidatorResult() {
        super(AuthenticationResultEnum.getDefaultValue());
    }

    protected LDAPPasswordCredentialValidatorResult(AuthenticationResultEnum authnResultEnum) {
        super(authnResultEnum);
    }

    protected LDAPPasswordCredentialValidatorResult(String explanation, AuthenticationResultEnum authnResultEnum) {
        super(authnResultEnum);
        this.explanation = explanation;
    }

    protected LDAPPasswordCredentialValidatorResult(String explanation, String msgKey, boolean isRecoverable) {
        super(msgKey, isRecoverable, true);
        this.explanation = explanation;
    }

    public String getExplanation() {
        return this.explanation;
    }

    private void setDataStoreName(LDAPUsernamePasswordCredentialValidator pcv) {
        this.dataStoreName = pcv == null || pcv.getDataSource() == null ? "null" : pcv.getDataSource().getDescription();
    }

    private void setDataStoreName(LdapDataSource ldapDataSource) {
        this.dataStoreName = ldapDataSource == null ? "null" : ldapDataSource.getDescription();
    }

    public void raiseException(String dataSourceId, AuthenticationResultEnum resultEnum) throws PasswordCredentialValidatorAuthnException {
        this.logLDAPResponse();
        if (resultEnum == null) {
            resultEnum = AuthenticationResultEnum.getDefaultValue();
        }
        throw new PasswordCredentialValidatorAuthnException(this.isRecoverable().booleanValue(), this.getMessageKey(), dataSourceId, resultEnum.getDisplayName());
    }

    public void raiseException(Throwable cause, String dataSourceId, AuthenticationResultEnum resultEnum) throws PasswordCredentialValidatorAuthnException {
        this.logLDAPResponse();
        if (resultEnum == null) {
            resultEnum = AuthenticationResultEnum.getDefaultValue();
        }
        throw new PasswordCredentialValidatorAuthnException(this.isRecoverable().booleanValue(), this.getMessageKey(), cause, dataSourceId, resultEnum.getDisplayName());
    }

    public static LDAPPasswordCredentialValidatorResult getByEnum(LDAPUsernamePasswordCredentialValidator pcv, AuthenticationResultEnum resultEnum) {
        if (pcv == null) {
            throw new IllegalArgumentException("pcv is null");
        }
        LDAPPasswordCredentialValidatorResult result = null;
        if (resultEnum == null) {
            resultEnum = AuthenticationResultEnum.getDefaultValue();
        }
        result = new LDAPPasswordCredentialValidatorResult(resultEnum);
        result.setDataStoreName(pcv);
        return result;
    }

    public static LDAPPasswordCredentialValidatorResult getByExplanation(LDAPUsernamePasswordCredentialValidator pcv, String explanation, List<LDAPUsernamePasswordCredentialValidator.CustomAuthorizationError> customAuthnErrorList, boolean enableCaseSensitiveMatch) {
        if (pcv == null) {
            throw new IllegalArgumentException("pcv is null");
        }
        return LDAPPasswordCredentialValidatorResult.getByExplanation(pcv.getDataSource(), explanation, customAuthnErrorList, enableCaseSensitiveMatch, true);
    }

    public static LDAPPasswordCredentialValidatorResult getByExplanation(LdapDataSource ldapDataSource, String explanation, boolean returnDefaultIfNoCaseFound) {
        return LDAPPasswordCredentialValidatorResult.getByExplanation(ldapDataSource, explanation, null, false, returnDefaultIfNoCaseFound);
    }

    public static LDAPPasswordCredentialValidatorResult getByExplanation(LdapDataSource ldapDataSource, String explanation, List<LDAPUsernamePasswordCredentialValidator.CustomAuthorizationError> customAuthnErrorList, boolean enableCaseSensitiveMatch, boolean returnDefaultIfNoCaseFound) {
        LDAPPasswordCredentialValidatorResult result = LDAPPasswordCredentialValidatorResult.getPcvResultFromExplanation(ldapDataSource, explanation, returnDefaultIfNoCaseFound);
        if (customAuthnErrorList != null) {
            for (LDAPUsernamePasswordCredentialValidator.CustomAuthorizationError customAuthnError : customAuthnErrorList) {
                if (!customAuthnError.matches(explanation, enableCaseSensitiveMatch)) continue;
                log.debug((Object)("Using authentication error override for expression: \"" + customAuthnError.getExpr() + "\"."));
                if ("use.message.properties.key".equals(customAuthnError.getId())) {
                    log.debug((Object)("Using message properties key " + customAuthnError.getMsgKey() + " for authentication error. It is a " + (result.isRecoverable() != false ? "recoverable error." : "non-recoverable error.")));
                    result = new LDAPPasswordCredentialValidatorResult(explanation, customAuthnError.getMsgKey(), (boolean)result.isRecoverable());
                    result.setDataStoreName(ldapDataSource);
                    return result;
                }
                AuthenticationResultEnum resultEnum = AuthenticationResultEnum.getById(customAuthnError.getId());
                if (resultEnum != null) {
                    log.debug((Object)("Using \"" + resultEnum.getDisplayName() + "\" for authentication error. It is a " + (resultEnum.isRecoverable() ? "recoverable error." : "non-recoverable error.")));
                    result = new LDAPPasswordCredentialValidatorResult(explanation, resultEnum);
                }
                result.setDataStoreName(ldapDataSource);
                return result;
            }
        }
        return result;
    }

    private static LDAPPasswordCredentialValidatorResult getPcvResultFromExplanation(LdapDataSource ldapDataSource, String explanation, boolean returnDefaultIfNoCaseFound) {
        LDAPPasswordCredentialValidatorResult result;
        if (explanation.startsWith("[ExtendedResult:")) {
            LDAPPasswordCredentialValidatorResult result2 = new LDAPPasswordCredentialValidatorResult(explanation, LDAPPasswordCredentialValidatorResult.policyViolationPasswordModifyExtendedResult(explanation));
            result2.setDataStoreName(ldapDataSource);
            return result2;
        }
        if (ldapDataSource.isActiveDirectoryType()) {
            result = ActiveDirectoryPasswordCredentialValidatorResult.getByExplanation(explanation);
        } else if (ldapDataSource.isSunOneType()) {
            result = OracleDirectoryPasswordCredentialValidatorResult.getByExplanation(explanation);
        } else if (ldapDataSource.isOracleUnifiedDirectoryType()) {
            result = OracleUnifiedDirectoryPasswordCredentialValidatorResult.getByExplanation(explanation);
        } else if (ldapDataSource.isPingDirectoryOrPingDSType()) {
            result = PingDirectoryPasswordCredentialValidatorResult.getByExplanation(explanation, returnDefaultIfNoCaseFound);
        } else if (ldapDataSource.isGenericType()) {
            result = GenericDirectoryPasswordCredentialValidatorResult.getByExplanation(explanation);
        } else {
            throw new IllegalStateException("Unknown data source type: " + ldapDataSource.getLdapType() + " (" + ldapDataSource.getLdapTypeDesc() + ")");
        }
        result.setDataStoreName(ldapDataSource);
        return result;
    }

    private static AuthenticationResultEnum policyViolationPasswordModifyExtendedResult(String explanation) {
        Pattern pattern = Pattern.compile("\\[ExtendedResult: error code (\\d+) - (.*)\\]");
        Matcher matcher = pattern.matcher(explanation);
        String errorCode = "";
        if (matcher.matches() && matcher.groupCount() > 0) {
            errorCode = matcher.group(1);
        } else {
            log.debug((Object)("Unable to parse ExtendedResult return code from explanation: " + explanation));
        }
        if ("53".equals(errorCode)) {
            return AuthenticationResultEnum.PASSWORD_POLICY_VIOLATED;
        }
        if (Integer.toString(49).equals(errorCode)) {
            return AuthenticationResultEnum.INVALID_CREDENTIALS_RECOVERABLE;
        }
        return AuthenticationResultEnum.getDefaultValue();
    }

    private void logLDAPResponse() {
        if (this.getExplanation() == null) {
            log.debug((Object)("LDAP error authenticating user in '" + this.dataStoreName + "'.  The response was interpreted as '" + this.getMessageKey() + "'."));
        } else {
            log.debug((Object)("LDAP server response from '" + this.dataStoreName + "': " + this.getExplanation() + ".  The response was interpreted as '" + this.getMessageKey() + "'."));
        }
    }
}

