/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.ldap.ConnectionInfo;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.LDAPUtilOptions;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.unboundid.ldap.sdk.schema.ObjectClassType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.PingOneConnection;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.datasource.tag.DataSourceTagUtil;
import org.sourceid.saml20.domain.datasource.tag.LdapInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.LdapTagConfig;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;

public class LdapDataSource
extends DataSource
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LdapDataSource.class);
    public static final String AUTHENTICATION_METHOD_ANONYMOUS = "none";
    public static final String AUTHENTICATION_METHOD_SIMPLE = "simple";
    public static final String AUTHENTICATION_METHOD_CLIENT_TLS_CERT = "clientTlsCert";
    public static final String CONNECTION_SECURITY_NONE = "none";
    public static final String CONNECTION_SECURITY_SSL = "ssl";
    public static final String CONNECTION_SECURITY_START_TLS = "startTls";
    public static final String PARAM_NAME_FILTER = "filter";
    public static final String PARAM_NAME_SEARCH_BASE = "search_base";
    public static final String PARAM_NAME_SEARCH_SCOPE = "search_scope";
    public static final String PARAM_NAME_MEMBEROF_NESTED_GROUP = "memberof_nested_group";
    public static final String PARAM_NAME_SEARCH_ATTRIBUTES = "search_attributes";
    public static final String ATTRIBUTE_DELIMITER = ",";
    public static final String ATTRIBUTE_OPTION_SEPARATOR = ";";
    public static final String LDAP_SEARCH_SCOPE_OBJECT_SCOPE = "OBJECT_SCOPE";
    public static final String LDAP_SEARCH_SCOPE_ONELEVEL_SCOPE = "ONELEVEL_SCOPE";
    public static final String LDAP_SEARCH_SCOPE_SUBTREE_SCOPE = "SUBTREE_SCOPE";
    public static final String GUID = "GUID";
    public static final String OBJECT_GUID = "objectGUID";
    public static final String SUBJECT_DN_KEY = "Subject DN";
    private final LdapInfo ldapInfo;
    private String errorMessage = "";
    private boolean isGatewayEnabled = false;

    public LdapDataSource() {
        this.ldapInfo = new LdapInfo();
    }

    public LdapDataSource(boolean isGatewayEnabled) {
        this.isGatewayEnabled = isGatewayEnabled;
        this.ldapInfo = new LdapInfo();
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        this.ldapInfo.setId(id);
    }

    @Override
    public void setDsName(String dsName) {
        super.setDsName(dsName);
        this.ldapInfo.setName(dsName);
    }

    public String getAuthenticationMethod() {
        return this.ldapInfo.getAuthenticationMethod();
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.ldapInfo.setAuthenticationMethod(authenticationMethod);
    }

    public String getCredentials() {
        return this.ldapInfo.getCredentials();
    }

    public void setCredentials(String credentials) {
        this.ldapInfo.setCredentials(credentials);
    }

    public String getClientTlsCertificate() {
        return this.ldapInfo.getClientTlsCertificate();
    }

    public void setClientTlsCertificate(String clientTlsCertificate) {
        this.ldapInfo.setClientTlsCertificate(clientTlsCertificate);
    }

    public String getPrincipal() {
        return this.ldapInfo.getPrincipal();
    }

    public void setPrincipal(String principal) {
        this.ldapInfo.setPrincipal(principal);
    }

    public String getHost() {
        return this.ldapInfo.getHost();
    }

    public void setHost(String host) {
        this.ldapInfo.setHost(host);
    }

    public boolean getUseSSL() {
        return this.ldapInfo.isUseSSL();
    }

    public void setUseSSL(boolean useSSL) {
        this.ldapInfo.setUseSSL(useSSL);
    }

    public boolean getAnonymousBinding() {
        return "none".equalsIgnoreCase(this.ldapInfo.getAuthenticationMethod());
    }

    public void setAnonymousBinding(boolean anonymous) {
        if (anonymous) {
            this.ldapInfo.setAuthenticationMethod("none");
        } else if ("none".equalsIgnoreCase(this.ldapInfo.getAuthenticationMethod())) {
            this.ldapInfo.setAuthenticationMethod(AUTHENTICATION_METHOD_SIMPLE);
        }
    }

    public List<LdapTagConfig> getLdapTagConfigList() {
        return this.ldapInfo.getLdapTagConfigList();
    }

    public void setLdapTagConfigList(List<LdapTagConfig> ldapTagMap) {
        this.ldapInfo.setLdapTagConfigList(ldapTagMap);
    }

    @Override
    public String toString() {
        return this.ldapInfo.toString();
    }

    public LdapDataSource getClone() {
        try {
            return (LdapDataSource)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getLDAPAttributeNameList() {
        List<Object> attrNames;
        block2: {
            attrNames = new ArrayList();
            try {
                LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getConnectionInfo(), (ServiceInformation)this);
                attrNames = ldapUtil.getLdapAttributeList();
                attrNames.sort(String::compareToIgnoreCase);
            }
            catch (NamingException nameEx) {
                log.error((Object)("Request for LDAP attribute name list from " + this.getDescription() + " failed. Error: " + nameEx.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)nameEx);
            }
        }
        return attrNames;
    }

    public List<String> getLDAPAttributeNameList(String objectClass) {
        ArrayList<String> attrNames;
        block2: {
            attrNames = new ArrayList<String>();
            try {
                LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getConnectionInfo(), (ServiceInformation)this);
                attrNames.addAll(ldapUtil.schemaSearch(objectClass));
                attrNames.sort(String::compareToIgnoreCase);
            }
            catch (NamingException nameEx) {
                log.error((Object)("Request for LDAP attribute name list from " + this.getDescription() + " failed. Error: " + nameEx.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)nameEx);
            }
        }
        return attrNames;
    }

    public List<String> getLDAPAttributeNameList(String[] objectClasses) {
        ArrayList<String> attrNames = new ArrayList<String>();
        for (String objectClass : objectClasses) {
            List<String> tmpList = this.getLDAPAttributeNameList(objectClass);
            this.mergeLists(attrNames, tmpList);
        }
        attrNames.sort(String::compareToIgnoreCase);
        return attrNames;
    }

    public AttributeMap getAttributesOfFirstMatchingObject(String searchBase, String filter, int searchScope, String[] attrs) throws NamingException {
        List<AttributeMap> r = this.getAttributesOfMatchingObjects(searchBase, filter, searchScope, attrs, 1);
        if (r.size() == 0) {
            return new AttributeMap();
        }
        return r.get(0);
    }

    public List<AttributeMap> getAttributesOfMatchingObjects(String searchBase, String filter, int searchScope, String[] attrs, int countLimit) throws NamingException {
        ConnectionInfo connInfo = this.getConnectionInfo();
        searchBase = StringUtils.defaultString((String)searchBase);
        LDAPUtil ldapUtil = LDAPUtil.newInstance(connInfo, (ServiceInformation)this);
        LDAPUtilOptions ldapOptions = new LDAPUtilOptions(searchBase, filter, searchScope);
        ldapOptions.setAttributes(attrs);
        ldapOptions.setCount(countLimit);
        List<AttributeMap> attributeMaps = ldapUtil.getAttributesOfMatchingObjects(ldapOptions);
        this.checkMaskedValues(attributeMaps);
        return attributeMaps;
    }

    public AttributeMap getAttributesOfMatchingGuid(String guid, String searchBase, String[] attrs) throws NamingException {
        ConnectionInfo connInfo = this.getConnectionInfo();
        LDAPUtil ldapUtil = LDAPUtil.newInstance(connInfo, (ServiceInformation)this);
        return ldapUtil.getLdapAttrsWithGuidAndSearchBase(guid, searchBase, attrs);
    }

    public AttributeMap getAttributesOfFirstMatchingObject(String searchBase, String filter, String searchScopeStr, String[] attrs) throws NamingException {
        return this.getAttributesOfFirstMatchingObject(searchBase, filter, this.getSearchScope(searchScopeStr), attrs);
    }

    private void checkMaskedValues(List<AttributeMap> attributeMaps) {
        for (AttributeMap attributeMap : attributeMaps) {
            for (AttributeValue attributeValue : attributeMap.values()) {
                this.checkSetMasked(attributeValue);
            }
        }
    }

    public void isConnectionSuccessful() throws NamingException, SecretManagerException {
        this.isConnectionSuccessful(null);
    }

    public void isConnectionSuccessful(SSLSocketFactory sslSocketFactory) throws NamingException, SecretManagerException {
        this.testConnection(sslSocketFactory);
    }

    public void testConnection() throws NamingException, SecretManagerException {
        this.testConnection(null);
    }

    public void testConnection(SSLSocketFactory sslSocketFactory) throws NamingException, SecretManagerException {
        long start = System.currentTimeMillis();
        try {
            if (sslSocketFactory == null) {
                LDAPUtil.testConnection(this.getConnectionInfo());
            } else {
                LDAPUtil.testConnection(this.getConnectionInfo(), sslSocketFactory);
            }
        }
        catch (SecretManagerException | NamingException e) {
            String errorMsg = e.getCause() != null ? e.getCause().toString() : e.toString();
            log.error((Object)("Failure occurred while testing LDAP connectivity: " + errorMsg));
            throw e;
        }
        finally {
            long finish = System.currentTimeMillis();
            log.debug((Object)("isConnectionSuccessful() on {" + this + "} returned  in " + (finish - start) + "ms"));
        }
    }

    public String getFullDNOfFirstMatchingObject(String searchBase, String filter, int searchScope, String[] attrs) throws NamingException {
        ConnectionInfo connInfo = this.getConnectionInfo();
        LDAPUtil ldapUtil = LDAPUtil.newInstance(connInfo, (ServiceInformation)this);
        LDAPUtilOptions ldapOptions = new LDAPUtilOptions(searchBase, filter, searchScope);
        ldapOptions.setAttributes(attrs);
        ldapOptions.setCount(1);
        List<String> results = ldapUtil.getDistinguishedName(ldapOptions);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    public ConnectionInfo getConnectionInfo() {
        ConnectionInfo connectionInfo;
        if (StringUtils.isNotBlank((String)this.ldapInfo.getPingOneConnection())) {
            PingOneConnection pingOneConnection = MgmtFactory.getPingOneConnectionsManager().getConnection(this.ldapInfo.getPingOneConnection());
            connectionInfo = new ConnectionInfo(this.ldapInfo.getPingOneConnection(), pingOneConnection.getCredential(), this.ldapInfo.getPingOneEnvironment(), this.ldapInfo.getPingOneGateway(), this.ldapInfo.getId(), this.ldapInfo.getName());
        } else {
            LdapInstanceIdentifier ldapInstanceIdentifier = DataSourceTagUtil.findMatchingDataSource(this.ldapInfo, (List<String>)PropertyInfo.getPingFederateNodeTags());
            String connectionUrl = this.ldapInfo.getServerUrl(ldapInstanceIdentifier.getHostname());
            connectionInfo = new ConnectionInfo(connectionUrl, this.ldapInfo.isUseSSL(), this.ldapInfo.getAuthenticationMethod(), this.ldapInfo.getPrincipal(), this.ldapInfo.getCredentials(), this.ldapInfo.getClientTlsCertificate(), this.ldapInfo.getId(), this.ldapInfo.getName(), this.ldapInfo.isUseDnsSrvRecords(), this.ldapInfo.isUseLdapReferral(), this.ldapInfo.getLdapType(), this.ldapInfo.isUseStartTLS());
            connectionInfo.setPoolOptions(this.ldapInfo.isTestOnBorrow(), this.ldapInfo.isTestOnReturn(), this.ldapInfo.isCreateIfNecessary(), this.ldapInfo.getMin(), this.ldapInfo.getMax(), this.ldapInfo.getMaxWait(), this.ldapInfo.getTimeBetweenEvictionRunsMillis(), this.ldapInfo.getReadTimeoutMillis(), this.ldapInfo.getConnTimeoutMillis(), this.ldapInfo.isVerifyHost(), this.ldapInfo.getDnsTtlMillis(), this.ldapInfo.isRetryFailedOperations());
        }
        if (this.ldapInfo.getBinaryAttributes() != null && !this.ldapInfo.getBinaryAttributes().isEmpty()) {
            connectionInfo.setBinaryAttributes(this.ldapInfo.getBinaryAttributes());
        }
        return connectionInfo;
    }

    public List<String> getObjectClasses(String entryName) {
        List<Object> objClassList;
        block2: {
            objClassList = new ArrayList();
            try {
                LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getConnectionInfo(), (ServiceInformation)this);
                objClassList = entryName != null ? ldapUtil.getObjectClasses(entryName) : ldapUtil.getAllObjectClasses();
                objClassList.sort(String::compareToIgnoreCase);
            }
            catch (NamingException nameEx) {
                log.error((Object)("Request for LDAP attribute name list from " + this.getDescription() + " failed. Error: " + nameEx.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)nameEx);
            }
        }
        return objClassList;
    }

    public List<String> getStructuralObjectClasses() {
        return this.getObjectClassesByType(ObjectClassType.STRUCTURAL);
    }

    public List<String> getAuxiliaryObjectClasses() {
        return this.getObjectClassesByType(ObjectClassType.AUXILIARY);
    }

    private List<String> getObjectClassesByType(ObjectClassType type) {
        List<Object> objClassList;
        block2: {
            objClassList = new ArrayList();
            try {
                LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getConnectionInfo(), (ServiceInformation)this);
                objClassList = ldapUtil.getObjectClassesByType(type);
                objClassList.sort(String::compareToIgnoreCase);
            }
            catch (NamingException nameEx) {
                log.error((Object)("Request for LDAP attribute name list from " + this.getDescription() + " failed. Error: " + nameEx.getMessage()));
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)nameEx);
            }
        }
        return objClassList;
    }

    public List<String> getObjectClasses() {
        return this.getObjectClasses(null);
    }

    private void mergeLists(List<String> destList, List<String> srcList) {
        for (String attributeName : srcList) {
            if (destList.contains(attributeName)) continue;
            destList.add(attributeName);
        }
    }

    private int getSearchScope(String scopeStr) {
        if (LDAP_SEARCH_SCOPE_OBJECT_SCOPE.equals(scopeStr)) {
            return 0;
        }
        if (LDAP_SEARCH_SCOPE_ONELEVEL_SCOPE.equals(scopeStr)) {
            return 1;
        }
        return 2;
    }

    @Override
    public String getDataSourceType() {
        return DataSource.DSType.LDAP.getName();
    }

    @Override
    public DataSource.DSType getDSType() {
        return DataSource.DSType.LDAP;
    }

    @Override
    public String getDescription() {
        return StringUtils.isBlank((String)this.description) ? this.getHost() : this.description;
    }

    public LdapInfo getLdapInfoClone() {
        return this.ldapInfo.clone();
    }

    public LdapInfo.LdapType getLdapType() {
        return this.ldapInfo.getLdapType();
    }

    public void setLdapType(LdapInfo.LdapType ldapType) {
        if (ldapType == LdapInfo.LdapType.UnboundID) {
            ldapType = LdapInfo.LdapType.PingDirectory;
        }
        this.ldapInfo.setLdapType(ldapType);
    }

    public void setLdapTypeDesc(String ldapTypeDesc) {
        if (ldapTypeDesc.equals("UnboundID Data Store")) {
            ldapTypeDesc = LdapInfo.LdapType.PingDirectory.getDescription();
        }
        this.ldapInfo.setLdapTypeDesc(ldapTypeDesc);
    }

    public String getLdapTypeDesc() {
        return this.ldapInfo.getLdapTypeDesc();
    }

    public boolean isActiveDirectoryType() {
        return this.ldapInfo.getLdapType().equals((Object)LdapInfo.LdapType.ActiveDirectory);
    }

    public boolean isSunOneType() {
        return this.ldapInfo.getLdapType().equals((Object)LdapInfo.LdapType.SunDirectoryServer);
    }

    public boolean isOracleUnifiedDirectoryType() {
        return LdapInfo.LdapType.OracleUnifiedDirectory.equals((Object)this.ldapInfo.getLdapType());
    }

    public boolean isPingDirectoryType() {
        return this.ldapInfo.getLdapType().equals((Object)LdapInfo.LdapType.UnboundID) || this.ldapInfo.getLdapType().equals((Object)LdapInfo.LdapType.PingDirectory);
    }

    public boolean isPingDSType() {
        return LdapInfo.LdapType.PingDS.equals((Object)this.ldapInfo.getLdapType());
    }

    public boolean isPingDirectoryOrPingDSType() {
        return this.isPingDirectoryType() || this.isPingDSType();
    }

    public boolean isGenericType() {
        return this.ldapInfo.getLdapType().equals((Object)LdapInfo.LdapType.Generic);
    }

    public String getServerUrl() {
        return this.ldapInfo.getServerUrl();
    }

    public boolean isTestOnBorrow() {
        return this.ldapInfo.isTestOnBorrow();
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.ldapInfo.setTestOnBorrow(testOnBorrow);
    }

    public boolean isTestOnReturn() {
        return this.ldapInfo.isTestOnReturn();
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.ldapInfo.setTestOnReturn(testOnReturn);
    }

    public boolean isCreateIfNecessary() {
        return this.ldapInfo.isCreateIfNecessary();
    }

    public void setCreateIfNecessary(boolean createIfNecessary) {
        this.ldapInfo.setCreateIfNecessary(createIfNecessary);
    }

    public boolean isRetryFailedOperations() {
        return this.ldapInfo.isRetryFailedOperations();
    }

    public void setRetryFailedOperations(boolean doRetries) {
        this.ldapInfo.setRetryFailedOperations(doRetries);
    }

    public int getMin() {
        return this.ldapInfo.getMin();
    }

    public void setMin(int min) {
        this.ldapInfo.setMin(min);
    }

    public int getMax() {
        return this.ldapInfo.getMax();
    }

    public void setMax(int max) {
        this.ldapInfo.setMax(max);
    }

    public int getMaxWait() {
        return this.ldapInfo.getMaxWait();
    }

    public void setMaxWait(int maxWait) {
        this.ldapInfo.setMaxWait(maxWait);
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.ldapInfo.getTimeBetweenEvictionRunsMillis();
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.ldapInfo.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public List<String> getBinaryAttributes() {
        return this.ldapInfo.getBinaryAttributes();
    }

    public void setBinaryAttributes(List<String> binaryAttributes) {
        this.ldapInfo.setBinaryAttributes(binaryAttributes);
    }

    public int getReadTimeoutMillis() {
        return this.ldapInfo.getReadTimeoutMillis();
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.ldapInfo.setReadTimeoutMillis(readTimeoutMillis);
    }

    public int getConnTimeoutMillis() {
        return this.ldapInfo.getConnTimeoutMillis();
    }

    public void setConnTimeoutMillis(int connTimeoutMillis) {
        this.ldapInfo.setConnTimeoutMillis(connTimeoutMillis);
    }

    public boolean isVerifyHost() {
        return this.ldapInfo.isVerifyHost();
    }

    public void setVerifyHost(boolean verifyHost) {
        this.ldapInfo.setVerifyHost(verifyHost);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getPasswordAttribute() {
        if (this.isActiveDirectoryType()) {
            return "unicodePwd";
        }
        return "userPassword";
    }

    public boolean isUseDnsSrvRecords() {
        return this.ldapInfo.isUseDnsSrvRecords();
    }

    public void setUseDnsSrvRecords(boolean useDnsSrvRecords) {
        this.ldapInfo.setUseDnsSrvRecords(useDnsSrvRecords);
    }

    public void setUseAdReferral(boolean useAdReferral) {
        this.ldapInfo.setUseLdapReferral(useAdReferral);
    }

    public boolean isUseAdReferral() {
        return this.ldapInfo.isUseLdapReferral();
    }

    public int getDnsTtlMillis() {
        return this.ldapInfo.getDnsTtlMillis();
    }

    public void setDnsTtlMillis(int dnsTtlMillis) {
        this.ldapInfo.setDnsTtlMillis(dnsTtlMillis);
    }

    public String getLdapDnsSrvPrefix() {
        return this.ldapInfo.getLdapDnsSrvPrefix();
    }

    public void setLdapDnsSrvPrefix(String ldapDnsSrvPrefix) {
        this.ldapInfo.setLdapDnsSrvPrefix(ldapDnsSrvPrefix);
    }

    public String getLdapsDnsSrvPrefix() {
        return this.ldapInfo.getLdapsDnsSrvPrefix();
    }

    public void setLdapsDnsSrvPrefix(String ldapsDnsSrvPrefix) {
        this.ldapInfo.setLdapsDnsSrvPrefix(ldapsDnsSrvPrefix);
    }

    public String getPingOneConnection() {
        return this.ldapInfo.getPingOneConnection();
    }

    public void setPingOneConnection(String pingOneConnection) {
        this.isGatewayEnabled = true;
        this.ldapInfo.setPingOneConnection(pingOneConnection);
    }

    public String getPingOneEnvironment() {
        return this.ldapInfo.getPingOneEnvironment();
    }

    public void setPingOneEnvironment(String pingOneEnvironment) {
        this.isGatewayEnabled = true;
        this.ldapInfo.setPingOneEnvironment(pingOneEnvironment);
    }

    public String getPingOneGateway() {
        return this.ldapInfo.getPingOneGateway();
    }

    public void setPingOneGateway(String pingOneGateway) {
        this.isGatewayEnabled = true;
        this.ldapInfo.setPingOneGateway(pingOneGateway);
    }

    public boolean isGatewayEnabled() {
        return this.isGatewayEnabled;
    }

    public boolean getUseStartTLS() {
        return this.ldapInfo.isUseStartTLS();
    }

    public void setUseStartTLS(boolean useStartTLS) {
        this.ldapInfo.setUseStartTLS(useStartTLS);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LdapDataSource object = (LdapDataSource)o;
        if (this.ldapInfo != null ? !this.ldapInfo.equals(object.ldapInfo) : object.ldapInfo != null) {
            return false;
        }
        return this.getDataSourceType().equals(this.getDataSourceType());
    }

    @Override
    public int hashCode() {
        int result = this.getDataSourceType().hashCode();
        result = 32 * result + (this.ldapInfo != null ? this.ldapInfo.hashCode() : 0);
        return result;
    }

    public static enum LdapAttrEncodingType {
        BASE64("Base64"),
        HEX("Hex"),
        SID("SID");

        private final String displayName;

        private LdapAttrEncodingType(String newDisplayName) {
            this.displayName = newDisplayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public LdapAttrEncodingType fromDisplayName(String displayName) {
            for (LdapAttrEncodingType ldapAttrDataType : LdapAttrEncodingType.values()) {
                if (!ldapAttrDataType.getDisplayName().equals(displayName)) continue;
                return ldapAttrDataType;
            }
            return null;
        }
    }
}

