/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.LookupableLabel;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;

public enum LoggingMode implements Serializable,
LookupableLabel
{
    NONE("No Logging"),
    STANDARD("Standard"),
    ENHANCED("Enhanced"),
    FULL("Full");

    private final String label;
    private static ConfigStore configStoreInstance;

    private LoggingMode(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public static LoggingMode fromLabel(String label) {
        for (LoggingMode mode : LoggingMode.values()) {
            if (!mode.label.equals(label)) continue;
            return mode;
        }
        return null;
    }

    private static ConfigStore getConfigStore() {
        return configStoreInstance;
    }

    public static boolean isIdpOverrideOn() {
        ConfigStore configStore = LoggingMode.getConfigStore();
        return configStore.getBooleanValue("IdPOverrideOn", false);
    }

    public static void setIdpOverrideOn(boolean on) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            ConfigStore configStore = LoggingMode.getConfigStore();
            configStore.setBooleanValue("IdPOverrideOn", on);
            auditLoggerScope.log(AdminAuditLogger.Component.GENERAL_SETTINGS, AdminAuditLogger.Event.MODIFY, "IDP logging override");
        }
    }

    public static LoggingMode getIdpOverrideMode() {
        ConfigStore configStore = LoggingMode.getConfigStore();
        return LoggingMode.valueOf(configStore.getStringValue("IdPOverrideMode", STANDARD.toString()));
    }

    public static void setIdpOverrideMode(LoggingMode mode) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            ConfigStore configStore = LoggingMode.getConfigStore();
            configStore.setStringValue("IdPOverrideMode", mode.toString());
            auditLoggerScope.log(AdminAuditLogger.Component.GENERAL_SETTINGS, AdminAuditLogger.Event.MODIFY, "IDP logging override mode");
        }
    }

    public static boolean isSpOverrideOn() {
        ConfigStore configStore = LoggingMode.getConfigStore();
        return configStore.getBooleanValue("SPOverrideOn", false);
    }

    public static void setSpOverrideOn(boolean on) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            ConfigStore configStore = LoggingMode.getConfigStore();
            configStore.setBooleanValue("SPOverrideOn", on);
            auditLoggerScope.log(AdminAuditLogger.Component.GENERAL_SETTINGS, AdminAuditLogger.Event.MODIFY, "SP logging override");
        }
    }

    public static LoggingMode getSpOverrideMode() {
        ConfigStore configStore = LoggingMode.getConfigStore();
        return LoggingMode.valueOf(configStore.getStringValue("SPOverrideMode", STANDARD.toString()));
    }

    public static void setSpOverrideMode(LoggingMode newMode) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            ConfigStore configStore = LoggingMode.getConfigStore();
            configStore.setStringValue("SPOverrideMode", newMode.toString());
            auditLoggerScope.log(AdminAuditLogger.Component.GENERAL_SETTINGS, AdminAuditLogger.Event.MODIFY, "SP logging override mode");
        }
    }

    static {
        configStoreInstance = ConfigStoreFarm.getConfig(LoggingMode.class);
    }
}

