/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.ognl.ExpressionCalculator;
import com.pingidentity.sdk.xml.XmlHelper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigurationException;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class MessageCustomization
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(MessageCustomization.class);
    public static final String ASSERTION_CONTEXT_NAME = "assertion";
    public static final String AUTHN_REQ_CONTEXT_NAME = "authn-request";
    public static final String RESPONSE_CONTEXT_NAME = "authn-response";
    public static final String ATTRIBUTES_VAR_NAME = "Attributes";
    public static final String ASSERTION_VAR_NAME = "AssertionType";
    public static final String ASSERTIONS_VAR_NAME = "AssertionTypes";
    public static final String HTTP_REQ_VAR_NAME = "HttpServletRequest";
    public static final String HTTP_RESP_VAR_NAME = "HttpServletResponse";
    public static final String XML_HELPER_VAR_NAME = "XmlHelper";
    public static final String AUTHN_REQ_VAR_NAME = "AuthnRequestDocument";
    public static final String RESP_DOC_VAR_NAME = "ResponseDocument";
    public static final String RSTR_VAR_NAME = "RequestSecurityTokenResponseDocument";
    public static final String RST_VAR_NAME = "RequestSecurityToken";
    public static final String INCOMING_SAML_ASSERTION_VAR_NAME = "IncomingSamlAssertion";
    public static final String RSTRC_VAR_NAME = "RequestSecurityTokenResponseCollectionDocument";
    public static final String CHAINED_ATTRS_VAR_NAME = "ChainedAttributes";
    public static final String FEDHUB_IDP_CONN_PARTNER_ID_VAR_NAME = "FedHubIdpConnPartnerId";
    public static final String FEDHUB_SP_CONN_PARTNER_ID_VAR_NAME = "FedHubSpConnPartnerId";
    public static final String FEDHUB_SP_CONN_NAME_VAR_NAME = "FedHubSpConnName";
    public static final String FEDHUB_SP_CONN_APPLICATION_NAME_VAR_NAME = "FedHubSpConnApplicationName";
    public static final String FEDHUB_INCOMING_REQ_VAR_NAME = "FedHubIncomingAuthnRequest";
    public static final String FEDHUB_OUTGOING_REQ_VAR_NAME = "FedHubOutgoingAuthnRequest";
    public static final String FEDHUB_INCOMING_RESP_VAR_NAME = "FedHubIncomingAuthnResponse";
    public static final String FEDHUB_SP_CONN_PROTOCOL_TYPE_VAR_NAME = "FedHubSpConnProtocolType";
    public static final String FEDHUB_IDP_CONN_PROTOCOL_TYPE_VAR_NAME = "FedHubIdpConnProtocolType";
    public static final String FEDHUB_OAUTH_CLIENT_ID_VAR_NAME = "FedHubOAuthClientId";
    public static final String FEDHUB_OAUTH_CLIENT_NAME_VAR_NAME = "FedHubOAuthClientName";
    private String expression;
    private Object parsedExpression;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Object getParsedExpression() throws OgnlException {
        if (this.parsedExpression == null) {
            this.parsedExpression = Ognl.parseExpression((String)this.expression);
        }
        return this.parsedExpression;
    }

    public static <T> T customize(MessageCustomization hook, Class<T> type, HttpServletRequest req, HttpServletResponse resp, T message, String messageVariableName, Map<String, Object> moreContext, Map<String, Object> stateParams) {
        if (hook != null && ExpressionManager.getInstance().isEvaluateExpressionsOn()) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put(HTTP_REQ_VAR_NAME, req);
            context.put(HTTP_RESP_VAR_NAME, resp);
            context.put(XML_HELPER_VAR_NAME, new XmlHelper());
            context.put(messageVariableName, message);
            if (moreContext != null) {
                context.putAll(moreContext);
            }
            if (context.containsKey(FEDHUB_IDP_CONN_PARTNER_ID_VAR_NAME) || context.containsKey(FEDHUB_SP_CONN_PARTNER_ID_VAR_NAME)) {
                XmlObject inRespXmlObject;
                XmlObject outReqXmlObject;
                IdpConnection idpConn;
                InMessageContext inRespMsgCtx = (InMessageContext)MessageCustomization.getFedhubMessageContext("FEDHUB_IN_RESP_CONTEXT", req, stateParams);
                OutMessageContext outReqMsgCtx = (OutMessageContext)MessageCustomization.getFedhubMessageContext("FEDHUB_OUT_REQ_CONTEXT", req, stateParams);
                XmlObject authnReq = MessageCustomization.getSpConnectionIncomingRequestMessage(req, stateParams);
                if (authnReq != null) {
                    context.put(FEDHUB_INCOMING_REQ_VAR_NAME, authnReq);
                }
                if (outReqMsgCtx != null && (idpConn = MetadataSupport.getIdpConnection(outReqMsgCtx.getEntityId())).getProtocol() == Protocol.SAML20 && (outReqXmlObject = outReqMsgCtx.getXmlObject()) != null) {
                    context.put(FEDHUB_OUTGOING_REQ_VAR_NAME, outReqXmlObject.copy());
                }
                if (inRespMsgCtx != null && (inRespXmlObject = inRespMsgCtx.getXmlObject()) != null) {
                    context.put(FEDHUB_INCOMING_RESP_VAR_NAME, inRespXmlObject.copy());
                }
            }
            try {
                Object result;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("invoking message customization expression with " + context.keySet()));
                }
                if (type.isInstance(result = ExpressionCalculator.calculate(hook.getParsedExpression(), context, context))) {
                    return type.cast(result);
                }
            }
            catch (OgnlException e) {
                throw new ProcessRuntimeException("Unable to process message customization expression.", e);
            }
        }
        return message;
    }

    public static XmlObject getSpConnectionIncomingRequestMessage(HttpServletRequest req, Map<String, Object> stateParams) {
        InMessageContext inReqMsgCtx = (InMessageContext)MessageCustomization.getFedhubMessageContext("FEDHUB_IN_REQ_CONTEXT", req, stateParams);
        if (inReqMsgCtx != null && !inReqMsgCtx.isUnsolicitedResponse() && !"oauth:authz".equals(inReqMsgCtx.getBinding())) {
            try {
                XmlObject inReqXmlObject;
                SpConnection spConn = MetadataSupport.getSpConnection(inReqMsgCtx.getEntityId());
                if (spConn.getProtocol() == Protocol.SAML20 && (inReqXmlObject = inReqMsgCtx.getXmlObject()) != null) {
                    return inReqXmlObject.copy();
                }
            }
            catch (ConfigurationException e) {
                log.debug((Object)"SP Connection not found, not adding FEDHUB_IN_REQ_CONTEXT attribute to evaluate any expressions.");
            }
        }
        return null;
    }

    private static Object getFedhubMessageContext(String messageName, HttpServletRequest req, Map<String, Object> stateParams) {
        Object messageContext = null;
        if (req.getAttribute(messageName) != null) {
            messageContext = req.getAttribute(messageName);
        } else if (stateParams.containsKey(messageName)) {
            messageContext = stateParams.get(messageName);
        }
        return messageContext;
    }

    public static Map<String, Object> getAssertionCustomisationContext(XmlObject assertion, AttributeMap attributes, IdpHashableAuthnBean[] authnBeans) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(ATTRIBUTES_VAR_NAME, attributes);
        context.put(ASSERTION_VAR_NAME, assertion);
        MessageCustomization.addIdpConnFedHubContext(context, authnBeans);
        return context;
    }

    public static Map<String, Object> getResponseCustomizeContext(SpConnection spConn, AttributeMap attributes, IdpHashableAuthnBean[] authnBeans) {
        return MessageCustomization.getResponseCustomizeContext(attributes, authnBeans, spConn.hasMessageCustomizationHook(RESPONSE_CONTEXT_NAME));
    }

    public static Map<String, Object> getResponseCustomizeContext(AttributeMap attributes, IdpHashableAuthnBean[] authnBeans, boolean hasResponseContext) {
        if (hasResponseContext) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put(ATTRIBUTES_VAR_NAME, attributes);
            MessageCustomization.addIdpConnFedHubContext(context, authnBeans);
            return context;
        }
        return null;
    }

    public static Map<String, Object> getAuthnReqCustomizeContext(IdpConnection idpConn, HttpServletRequest req) {
        InMessageContext inReqMsgCtx = (InMessageContext)req.getAttribute("FEDHUB_IN_REQ_CONTEXT");
        if (idpConn.hasMessageCustomizationHook(AUTHN_REQ_CONTEXT_NAME)) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            MessageCustomization.addSpConnFedHubContext(context, inReqMsgCtx);
            MessageCustomization.addOAuthClientFedHubContext(context, inReqMsgCtx);
            Map<String, Object> chainedAttributes = MessageCustomization.getChainedAttributesToContext(req);
            if (chainedAttributes != null && !chainedAttributes.isEmpty()) {
                context.put(CHAINED_ATTRS_VAR_NAME, chainedAttributes);
            }
            return context;
        }
        return null;
    }

    public static Map<String, Object> getChainedAttributesToContext(HttpServletRequest req) {
        Map chainedAttrs = (Map)req.getAttribute(CHAINED_ATTRS_VAR_NAME);
        return chainedAttrs;
    }

    private static void addIdpConnFedHubContext(Map<String, Object> context, IdpHashableAuthnBean[] authnBeans) {
        if (authnBeans != null) {
            for (IdpHashableAuthnBean authnBean : authnBeans) {
                AuthnSourceKey authnSourceKey = authnBean.getAuthnSourceKey();
                if (authnSourceKey.getType() != AuthnSourceKey.AuthnSourceType.IDP_CONN) continue;
                String idpConnId = authnSourceKey.getId();
                IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(idpConnId, true);
                context.put(FEDHUB_IDP_CONN_PARTNER_ID_VAR_NAME, idpConn.getEntityId());
                context.put(FEDHUB_IDP_CONN_PROTOCOL_TYPE_VAR_NAME, idpConn.getProtocol().name());
            }
        }
    }

    private static void addSpConnFedHubContext(Map<String, Object> context, InMessageContext inReqMsgCtx) {
        String spConnEntityId = MessageCustomization.getFedhubSpConnectionEntityId(inReqMsgCtx);
        if (spConnEntityId != null) {
            SpConnection spConn = MetadataSupport.getSpConnection(spConnEntityId);
            context.put(FEDHUB_SP_CONN_PARTNER_ID_VAR_NAME, spConnEntityId);
            context.put(FEDHUB_SP_CONN_PROTOCOL_TYPE_VAR_NAME, spConn.getProtocol().name());
            context.put(FEDHUB_SP_CONN_NAME_VAR_NAME, spConn.getName());
            context.put(FEDHUB_SP_CONN_APPLICATION_NAME_VAR_NAME, spConn.getApplicationName());
        }
    }

    private static void addOAuthClientFedHubContext(Map<String, Object> context, InMessageContext inMsgCtx) {
        if (inMsgCtx == null || !MessageCustomization.isOAuthBinding(inMsgCtx)) {
            return;
        }
        String clientId = inMsgCtx.getEntityId();
        if (StringUtils.isBlank((String)clientId)) {
            return;
        }
        Client client = MgmtFactory.getClientManager().getCachedClient(clientId);
        if (client == null) {
            return;
        }
        context.put(FEDHUB_OAUTH_CLIENT_ID_VAR_NAME, clientId);
        context.put(FEDHUB_OAUTH_CLIENT_NAME_VAR_NAME, client.getName());
    }

    public static String getFedhubSpConnectionEntityId(InMessageContext inReqMsgCtx) {
        if (inReqMsgCtx == null || MessageCustomization.isOAuthBinding(inReqMsgCtx)) {
            return null;
        }
        String spConnEntityId = inReqMsgCtx.getEntityId();
        if (StringUtils.isEmpty((String)spConnEntityId)) {
            return null;
        }
        try {
            MetadataSupport.getSpConnection(spConnEntityId);
        }
        catch (ConfigurationException e) {
            log.debug((Object)"SP Connection not found, invalid partner entity ID.");
            return null;
        }
        return spConnEntityId;
    }

    private static boolean isOAuthBinding(InMessageContext inMsgCtx) {
        Objects.requireNonNull(inMsgCtx, "inMsgCtx");
        return "oauth:authz".equals(inMsgCtx.getBinding()) || "oauth:user:authz:endpoint".equals(inMsgCtx.getBinding());
    }
}

