/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.openid.connect.bindings.OIDCBindingGroup;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.OIDCProfile;
import org.sourceid.saml20.domain.OIDCRequestParamSetting;

public class OIDCSettings
implements Serializable,
Cloneable {
    public static final String JARM_DISABLED = "disabled";
    public static final String JARM_QUERY_JWT = ResponseType.ResponseMode.query_jwt.getIdentifier();
    public static final String JARM_FORM_POST_JWT = ResponseType.ResponseMode.form_post_jwt.getIdentifier();
    private static final long serialVersionUID = 1L;
    private Endpoint tokenEndpoint;
    private Endpoint jwksUri;
    private Scope scopes = OIDCBindingGroup.REQUIRED_SCOPES;
    private OIDCProfile profile = OIDCProfile.BASIC;
    private String jwtSecuredAuthorizationResponseModeType = "disabled";
    private Endpoint userInfoEndpoint;
    private String clientId;
    private String clientSecret;
    private boolean skipSignatureValidation;
    private boolean isBasicAuth;
    private boolean isPrivateKeyJwtAuth;
    private boolean isClientSecretJwtAuth;
    private String type;
    private String lifetime;
    private String audience;
    private boolean includeNotBeforeClaim = false;
    private String signingAlgorithm;
    private String requestSigningAlgorithm;
    private List<OIDCRequestParamSetting> requestParams = new ArrayList<OIDCRequestParamSetting>();
    private boolean enableProofKeyForCodeExchange = false;
    private boolean trackUserSessionsForLogout = false;
    private Endpoint pushedAuthorizationRequestEndpoint;
    private Endpoint logoutEndpoint;

    public OIDCSettings(String clientId, String clientSecret, Endpoint tokenEndpoint, Endpoint jwksUri, OIDCProfile profile, String jwtSecuredAuthorizationResponseModeType, Endpoint userInfoEndpoint, boolean skipSignatureValidation, boolean isBasicAuth, boolean isPrivateKeyJwtAuth, boolean isClientSecretJwtAuth, String type, String lifetime, String audience, boolean includeNotBeforeClaim, String signingAlgorithm, String requestSigningAlgorithm, boolean enableProofKeyForCodeExchange, Endpoint pushedAuthorizationRequestEndpoint, Endpoint logoutEndpoint) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenEndpoint = tokenEndpoint;
        this.jwksUri = jwksUri;
        this.profile = profile;
        this.jwtSecuredAuthorizationResponseModeType = jwtSecuredAuthorizationResponseModeType;
        this.userInfoEndpoint = userInfoEndpoint;
        this.skipSignatureValidation = skipSignatureValidation;
        this.isBasicAuth = isBasicAuth;
        this.isPrivateKeyJwtAuth = isPrivateKeyJwtAuth;
        this.isClientSecretJwtAuth = isClientSecretJwtAuth;
        this.type = type;
        this.lifetime = lifetime;
        this.audience = audience;
        this.includeNotBeforeClaim = includeNotBeforeClaim;
        this.signingAlgorithm = signingAlgorithm;
        this.requestSigningAlgorithm = requestSigningAlgorithm;
        this.enableProofKeyForCodeExchange = enableProofKeyForCodeExchange;
        this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
        this.logoutEndpoint = logoutEndpoint;
    }

    public OIDCSettings() {
    }

    public Endpoint getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(Endpoint tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public Endpoint getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(Endpoint jwksUri) {
        this.jwksUri = jwksUri;
    }

    public Scope getScopes() {
        return this.scopes;
    }

    public void setScopes(Scope scopes) {
        this.scopes = scopes;
    }

    public OIDCProfile getProfile() {
        return this.profile;
    }

    public void setProfile(OIDCProfile profile) {
        this.profile = profile;
    }

    public String getJwtSecuredAuthorizationResponseModeType() {
        return this.jwtSecuredAuthorizationResponseModeType;
    }

    public void setJwtSecuredAuthorizationResponseModeType(String jwtSecuredAuthorizationResponseModeType) {
        this.jwtSecuredAuthorizationResponseModeType = jwtSecuredAuthorizationResponseModeType;
    }

    public Endpoint getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpoint(Endpoint userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public OIDCSettings clone() {
        try {
            return (OIDCSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    @XmlTransient
    public byte[] getSecretAsUtf8Bytes() {
        byte[] secret = null;
        try {
            String encoded = this.clientSecret;
            if (encoded != null) {
                secret = Obfuscator.deobfuscate(encoded).getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return secret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public boolean isBasicAuth() {
        return this.isBasicAuth;
    }

    public boolean isPrivateKeyJwtAuth() {
        return this.isPrivateKeyJwtAuth;
    }

    public void setPrivateKeyJwtAuth(boolean privateKeyJwtAuth) {
        this.isPrivateKeyJwtAuth = privateKeyJwtAuth;
    }

    public boolean isClientSecretJwtAuth() {
        return this.isClientSecretJwtAuth;
    }

    public void setClientSecretJwtAuth(boolean isClientSecretJwtAuth) {
        this.isClientSecretJwtAuth = isClientSecretJwtAuth;
    }

    public void setBasicAuth(boolean basicAuth) {
        this.isBasicAuth = basicAuth;
    }

    public boolean isSkipSignatureValidation() {
        return this.skipSignatureValidation;
    }

    public void setSkipSignatureValidation(boolean skipSignatureValidation) {
        this.skipSignatureValidation = skipSignatureValidation;
    }

    public List<OIDCRequestParamSetting> getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(List<OIDCRequestParamSetting> params) {
        this.requestParams = params;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public void setSigningAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    public String getRequestSigningAlgorithm() {
        return this.requestSigningAlgorithm;
    }

    public void setRequestSigningAlgorithm(String requestSigningAlgorithm) {
        this.requestSigningAlgorithm = requestSigningAlgorithm;
    }

    public boolean isEnableProofKeyForCodeExchange() {
        return this.enableProofKeyForCodeExchange;
    }

    public void setEnableProofKeyForCodeExchange(boolean enableProofKeyForCodeExchange) {
        this.enableProofKeyForCodeExchange = enableProofKeyForCodeExchange;
    }

    public boolean isTrackUserSessionsForLogout() {
        return this.trackUserSessionsForLogout;
    }

    public void setTrackUserSessionsForLogout(boolean trackUserSessionsForLogout) {
        this.trackUserSessionsForLogout = trackUserSessionsForLogout;
    }

    public Endpoint getPushedAuthorizationRequestEndpoint() {
        return this.pushedAuthorizationRequestEndpoint;
    }

    public void setPushedAuthorizationRequestEndpoint(Endpoint pushedAuthorizationRequestEndpoint) {
        this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
    }

    public Endpoint getLogoutEndpoint() {
        return this.logoutEndpoint;
    }

    public void setLogoutEndpoint(Endpoint logoutEndpoint) {
        this.logoutEndpoint = logoutEndpoint;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(String lifetime) {
        this.lifetime = lifetime;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public boolean isIncludeNotBeforeClaim() {
        return this.includeNotBeforeClaim;
    }

    public void setIncludeNotBeforeClaim(boolean includeNotBeforeClaim) {
        this.includeNotBeforeClaim = includeNotBeforeClaim;
    }
}

