/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.saml20.domain.LDAPPasswordCredentialValidatorResult;

public class OracleUnifiedDirectoryPasswordCredentialValidatorResult
extends LDAPPasswordCredentialValidatorResult {
    private static final long serialVersionUID = -3790457139704150187L;
    private static Log log = LogFactory.getLog(OracleUnifiedDirectoryPasswordCredentialValidatorResult.class);
    private static final Pattern pattern = Pattern.compile("\\[LDAP: error code (\\d+) - (.*)\\]");

    private OracleUnifiedDirectoryPasswordCredentialValidatorResult(String explanation, AuthenticationResultEnum resultEnum) {
        super(explanation, resultEnum);
    }

    static OracleUnifiedDirectoryPasswordCredentialValidatorResult getByExplanation(String explanation) {
        explanation = explanation == null ? "" : explanation;
        Matcher matcher = pattern.matcher(explanation);
        String errorCode = "";
        String errorMessage = "";
        if (matcher.matches() && matcher.groupCount() > 0) {
            errorCode = matcher.group(1);
            errorMessage = matcher.group(2);
            if (errorMessage == null) {
                errorMessage = "";
            }
        } else {
            log.debug((Object)("Unable to parse LDAP return code from explanation: " + explanation));
        }
        AuthenticationResultEnum resultEnum = null;
        switch (errorCode) {
            case "49": {
                if (errorMessage.contains("invalid credentials")) {
                    resultEnum = AuthenticationResultEnum.INVALID_CREDENTIALS;
                    break;
                }
                if (errorMessage.contains("not match any password(s)")) {
                    resultEnum = AuthenticationResultEnum.INVALID_CREDENTIALS;
                    break;
                }
                if (errorMessage.contains("password is expired")) {
                    resultEnum = AuthenticationResultEnum.PASSWORD_EXPIRED;
                    break;
                }
                if (errorMessage.contains("account has been administrative disabled")) {
                    resultEnum = AuthenticationResultEnum.ACCOUNT_DISABLED;
                    break;
                }
                if (!errorMessage.contains("account has been locked")) break;
                resultEnum = AuthenticationResultEnum.USER_ACCOUNT_LOCKED;
                break;
            }
            case "32": {
                if (!errorMessage.contains("no such object")) break;
                resultEnum = AuthenticationResultEnum.USER_NOT_FOUND;
                break;
            }
            case "19": {
                resultEnum = AuthenticationResultEnum.PASSWORD_POLICY_VIOLATED;
                break;
            }
            case "53": {
                if (errorMessage.contains("Password was reset and must be changed.")) {
                    resultEnum = AuthenticationResultEnum.USER_MUST_RESET_PASSWORD;
                    break;
                }
                if (!errorMessage.equalsIgnoreCase("The password cannot be changed because it has not been long enough since the last password change")) break;
                resultEnum = AuthenticationResultEnum.PASSWORD_POLICY_VIOLATED;
                break;
            }
        }
        if (resultEnum == null) {
            resultEnum = AuthenticationResultEnum.getDefaultValue();
            log.debug((Object)("Unknown response from Oracle Unified Directory server: " + explanation + ".  Using default value: '" + resultEnum.getMessageKey() + "'."));
        }
        return new OracleUnifiedDirectoryPasswordCredentialValidatorResult(explanation, resultEnum);
    }
}

