/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.pingidentity.common.security.KerberosException;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.pingonev2.InvalidGatewayCredentialException;
import com.pingidentity.pingonev2.PingOneEnvironment;
import com.pingidentity.pingonev2.PingOneGateway;
import com.pingidentity.pingonev2.PingOneV2APIClient;
import com.pingidentity.pingonev2.ValidateKerberosTicketResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.http.client.HttpClient;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.util.domain.Searchable;
import org.sourceid.util.domain.filter.ContainsCriteriaFilter;
import org.sourceid.util.domain.filter.ItemMultiValue;

@XmlRootElement
public class PingOneConnection {
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.domain.PingOneConnection");
    private static final String ENVIRONMENTS_CACHE_EXPIRY_SECS = "EnvironmentsCacheExpirySecs";
    private static final String ENVIRONMENTS_KEY = "environments";
    private String id;
    private String name;
    private String description;
    private boolean active;
    private String credential;
    private String encryptedCredential;
    private Date creationDate;
    private String credentialId;
    private String pingOneConnectionId;
    private String region;
    private String environmentId;
    private String organizationName;
    private String pingOneManagementApiEndpoint;
    private String pingOneAuthenticationApiEndpoint;
    private volatile PingOneV2APIClient apiClient;
    private final Cache<String, List<PingOneEnvironment>> environmentsCache = CacheBuilder.newBuilder().expireAfterWrite((long)configStore.getIntValue("EnvironmentsCacheExpirySecs", 10), TimeUnit.SECONDS).build();
    private final Cache<String, List<PingOneGateway>> gatewaysCache = CacheBuilder.newBuilder().expireAfterWrite((long)configStore.getIntValue("EnvironmentsCacheExpirySecs", 10), TimeUnit.SECONDS).build();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @XmlTransient
    public String getCredential() {
        if (this.credential == null && this.encryptedCredential != null) {
            this.credential = Obfuscator.deobfuscate(this.encryptedCredential);
        }
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
        this.apiClient = null;
        this.environmentsCache.invalidateAll();
        this.gatewaysCache.invalidateAll();
    }

    public String getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public void setEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        this.apiClient = null;
        this.environmentsCache.invalidateAll();
        this.gatewaysCache.invalidateAll();
    }

    public Date getCreationDate() {
        if (this.creationDate == null) {
            return null;
        }
        return new Date(this.creationDate.getTime());
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate == null ? null : new Date(creationDate.getTime());
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getPingOneManagementApiEndpoint() {
        return this.pingOneManagementApiEndpoint;
    }

    public void setPingOneManagementApiEndpoint(String pingOneManagementApiEndpoint) {
        this.pingOneManagementApiEndpoint = pingOneManagementApiEndpoint;
    }

    public String getPingOneAuthenticationApiEndpoint() {
        return this.pingOneAuthenticationApiEndpoint;
    }

    public void setPingOneAuthenticationApiEndpoint(String pingOneAuthenticationApiEndpoint) {
        this.pingOneAuthenticationApiEndpoint = pingOneAuthenticationApiEndpoint;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public String getPingOneConnectionId() {
        return this.pingOneConnectionId;
    }

    public void setPingOneConnectionId(String pingOneConnectionId) {
        this.pingOneConnectionId = pingOneConnectionId;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public List<PingOneEnvironment> getEnvironments(boolean refresh) throws IOException, InvalidGatewayCredentialException {
        List<PingOneEnvironment> result = (List<PingOneEnvironment>)this.environmentsCache.getIfPresent((Object)ENVIRONMENTS_KEY);
        if (result == null || refresh) {
            result = this.getApiClient().getEnvironments();
            this.environmentsCache.put((Object)ENVIRONMENTS_KEY, result);
        }
        return result;
    }

    public List<PingOneEnvironment> getEnvironments(boolean refresh, Integer page, Integer numberPerPage, String filterString) throws IOException, InvalidGatewayCredentialException {
        SearchCriteria searchCriteria2;
        List<PingOneEnvironment> environments = this.getEnvironments(refresh);
        Searchable searchable = searchCriteria -> {
            ContainsCriteriaFilter<PingOneEnvironment> filter = new ContainsCriteriaFilter<PingOneEnvironment>(p1env -> new ItemMultiValue<PingOneEnvironment, String>((PingOneEnvironment)p1env, (K[])new String[]{p1env.getId(), p1env.getName()}));
            List searchResults = filter.doFilter(searchCriteria.getQuery(), environments).stream().collect(Collectors.toList());
            if (searchCriteria.getStartIndex() >= searchResults.size()) {
                return new SearchResult(searchCriteria.getStartIndex(), Collections.emptyList());
            }
            searchResults = searchResults.parallelStream().sorted((env1, env2) -> env1.getName().compareToIgnoreCase(env2.getName())).collect(Collectors.toList());
            if (searchCriteria.getItemsRequested() == -1) {
                return new SearchResult(0, searchResults);
            }
            int fromIndex = searchCriteria.getStartIndex();
            int toIndex = Math.min(searchCriteria.getStartIndex() + searchCriteria.getItemsRequested(), searchResults.size());
            return new SearchResult(searchCriteria.getStartIndex(), searchResults.subList(fromIndex, toIndex));
        };
        if (page == null) {
            searchCriteria2 = new SearchCriteria.Builder().query(filterString).build();
        } else {
            int fromIndex = (page - 1) * numberPerPage;
            searchCriteria2 = new SearchCriteria.Builder(fromIndex, numberPerPage).query(filterString).build();
        }
        return searchable.search(searchCriteria2).getResults();
    }

    public List<PingOneGateway> getGateways(String environmentId, boolean refresh) throws IOException, InvalidGatewayCredentialException {
        List<PingOneGateway> result = (List<PingOneGateway>)this.gatewaysCache.getIfPresent((Object)environmentId);
        if (result == null || refresh) {
            result = this.getApiClient().getGateways(environmentId);
            this.gatewaysCache.put((Object)environmentId, result);
        }
        return result;
    }

    public ValidateKerberosTicketResponse validateKerberosTicket(byte[] kerberosToken, String environmentId, String gatewayId) throws InvalidGatewayCredentialException, IOException, KerberosException {
        return this.getApiClient().validateKerberosTicket(kerberosToken, environmentId, gatewayId);
    }

    private PingOneV2APIClient getApiClient() throws InvalidGatewayCredentialException {
        if (this.apiClient == null) {
            String credential = this.getCredential();
            if (credential == null) {
                throw new IllegalStateException("Connection credential is not yet initialized");
            }
            this.apiClient = new PingOneV2APIClient((HttpClient)HttpConnectionPoolingManager.getInstance().getDefaultClient(), credential);
        }
        return this.apiClient;
    }
}

