/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.password.ChallengeablePasswordCredential;
import com.pingidentity.sdk.password.PasswordChallengeResult;
import com.pingidentity.sdk.password.PasswordCredentialChallengeException;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import com.pingidentity.sdk.password.PasswordValidationException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.auth.radius.RadiusClient;
import org.sourceid.auth.radius.RadiusClientHelper;
import org.sourceid.auth.radius.RadiusResponse;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.HostnameValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.RadiusAdminUserException;
import org.sourceid.util.log.AttributeMap;

public class RadiusUsernamePasswordCredentialValidator
implements PasswordCredentialValidator,
ChallengeablePasswordCredential {
    private static final Log log = LogFactory.getLog(RadiusUsernamePasswordCredentialValidator.class);
    private static final String TYPE = "RADIUS Username Password Credential Validator";
    private static final String DESCRIPTION = "This password credential validator provides a means of verifying credentials using the RADIUS protocol.";
    private static final String VERSION = "1.0";
    private static final String RADIUS_SERVERS = "RADIUS Servers";
    private static final String RADIUS_SERVERS_DESCRIPTION = "A table of RADIUS servers.";
    private static final String HOST = "Hostname";
    private static final String HOST_DESCRIPTION = "The IP address of the RADIUS server.";
    private static final String AUTH_PORT = "Authentication Port";
    private static final String AUTH_PORT_DESCRIPTION = "The port used to authenticate to the RADIUS server.";
    private static final String AUTH_PROTOCOL = "Authentication Protocol";
    private static final String AUTH_PROTOCOL_DESCRIPTION = "The protocol used to authenticate to the RADIUS server.";
    private static final String SHARED_SECRET = "Shared Secret";
    private static final String SHARED_SECRET_DESCRIPTION = "The password shared between PingFederate and the RADIUS server.";
    private static final String TIMEOUT = "Timeout";
    private static final String TIMEOUT_DESCRIPTION = "Connection timeout in milliseconds.";
    private static final String RETRY_COUNT = "Retry Count";
    private static final String RETRY_COUNT_DESCRIPTION = "Number of times to retry a failed connection.";
    private static final String NAS_IDENTIFIER = "NAS Identifier";
    private static final String NAS_IDENTIFIER_DESCRIPTION = "The attribute identifying the NAS (Network Access Server) originating the request for access.";
    private static final int MAX_TIMEOUT_VALUE = 86400000;
    private static final int MAX_PORT_VALUE = 65535;
    private static final String ALLOW_CHALLENGE_RETRY_AFTER_REJECT = "Allow Challenge Retries after Access-Reject";
    private static final String ALLOW_RETRY_AFTER_REJECT_DESCRIPTION = "Enable additional challenge attempts after receiving an Access-Reject response from the RADIUS server";
    private boolean allowRetryAfterReject;
    private final PluginDescriptor descriptor;
    private final List<RadiusClient> radiusClients = new ArrayList<RadiusClient>();

    public RadiusUsernamePasswordCredentialValidator() {
        GuiConfigDescriptor guiDescriptor = new GuiConfigDescriptor();
        guiDescriptor.setDescription(DESCRIPTION);
        this.addConfigurationFields(guiDescriptor);
        this.descriptor = new PluginDescriptor(TYPE, (ConfigurablePlugin)this, guiDescriptor, VERSION);
        this.descriptor.setAttributeContractSet(Collections.singleton("username"));
        this.descriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.NOT_COMPLIANT));
        this.descriptor.setSupportsExtendedContract(true);
    }

    public void configure(Configuration configuration) {
        String nasIdentifier = configuration.getFieldValue(NAS_IDENTIFIER);
        int retryCount = configuration.getIntFieldValue(RETRY_COUNT);
        int timeout = configuration.getIntFieldValue(TIMEOUT);
        this.allowRetryAfterReject = configuration.getBooleanFieldValue(ALLOW_CHALLENGE_RETRY_AFTER_REJECT);
        Table radiusServersTable = configuration.getTable(RADIUS_SERVERS);
        if (radiusServersTable != null && radiusServersTable.getRows() != null) {
            for (Row radiusServerRow : radiusServersTable.getRows()) {
                String host = radiusServerRow.getFieldValue(HOST);
                String sharedSecret = radiusServerRow.getFieldValue(SHARED_SECRET);
                int authPort = radiusServerRow.getIntFieldValue(AUTH_PORT);
                RadiusClient.AuthProtocol authProtocol = RadiusClient.AuthProtocol.PAP;
                if (StringUtils.isNotEmpty((String)radiusServerRow.getFieldValue(AUTH_PROTOCOL))) {
                    authProtocol = RadiusClient.AuthProtocol.valueOf(radiusServerRow.getFieldValue(AUTH_PROTOCOL));
                }
                RadiusClient radiusClient = new RadiusClient(host, sharedSecret, authPort, authProtocol, nasIdentifier, retryCount, timeout);
                this.radiusClients.add(radiusClient);
            }
        }
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.descriptor;
    }

    public AttributeMap processPasswordCredential(String username, String password) throws PasswordValidationException {
        Map<String, List<String>> attributes;
        RadiusResponse response = this.authenticate(username, password, null);
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.put("username", new AttributeValue(username));
        if (response != null && (attributes = response.getAttributes()) != null) {
            for (Map.Entry<String, List<String>> attribute : attributes.entrySet()) {
                attributeMap.put(attribute.getKey(), new AttributeValue((Collection)attribute.getValue()));
            }
        }
        return attributeMap;
    }

    public PasswordChallengeResult challenge(String username, String password, Object state) {
        PasswordChallengeResult result = new PasswordChallengeResult();
        byte[] radiusState = null;
        if (state != null && state instanceof byte[]) {
            radiusState = (byte[])state;
        }
        if (StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password)) {
            throw new PasswordCredentialChallengeException(true, AuthenticationResultEnum.INVALID_CREDENTIALS.getMessageKey(), (Throwable)new RadiusAdminUserException(AdminUserException.Code.USER_PASSWORD, username, radiusState, null));
        }
        RadiusResponse response = null;
        try {
            response = this.authenticate(username, password, radiusState);
        }
        catch (PasswordCredentialValidatorAuthnException e) {
            RadiusAdminUserException radiusAdminUserException = (RadiusAdminUserException)e.getCause();
            if (AdminUserException.Code.RADIUS_ACCESS_REJECT.equals((Object)radiusAdminUserException.getCode()) && this.allowRetryAfterReject) {
                throw new PasswordCredentialChallengeException(true, AuthenticationResultEnum.INVALID_CREDENTIALS.getMessageKey(), (Throwable)radiusAdminUserException);
            }
            throw e;
        }
        if (response != null) {
            result.addAttributes(response.getAttributes());
        }
        return result;
    }

    private RadiusResponse authenticate(String username, String password, byte[] state) {
        RadiusResponse response = null;
        if (StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password)) {
            throw new PasswordCredentialValidatorAuthnException(true, AuthenticationResultEnum.INVALID_CREDENTIALS.getMessageKey());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("RADIUS Clients=" + this.radiusClients.toString()));
        }
        for (RadiusClient radiusClient : this.radiusClients) {
            try {
                response = RadiusClientHelper.authenticate(radiusClient, username, password, state);
                break;
            }
            catch (RadiusAdminUserException e) {
                switch (e.getCode()) {
                    case RADIUS_ACCESS_REJECT: {
                        throw new PasswordCredentialValidatorAuthnException(false, AuthenticationResultEnum.INVALID_CREDENTIALS.getMessageKey(), (Throwable)e);
                    }
                    case RADIUS_ACCESS_CHALLENGE: {
                        log.debug((Object)"Access Challenge response received, proceeding with prompting the user to answer a challenge question.");
                        throw new PasswordCredentialChallengeException(true, AuthenticationResultEnum.INVALID_CREDENTIALS.getMessageKey(), (Throwable)e);
                    }
                }
                throw new UnsupportedOperationException("Unsupported code: " + e.getCode());
            }
            catch (AdminUserException e) {
                log.warn((Object)("Unable to authenticate to host: " + radiusClient.getHost()));
            }
        }
        if (response == null) {
            throw new PasswordValidationException("Failed to authenticate to any of the specified hosts");
        }
        return response;
    }

    private void addConfigurationFields(GuiConfigDescriptor guiDescriptor) {
        RequiredFieldValidator requiredFieldValidator = new RequiredFieldValidator();
        TableDescriptor radiusServersTable = new TableDescriptor(RADIUS_SERVERS, RADIUS_SERVERS_DESCRIPTION);
        guiDescriptor.addValidator((ConfigurationValidator)new RadiusServersTableValidator());
        TextFieldDescriptor hostFieldDescriptor = new TextFieldDescriptor(HOST, HOST_DESCRIPTION);
        hostFieldDescriptor.addValidator((FieldValidator)requiredFieldValidator);
        hostFieldDescriptor.addValidator((FieldValidator)new HostnameValidator());
        radiusServersTable.addRowField((FieldDescriptor)hostFieldDescriptor);
        TextFieldDescriptor authPortFieldDescriptor = new TextFieldDescriptor(AUTH_PORT, AUTH_PORT_DESCRIPTION);
        authPortFieldDescriptor.addValidator((FieldValidator)requiredFieldValidator);
        authPortFieldDescriptor.addValidator((FieldValidator)new IntegerValidator(1, 65535));
        authPortFieldDescriptor.setDefaultValue(String.valueOf(1812));
        radiusServersTable.addRowField((FieldDescriptor)authPortFieldDescriptor);
        String[] options = new String[]{RadiusClient.AuthProtocol.PAP.toString(), RadiusClient.AuthProtocol.CHAP.toString()};
        RadioGroupFieldDescriptor authProtocol = new RadioGroupFieldDescriptor(AUTH_PROTOCOL, AUTH_PROTOCOL_DESCRIPTION, options);
        authProtocol.setDefaultValue(RadiusClient.AuthProtocol.PAP.toString());
        radiusServersTable.addRowField((FieldDescriptor)authProtocol);
        TextFieldDescriptor passwordFieldDescriptor = new TextFieldDescriptor(SHARED_SECRET, SHARED_SECRET_DESCRIPTION, true);
        passwordFieldDescriptor.addValidator((FieldValidator)requiredFieldValidator);
        radiusServersTable.addRowField((FieldDescriptor)passwordFieldDescriptor);
        guiDescriptor.addTable(radiusServersTable);
        TextFieldDescriptor nasIdentifierFieldDescriptor = new TextFieldDescriptor(NAS_IDENTIFIER, NAS_IDENTIFIER_DESCRIPTION);
        nasIdentifierFieldDescriptor.addValidator((FieldValidator)requiredFieldValidator);
        nasIdentifierFieldDescriptor.setDefaultValue("PingFederate");
        guiDescriptor.addAdvancedField((FieldDescriptor)nasIdentifierFieldDescriptor);
        TextFieldDescriptor timeoutFieldDescriptor = new TextFieldDescriptor(TIMEOUT, TIMEOUT_DESCRIPTION);
        timeoutFieldDescriptor.addValidator((FieldValidator)requiredFieldValidator);
        timeoutFieldDescriptor.addValidator((FieldValidator)new IntegerValidator(1, 86400000));
        timeoutFieldDescriptor.setDefaultValue(String.valueOf(3000));
        guiDescriptor.addAdvancedField((FieldDescriptor)timeoutFieldDescriptor);
        TextFieldDescriptor retryCountFieldDescriptor = new TextFieldDescriptor(RETRY_COUNT, RETRY_COUNT_DESCRIPTION);
        retryCountFieldDescriptor.addValidator((FieldValidator)requiredFieldValidator);
        retryCountFieldDescriptor.addValidator((FieldValidator)new IntegerValidator(1, Integer.MAX_VALUE));
        retryCountFieldDescriptor.setDefaultValue(String.valueOf(3));
        guiDescriptor.addAdvancedField((FieldDescriptor)retryCountFieldDescriptor);
        CheckBoxFieldDescriptor allowRetryChallengeDescriptor = new CheckBoxFieldDescriptor(ALLOW_CHALLENGE_RETRY_AFTER_REJECT, ALLOW_RETRY_AFTER_REJECT_DESCRIPTION);
        allowRetryChallengeDescriptor.setDefaultValue(false);
        guiDescriptor.addAdvancedField((FieldDescriptor)allowRetryChallengeDescriptor);
    }

    private class RadiusServersTableValidator
    implements ConfigurationValidator {
        private RadiusServersTableValidator() {
        }

        public void validate(Configuration configuration) throws ValidationException {
            Table table = configuration.getTable(RadiusUsernamePasswordCredentialValidator.RADIUS_SERVERS);
            List rows = table.getRows();
            if (rows.isEmpty()) {
                throw new ValidationException("Please add at least one server to the 'RADIUS Servers' table.");
            }
            ArrayList<CallSite> errors = new ArrayList<CallSite>();
            HashSet<String> hosts = new HashSet<String>();
            for (Row row : rows) {
                String host = row.getFieldValue(RadiusUsernamePasswordCredentialValidator.HOST);
                if (hosts.add(host)) continue;
                errors.add((CallSite)((Object)("Duplicate server: " + host)));
            }
            if (!errors.isEmpty()) {
                throw new ValidationException(errors);
            }
        }
    }
}

