/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;

public class SamlNameID
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String value;
    private String format;
    private String nameQualifier;
    private String spNameQualifier;
    private String spProvidedID;

    public SamlNameID() {
    }

    public SamlNameID(String value) {
        this.value = value;
    }

    public SamlNameID(SamlNameID other) {
        this.value = other.value;
        this.format = other.format;
        this.nameQualifier = other.nameQualifier;
        this.spNameQualifier = other.spNameQualifier;
        this.spProvidedID = other.spProvidedID;
    }

    public SamlNameID(NameIDType nameIdType) {
        this.value = nameIdType.getStringValue();
        this.format = nameIdType.getFormat();
        this.nameQualifier = nameIdType.getNameQualifier();
        this.spNameQualifier = nameIdType.getSPNameQualifier();
        this.spProvidedID = nameIdType.getSPProvidedID();
    }

    public String getValue() {
        return this.value;
    }

    public String getFormat() {
        return this.format;
    }

    public String getNameQualifier() {
        return this.nameQualifier;
    }

    public String getSPNameQualifier() {
        return this.spNameQualifier;
    }

    public String getSPProvidedID() {
        return this.spProvidedID;
    }

    @JsonIgnore
    public NameIDType getNameIDType() {
        NameIDType nameIdType = NameIDType.Factory.newInstance();
        nameIdType.setStringValue(this.value);
        if (this.format != null) {
            nameIdType.setFormat(this.format);
        }
        if (this.nameQualifier != null) {
            nameIdType.setNameQualifier(this.nameQualifier);
        }
        if (this.spNameQualifier != null) {
            nameIdType.setSPNameQualifier(this.spNameQualifier);
        }
        if (this.spProvidedID != null) {
            nameIdType.setSPProvidedID(this.spProvidedID);
        }
        return nameIdType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.nameQualifier == null ? 0 : this.nameQualifier.hashCode());
        result = 31 * result + (this.spNameQualifier == null ? 0 : this.spNameQualifier.hashCode());
        result = 31 * result + (this.spProvidedID == null ? 0 : this.spProvidedID.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SamlNameID other = (SamlNameID)obj;
        if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
            return false;
        }
        if (this.nameQualifier == null ? other.nameQualifier != null : !this.nameQualifier.equals(other.nameQualifier)) {
            return false;
        }
        if (this.spNameQualifier == null ? other.spNameQualifier != null : !this.spNameQualifier.equals(other.spNameQualifier)) {
            return false;
        }
        if (this.spProvidedID == null ? other.spProvidedID != null : !this.spProvidedID.equals(other.spProvidedID)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

