/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.domain.EnterpriseUserConstants;
import org.sourceid.saml20.domain.ScimUserConstants;

public class Scim2UserConstants
implements ScimUserConstants {
    @Override
    public List<String> getAllIds() {
        List<String> allIds = AttributeNames.getAllIds();
        allIds.addAll(EnterpriseUserConstants.getAllIds());
        return allIds;
    }

    @Override
    public List<String> getAllIdsForReadUsers() {
        ArrayList<AttributeNames> notReadable = new ArrayList<AttributeNames>();
        notReadable.add(AttributeNames.PASSWORD);
        notReadable.add(AttributeNames.ID);
        notReadable.add(AttributeNames.ACTIVE);
        notReadable.add(AttributeNames.META_VERSION);
        notReadable.add(AttributeNames.META_LOCATION);
        notReadable.add(AttributeNames.META_CREATED);
        notReadable.add(AttributeNames.META_LAST_MODIFIED);
        ArrayList<String> ids = new ArrayList<String>();
        for (AttributeNames c : AttributeNames.values()) {
            if (notReadable.contains((Object)c)) continue;
            ids.add(c.getId());
        }
        ids.addAll(EnterpriseUserConstants.getAllIds());
        return ids;
    }

    @Override
    public List<String> getAllMappableIdsForWriteUsers() {
        ArrayList<AttributeNames> notMappable = new ArrayList<AttributeNames>();
        notMappable.add(AttributeNames.ID);
        notMappable.add(AttributeNames.ACTIVE);
        notMappable.add(AttributeNames.META_VERSION);
        notMappable.add(AttributeNames.META_LOCATION);
        notMappable.add(AttributeNames.META_CREATED);
        notMappable.add(AttributeNames.META_LAST_MODIFIED);
        ArrayList<String> ids = new ArrayList<String>();
        for (AttributeNames c : AttributeNames.values()) {
            if (notMappable.contains((Object)c)) continue;
            ids.add(c.getId());
        }
        ids.addAll(EnterpriseUserConstants.getAllIds());
        Collections.sort(ids);
        return ids;
    }

    @Override
    public List<String> getAllMappableIdsForIdentityStorePluginWriteUsers() {
        ArrayList<String> ids = new ArrayList<String>();
        for (AttributeNames c : AttributeNames.values()) {
            ids.add(c.getId());
        }
        ids.addAll(EnterpriseUserConstants.getAllIds());
        Collections.sort(ids);
        return ids;
    }

    public List<String> getRootAttributeNames() {
        return RootAttributeNames.getAllIds();
    }

    private static enum RootAttributeNames {
        EMAILS("emails"),
        ADDRESSES("addresses"),
        PHONE_NUMBERS("phoneNumbers"),
        IMS("ims"),
        PHOTOS("photos"),
        ENTITLEMENTS("entitlements"),
        ROLES("roles"),
        X509CERTIFICATES("x509Certificates");

        private String id;

        private RootAttributeNames(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static List<String> getAllIds() {
            ArrayList<String> ids = new ArrayList<String>();
            for (RootAttributeNames n : RootAttributeNames.values()) {
                ids.add(n.getId());
            }
            Collections.sort(ids);
            return ids;
        }
    }

    static enum AttributeNames {
        ID("id"),
        EXTERNAL_ID("externalId"),
        SCHEMA_USERS("schema.users"),
        USER_NAME("userName"),
        NAME_FORMATTED("name.formatted"),
        NAME_FAMILY_NAME("name.familyName"),
        NAME_GIVEN_NAME("name.givenName"),
        NAME_MIDDLE_NAME("name.middleName"),
        NAME_HONORIFIC_PREFIX("name.honorificPrefix"),
        NAME_HONORIFIC_SUFFIX("name.honorificSuffix"),
        DISPLAY_NAME("displayName"),
        NICK_NAME("nickName"),
        PROFILE_URL("profileUrl"),
        EMAILS_WORK_TYPE("emails.work.type"),
        EMAILS_WORK_VALUE("emails.work.value"),
        EMAILS_WORK_IS_PRIMARY("emails.work.primary"),
        EMAILS_HOME_TYPE("emails.home.type"),
        EMAILS_HOME_VALUE("emails.home.value"),
        EMAILS_HOME_IS_PRIMARY("emails.home.primary"),
        EMAILS_OTHER_TYPE("emails.other.type"),
        EMAILS_OTHER_VALUE("emails.other.value"),
        EMAILS_OTHER_IS_PRIMARY("emails.other.primary"),
        ADDRESSES_WORK_TYPE("addresses.work.type"),
        ADDRESSES_WORK_STREET_ADDRESS("addresses.work.streetAddress"),
        ADDRESSES_WORK_LOCALITY("addresses.work.locality"),
        ADDRESSES_WORK_REGION("addresses.work.region"),
        ADDRESSES_WORK_POSTAL_CODE("addresses.work.postalCode"),
        ADDRESSES_WORK_COUNTRY("addresses.work.country"),
        ADDRESSES_WORK_FORMATTED("addresses.work.formatted"),
        ADDRESSES_WORK_IS_PRIMARY("addresses.work.primary"),
        ADDRESSES_HOME_TYPE("addresses.home.type"),
        ADDRESSES_HOME_STREET_ADDRESS("addresses.home.streetAddress"),
        ADDRESSES_HOME_LOCALITY("addresses.home.locality"),
        ADDRESSES_HOME_REGION("addresses.home.region"),
        ADDRESSES_HOME_POSTAL_CODE("addresses.home.postalCode"),
        ADDRESSES_HOME_COUNTRY("addresses.home.country"),
        ADDRESSES_HOME_FORMATTED("addresses.home.formatted"),
        ADDRESSES_HOME_IS_PRIMARY("addresses.home.primary"),
        ADDRESSES_OTHER_TYPE("addresses.other.type"),
        ADDRESSES_OTHER_STREET_ADDRESS("addresses.other.streetAddress"),
        ADDRESSES_OTHER_LOCALITY("addresses.other.locality"),
        ADDRESSES_OTHER_REGION("addresses.other.region"),
        ADDRESSES_OTHER_POSTAL_CODE("addresses.other.postalCode"),
        ADDRESSES_OTHER_COUNTRY("addresses.other.country"),
        ADDRESSES_OTHER_FORMATTED("addresses.other.formatted"),
        ADDRESSES_OTHER_IS_PRIMARY("addresses.other.primary"),
        PHONE_NUMBERS_WORK_TYPE("phoneNumbers.work.type"),
        PHONE_NUMBERS_WORK_VALUE("phoneNumbers.work.value"),
        PHONE_NUMBERS_WORK_IS_PRIMARY("phoneNumbers.work.primary"),
        PHONE_NUMBERS_HOME_TYPE("phoneNumbers.home.type"),
        PHONE_NUMBERS_HOME_VALUE("phoneNumbers.home.value"),
        PHONE_NUMBERS_HOME_IS_PRIMARY("phoneNumbers.home.primary"),
        PHONE_NUMBERS_MOBILE_TYPE("phoneNumbers.mobile.type"),
        PHONE_NUMBERS_MOBILE_VALUE("phoneNumbers.mobile.value"),
        PHONE_NUMBERS_MOBILE_IS_PRIMARY("phoneNumbers.mobile.primary"),
        PHONE_NUMBERS_FAX_TYPE("phoneNumbers.fax.type"),
        PHONE_NUMBERS_FAX_VALUE("phoneNumbers.fax.value"),
        PHONE_NUMBERS_FAX_IS_PRIMARY("phoneNumbers.fax.primary"),
        PHONE_NUMBERS_PAGER_TYPE("phoneNumbers.pager.type"),
        PHONE_NUMBERS_PAGER_VALUE("phoneNumbers.pager.value"),
        PHONE_NUMBERS_PAGER_IS_PRIMARY("phoneNumbers.pager.primary"),
        PHONE_NUMBERS_OTHER_TYPE("phoneNumbers.other.type"),
        PHONE_NUMBERS_OTHER_VALUE("phoneNumbers.other.value"),
        PHONE_NUMBERS_OTHER_IS_PRIMARY("phoneNumbers.other.primary"),
        IMS_AIM_TYPE("ims.aim.type"),
        IMS_AIM_VALUE("ims.aim.value"),
        IMS_AIM_IS_PRIMARY("ims.aim.primary"),
        IMS_GTALK_TYPE("ims.gtalk.type"),
        IMS_GTALK_VALUE("ims.gtalk.value"),
        IMS_GTALK_IS_PRIMARY("ims.gtalk.primary"),
        IMS_ICQ_TYPE("ims.icq.type"),
        IMS_ICQ_VALUE("ims.icq.value"),
        IMS_ICQ_IS_PRIMARY("ims.icq.primary"),
        IMS_XMPP_TYPE("ims.xmpp.type"),
        IMS_XMPP_VALUE("ims.xmpp.value"),
        IMS_XMPP_IS_PRIMARY("ims.xmpp.primary"),
        IMS_MSN_TYPE("ims.msn.type"),
        IMS_MSN_VALUE("ims.msn.value"),
        IMS_MSN_IS_PRIMARY("ims.msn.primary"),
        IMS_SKYPE_TYPE("ims.skype.type"),
        IMS_SKYPE_VALUE("ims.skype.value"),
        IMS_SKYPE_IS_PRIMARY("ims.skype.primary"),
        IMS_QQ_TYPE("ims.qq.type"),
        IMS_QQ_VALUE("ims.qq.value"),
        IMS_QQ_IS_PRIMARY("ims.qq.primary"),
        IMS_YAHOO_TYPE("ims.yahoo.type"),
        IMS_YAHOO_VALUE("ims.yahoo.value"),
        IMS_YAHOO_IS_PRIMARY("ims.yahoo.primary"),
        PHOTOS_PHOTO_TYPE("photos.photo.type"),
        PHOTOS_PHOTO_VALUE("photos.photo.value"),
        PHOTOS_PHOTO_IS_PRIMARY("photos.photo.primary"),
        PHOTOS_THUMBNAIL_TYPE("photos.thumbnail.type"),
        PHOTOS_THUMBNAIL_VALUE("photos.thumbnail.value"),
        PHOTOS_THUMBNAIL_IS_PRIMARY("photos.thumbnail.primary"),
        ENTITLEMENTS_VALUES("entitlements.value"),
        ROLES_VALUES("roles.values"),
        X509CERTIFICATES("x509Certificates"),
        USER_TYPE("userType"),
        TITLE("title"),
        PREFERRED_LANGUAGE("preferredLanguage"),
        LOCALE("locale"),
        TIMEZONE("timezone"),
        ACTIVE("active"),
        PASSWORD("password"),
        META_VERSION("meta.version"),
        META_LOCATION("meta.location"),
        META_CREATED("meta.created"),
        META_LAST_MODIFIED("meta.lastModified");

        private String id;
        private static final Map<String, AttributeNames> m;

        private AttributeNames(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }

        public static List<String> getAllIds() {
            ArrayList<String> ids = new ArrayList<String>();
            for (AttributeNames n : AttributeNames.values()) {
                ids.add(n.getId());
            }
            Collections.sort(ids);
            return ids;
        }

        static {
            m = new HashMap<String, AttributeNames>();
            for (AttributeNames c : AttributeNames.values()) {
                m.put(c.toString(), c);
            }
        }
    }
}

