/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.authnselection.AttributeRule;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.schema.Schema;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.commons.logging.Log;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.ConditionType;
import org.sourceid.saml20.domain.SimpleConditionRule;
import org.sourceid.util.log.AttributeMap;

public class SimpleConditionEvaluator {
    public static boolean evaluate(AttributeMap attributes, SimpleConditionRule rule) {
        return SimpleConditionEvaluator.evaluate(attributes, rule, null);
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    public static boolean evaluate(AttributeMap attributes, SimpleConditionRule rule, Log log) {
        switch (rule.getConditionOperator()) {
            case MULTIVALUE_CONTAINS: {
                AttributeValue val = (AttributeValue)attributes.get((Object)rule.getConditionField());
                if (val == null) break;
                for (String s : val.getValues()) {
                    if (s.equals(rule.getConditionValue())) {
                        SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.MULTIVALUE_CONTAINS.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).setResult(rule).build());
                        return true;
                    }
                    SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.MULTIVALUE_CONTAINS.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).buildNoMatchFound());
                }
                break;
            }
            case MULTIVALUE_DOES_NOT_CONTAIN: {
                AttributeValue val = (AttributeValue)attributes.get((Object)rule.getConditionField());
                if (val != null) {
                    for (String s : val.getValues()) {
                        if (!s.equals(rule.getConditionValue())) continue;
                        SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.MULTIVALUE_DOES_NOT_CONTAIN.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).buildNoMatchFound());
                        return false;
                    }
                }
                SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.MULTIVALUE_DOES_NOT_CONTAIN.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).setResult(rule).build());
                return true;
            }
            case MULTIVALUE_CONTAINS_CASE_INSENSITIVE: {
                AttributeValue val = (AttributeValue)attributes.get((Object)rule.getConditionField());
                if (val == null) break;
                for (String s : val.getValues()) {
                    if (s.equalsIgnoreCase(rule.getConditionValue())) {
                        SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.MULTIVALUE_CONTAINS_CASE_INSENSITIVE.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).setResult(rule).build());
                        return true;
                    }
                    SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.MULTIVALUE_CONTAINS_CASE_INSENSITIVE.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).buildNoMatchFound());
                }
                break;
            }
            case MULTIVALUE_DOES_NOT_CONTAIN_CASE_INSENSITIVE: {
                AttributeValue val = (AttributeValue)attributes.get((Object)rule.getConditionField());
                if (val != null) {
                    for (String s : val.getValues()) {
                        if (!s.equalsIgnoreCase(rule.getConditionValue())) continue;
                        SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.MULTIVALUE_DOES_NOT_CONTAIN_CASE_INSENSITIVE.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).buildNoMatchFound());
                        return false;
                    }
                }
                SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.MULTIVALUE_DOES_NOT_CONTAIN_CASE_INSENSITIVE.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).setResult(rule).build());
                return true;
            }
            case MULTIVALUE_CONTAINS_DN: {
                AttributeValue val = (AttributeValue)attributes.get((Object)rule.getConditionField());
                if (val == null) break;
                try {
                    for (String s : val.getValues()) {
                        if (DN.equals((String)s, (String)rule.getConditionValue(), (Schema)Schema.getDefaultStandardSchema())) {
                            SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.MULTIVALUE_CONTAINS_DN.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).setResult(rule).build());
                            return true;
                        }
                        SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.MULTIVALUE_CONTAINS_DN.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).buildNoMatchFound());
                    }
                    break;
                }
                catch (LDAPException lDAPException) {
                    break;
                }
            }
            case MULTIVALUE_DOES_NOT_CONTAIN_DN: {
                AttributeValue val = (AttributeValue)attributes.get((Object)rule.getConditionField());
                if (val != null) {
                    try {
                        for (String s : val.getValues()) {
                            if (!DN.equals((String)s, (String)rule.getConditionValue(), (Schema)Schema.getDefaultStandardSchema())) continue;
                            SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.MULTIVALUE_DOES_NOT_CONTAIN_DN.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).buildNoMatchFound());
                            return false;
                        }
                    }
                    catch (LDAPException lDAPException) {
                        // empty catch block
                    }
                }
                SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.MULTIVALUE_DOES_NOT_CONTAIN_DN.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).setResult(rule).build());
                return true;
            }
            case EQUALS_CASE_INSENSITIVE: {
                boolean matched;
                AttributeValue val = (AttributeValue)attributes.get((Object)rule.getConditionField());
                boolean bl = matched = val != null && !val.isMultiValue() && val.getValue().equalsIgnoreCase(rule.getConditionValue());
                if (matched) {
                    SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.EQUALS_CASE_INSENSITIVE.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).setResult(rule).build());
                } else {
                    SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.EQUALS_CASE_INSENSITIVE.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).buildNoMatchFound());
                }
                return matched;
            }
            case NOT_EQUAL_CASE_INSENSITIVE: {
                boolean matched;
                AttributeValue val = (AttributeValue)attributes.get((Object)rule.getConditionField());
                boolean bl = matched = val == null || val.isMultiValue() || !val.getValue().equalsIgnoreCase(rule.getConditionValue());
                if (matched) {
                    SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.NOT_EQUAL_CASE_INSENSITIVE.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).setResult(rule).build());
                } else {
                    SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.NOT_EQUAL_CASE_INSENSITIVE.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).buildNoMatchFound());
                }
                return matched;
            }
            case EQUALS_DN: {
                AttributeValue val = (AttributeValue)attributes.get((Object)rule.getConditionField());
                if (val == null || val.isMultiValue()) break;
                try {
                    if (DN.equals((String)val.getValue(), (String)rule.getConditionValue(), (Schema)Schema.getDefaultStandardSchema())) {
                        SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.EQUALS_DN.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).setResult(rule).build());
                        return true;
                    }
                    SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.EQUALS_DN.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).buildNoMatchFound());
                }
                catch (LDAPException lDAPException) {}
                break;
            }
            case NOT_EQUAL_DN: {
                AttributeValue val = (AttributeValue)attributes.get((Object)rule.getConditionField());
                if (val != null && !val.isMultiValue()) {
                    try {
                        if (DN.equals((String)val.getValue(), (String)rule.getConditionValue(), (Schema)Schema.getDefaultStandardSchema())) {
                            SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.NOT_EQUAL_DN.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).buildNoMatchFound());
                            return false;
                        }
                    }
                    catch (LDAPException lDAPException) {
                        // empty catch block
                    }
                }
                SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.NOT_EQUAL_DN.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).setResult(rule).build());
                return true;
            }
            case EQUALS: {
                boolean matched;
                AttributeValue val = (AttributeValue)attributes.get((Object)rule.getConditionField());
                boolean bl = matched = val != null && !val.isMultiValue() && val.getValue().equals(rule.getConditionValue());
                if (matched) {
                    SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.EQUALS.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).setResult(rule).build());
                } else {
                    SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.EQUALS.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).buildNoMatchFound());
                }
                return matched;
            }
            case NOT_EQUAL: {
                boolean matched;
                AttributeValue val = (AttributeValue)attributes.get((Object)rule.getConditionField());
                boolean bl = matched = val == null || val.isMultiValue() || !val.getValue().equals(rule.getConditionValue());
                if (matched) {
                    SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.NOT_EQUAL.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).setResult(rule).build());
                } else {
                    SimpleConditionEvaluator.debug(log, new LogBuilder().setConditionValue(rule.getConditionValue()).setCondition(ConditionType.NOT_EQUAL.getDescription()).setAttributeName(rule.getConditionField()).setAttributeValue(val).buildNoMatchFound());
                }
                return matched;
            }
        }
        return false;
    }

    private static void debug(Log log, String val) {
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)val);
        }
    }

    private static final class LogBuilder {
        private String conditionVal;
        private String condition;
        private String attributeName;
        private String attributeValue;
        private String result;

        private LogBuilder() {
        }

        public LogBuilder setConditionValue(String conditionValue) {
            this.conditionVal = conditionValue;
            return this;
        }

        public LogBuilder setCondition(String condition) {
            this.condition = condition;
            return this;
        }

        public LogBuilder setAttributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public LogBuilder setAttributeValue(AttributeValue attributeValue) {
            if (attributeValue != null) {
                this.attributeValue = attributeValue.isMasked() ? "*****" : (attributeValue.isMultiValue() ? String.join((CharSequence)", ", attributeValue.getValues()) : attributeValue.getValue());
            }
            return this;
        }

        public LogBuilder setResult(SimpleConditionRule rule) {
            if (rule instanceof AttributeRule) {
                AttributeRule attributeRule = (AttributeRule)rule;
                this.result = attributeRule.getResult();
            }
            return this;
        }

        public String build() {
            return "Comparing VALUE '" + this.conditionVal + "' with CONDITION '" + this.condition + "' to ATTRIBUTE '" + this.attributeName + "' containing '" + this.attributeValue + "' RESULT set to '" + this.result + "'.";
        }

        public String buildNoMatchFound() {
            return "No match found when comparing VALUE '" + this.conditionVal + "' with CONDITION '" + this.condition + "' to ATTRIBUTE '" + this.attributeName + "' containing '" + this.attributeValue + "' ";
        }
    }
}

