/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import org.sourceid.saml20.domain.SourceType;

public abstract class SourceTypeString {
    public static final String SOURCE_TYPE_ADAPTER = "Adapter";
    public static final String SOURCE_TYPE_PASSWORD_CREDENTIAL_VALIDATOR = "Password Credential Validator";
    public static final String SOURCE_TYPE_GRANT = "Persistent Grant";
    public static final String SOURCE_TYPE_TOKEN = "Token";
    public static final String SOURCE_TYPE_TEXT = "Text";
    public static final String SOURCE_TYPE_NO_MAPPING = "No Mapping";
    public static final String SOURCE_TYPE_ATTR_QUERY = "Attribute Query";
    public static final String SOURCE_TYPE_EXPRESSION = "Expression";
    public static final String SOURCE_TYPE_JDBC = "JDBC";
    public static final String SOURCE_TYPE_LDAP = "LDAP";
    public static final String SOURCE_TYPE_ASSERTION = "Assertion";
    public static final String SOURCE_TYPE_CLAIMS = "Provider Claims";
    public static final String SOURCE_TYPE_LOCAL_IDENTITY_PROFILE = "Local Account";
    public static final String OLD_SOURCE_TYPE_EXTENDED_CLIENT_METADATA = "Extended Client Metadata";
    public static final String SOURCE_TYPE_EXTENDED_CLIENT_METADATA = "Extended Properties";
    public static final String SOURCE_TYPE_TRACKED_HTTP_PARAMS = "Tracked HTTP Parameters";
    @Deprecated
    private static final String SOURCE_TYPE_SCIM_REQUEST = "SCIM Request";
    public static final String SOURCE_TYPE_SCIM_USER = "SCIM User";
    public static final String SOURCE_TYPE_SCIM_GROUP = "SCIM Group";
    public static final String SOURCE_TYPE_ACCT_LINK = "AccountLink";
    public static final String SOURCE_TYPE_OTHER = "Other";
    public static final String SOURCE_TYPE_CUSTOM = "Custom";
    public static final String SOURCE_TYPE_REQUEST = "Request";
    public static final String SOURCE_TYPE_SYSTEM_MANAGED = "System Managed";
    public static final String TARGET_RESOURCE = "TargetResource";
    public static final String SOURCE_TYPE_MAPPED_ATTRIBUTES = "Mapped Attributes";
    public static final String SOURCE_TYPE_CONTEXT = "Context";
    public static final String SOURCE_TYPE_OPEN_ID_CONNECT_ACCESS_TOKEN = "Token";
    @Deprecated
    private static final String SOURCE_TYPE_IDENTITY_STORE = "Identity Store";
    public static final String SOURCE_TYPE_IDENTITY_STORE_USER = "Identity Store User";
    public static final String SOURCE_TYPE_IDENTITY_STORE_GROUP = "Identity Store Group";
    public static final String SOURCE_TYPE_IDP_CONNECTION = "IdP Connection";
    @Deprecated
    private static final String SOURCE_TYPE_C2C_CONTRACT = "Connection Mapping Contract";
    public static final String SOURCE_TYPE_APC = "Authentication Policy Contract";
    public static final String SOURCE_TYPE_SUBJECT_TOKEN = "Subject Token";
    public static final String SOURCE_TYPE_ACTOR_TOKEN = "Actor Token";
    public static final String SOURCE_TYPE_TOKEN_EXCHANGE_PROCESSOR_POLICY = "Processor Policy";
    public static final String SOURCE_TYPE_FRAGMENT = "Fragment";
    public static final String SOURCE_TYPE_INPUT_CONTRACT = "Inputs";

    public static String getTypeString(SourceType type) {
        String typeStr = null;
        if (type == null) {
            return null;
        }
        switch (type) {
            case ADAPTER: {
                typeStr = SOURCE_TYPE_ADAPTER;
                break;
            }
            case TOKEN: {
                typeStr = "Token";
                break;
            }
            case NO_MAPPING: {
                typeStr = SOURCE_TYPE_NO_MAPPING;
                break;
            }
            case TEXT: {
                typeStr = SOURCE_TYPE_TEXT;
                break;
            }
            case EXPRESSION: {
                typeStr = SOURCE_TYPE_EXPRESSION;
                break;
            }
            case ATTRIBUTE_QUERY: {
                typeStr = SOURCE_TYPE_ATTR_QUERY;
                break;
            }
            case JDBC_DATA_STORE: {
                typeStr = SOURCE_TYPE_JDBC;
                break;
            }
            case LDAP_DATA_STORE: {
                typeStr = SOURCE_TYPE_LDAP;
                break;
            }
            case PING_ONE_LDAP_GATEWAY_DATA_STORE: {
                typeStr = SOURCE_TYPE_LDAP;
                break;
            }
            case ASSERTION: {
                typeStr = SOURCE_TYPE_ASSERTION;
                break;
            }
            case SCIM_USER: {
                typeStr = SOURCE_TYPE_SCIM_USER;
                break;
            }
            case SCIM_GROUP: {
                typeStr = SOURCE_TYPE_SCIM_GROUP;
                break;
            }
            case ACCOUNT_LINK: {
                typeStr = SOURCE_TYPE_ACCT_LINK;
                break;
            }
            case OTHER_DATA_STORE: {
                typeStr = SOURCE_TYPE_OTHER;
                break;
            }
            case REQUEST: {
                typeStr = SOURCE_TYPE_REQUEST;
                break;
            }
            case SYSTEM_MANAGED: {
                typeStr = SOURCE_TYPE_SYSTEM_MANAGED;
                break;
            }
            case PASSWORD_CREDENTIAL_VALIDATOR: {
                typeStr = SOURCE_TYPE_PASSWORD_CREDENTIAL_VALIDATOR;
                break;
            }
            case OAUTH_PERSISTENT_GRANT: {
                typeStr = SOURCE_TYPE_GRANT;
                break;
            }
            case MAPPED_ATTRIBUTES: {
                typeStr = SOURCE_TYPE_MAPPED_ATTRIBUTES;
                break;
            }
            case CONTEXT: {
                typeStr = SOURCE_TYPE_CONTEXT;
                break;
            }
            case OPEN_ID_CONNECT_ACCESS_TOKEN: {
                typeStr = "Token";
                break;
            }
            case IDENTITY_STORE_USER: {
                typeStr = SOURCE_TYPE_IDENTITY_STORE_USER;
                break;
            }
            case IDENTITY_STORE_GROUP: {
                typeStr = SOURCE_TYPE_IDENTITY_STORE_GROUP;
                break;
            }
            case IDP_CONNECTION: {
                typeStr = SOURCE_TYPE_IDP_CONNECTION;
                break;
            }
            case AUTHENTICATION_POLICY_CONTRACT: {
                typeStr = SOURCE_TYPE_APC;
                break;
            }
            case CLAIMS: {
                typeStr = SOURCE_TYPE_CLAIMS;
                break;
            }
            case LOCAL_IDENTITY_PROFILE: {
                typeStr = SOURCE_TYPE_LOCAL_IDENTITY_PROFILE;
                break;
            }
            case EXTENDED_PROPERTIES: 
            case EXTENDED_CLIENT_METADATA: {
                typeStr = SOURCE_TYPE_EXTENDED_CLIENT_METADATA;
                break;
            }
            case TRACKED_HTTP_PARAMS: {
                typeStr = SOURCE_TYPE_TRACKED_HTTP_PARAMS;
                break;
            }
            case ACTOR_TOKEN: {
                typeStr = SOURCE_TYPE_ACTOR_TOKEN;
                break;
            }
            case SUBJECT_TOKEN: {
                typeStr = SOURCE_TYPE_SUBJECT_TOKEN;
                break;
            }
            case TOKEN_EXCHANGE_PROCESSOR_POLICY: {
                typeStr = SOURCE_TYPE_TOKEN_EXCHANGE_PROCESSOR_POLICY;
                break;
            }
            case FRAGMENT: {
                typeStr = SOURCE_TYPE_FRAGMENT;
                break;
            }
            case INPUTS: {
                typeStr = SOURCE_TYPE_INPUT_CONTRACT;
                break;
            }
        }
        return typeStr;
    }

    public static SourceType strToType(String typeStr) {
        SourceType retType = SOURCE_TYPE_NO_MAPPING.equalsIgnoreCase(typeStr) ? SourceType.NO_MAPPING : (SOURCE_TYPE_TEXT.equalsIgnoreCase(typeStr) ? SourceType.TEXT : (SOURCE_TYPE_EXPRESSION.equalsIgnoreCase(typeStr) ? SourceType.EXPRESSION : (SOURCE_TYPE_ATTR_QUERY.equals(typeStr) ? SourceType.ATTRIBUTE_QUERY : (SOURCE_TYPE_JDBC.equalsIgnoreCase(typeStr) ? SourceType.JDBC_DATA_STORE : (SOURCE_TYPE_LDAP.equalsIgnoreCase(typeStr) ? SourceType.LDAP_DATA_STORE : (SOURCE_TYPE_ASSERTION.equalsIgnoreCase(typeStr) ? SourceType.ASSERTION : (SOURCE_TYPE_SCIM_USER.equalsIgnoreCase(typeStr) || SOURCE_TYPE_SCIM_REQUEST.equalsIgnoreCase(typeStr) ? SourceType.SCIM_USER : (SOURCE_TYPE_SCIM_GROUP.equalsIgnoreCase(typeStr) ? SourceType.SCIM_GROUP : (SOURCE_TYPE_ACCT_LINK.equalsIgnoreCase(typeStr) ? SourceType.ACCOUNT_LINK : (SOURCE_TYPE_ADAPTER.equalsIgnoreCase(typeStr) ? SourceType.ADAPTER : ("Token".equalsIgnoreCase(typeStr) ? SourceType.TOKEN : (SOURCE_TYPE_OTHER.equalsIgnoreCase(typeStr) || SOURCE_TYPE_CUSTOM.equalsIgnoreCase(typeStr) ? SourceType.OTHER_DATA_STORE : (SOURCE_TYPE_REQUEST.equalsIgnoreCase(typeStr) ? SourceType.REQUEST : (SOURCE_TYPE_SYSTEM_MANAGED.equalsIgnoreCase(typeStr) ? SourceType.SYSTEM_MANAGED : (SOURCE_TYPE_PASSWORD_CREDENTIAL_VALIDATOR.equalsIgnoreCase(typeStr) ? SourceType.PASSWORD_CREDENTIAL_VALIDATOR : (SOURCE_TYPE_GRANT.equalsIgnoreCase(typeStr) ? SourceType.OAUTH_PERSISTENT_GRANT : (SOURCE_TYPE_MAPPED_ATTRIBUTES.equalsIgnoreCase(typeStr) ? SourceType.MAPPED_ATTRIBUTES : (SOURCE_TYPE_CONTEXT.equalsIgnoreCase(typeStr) ? SourceType.CONTEXT : ("Token".equalsIgnoreCase(typeStr) ? SourceType.OPEN_ID_CONNECT_ACCESS_TOKEN : (SOURCE_TYPE_IDENTITY_STORE_USER.equalsIgnoreCase(typeStr) || SOURCE_TYPE_IDENTITY_STORE.equalsIgnoreCase(typeStr) ? SourceType.IDENTITY_STORE_USER : (SOURCE_TYPE_IDENTITY_STORE_GROUP.equalsIgnoreCase(typeStr) ? SourceType.IDENTITY_STORE_GROUP : (SOURCE_TYPE_IDP_CONNECTION.equalsIgnoreCase(typeStr) ? SourceType.IDP_CONNECTION : (SOURCE_TYPE_APC.equalsIgnoreCase(typeStr) || SOURCE_TYPE_C2C_CONTRACT.equalsIgnoreCase(typeStr) ? SourceType.AUTHENTICATION_POLICY_CONTRACT : (SOURCE_TYPE_CLAIMS.equalsIgnoreCase(typeStr) ? SourceType.CLAIMS : (SOURCE_TYPE_LOCAL_IDENTITY_PROFILE.equalsIgnoreCase(typeStr) ? SourceType.LOCAL_IDENTITY_PROFILE : (SOURCE_TYPE_EXTENDED_CLIENT_METADATA.equalsIgnoreCase(typeStr) || OLD_SOURCE_TYPE_EXTENDED_CLIENT_METADATA.equalsIgnoreCase(typeStr) ? SourceType.EXTENDED_PROPERTIES : (SOURCE_TYPE_TRACKED_HTTP_PARAMS.equalsIgnoreCase(typeStr) ? SourceType.TRACKED_HTTP_PARAMS : (SOURCE_TYPE_SUBJECT_TOKEN.equalsIgnoreCase(typeStr) ? SourceType.SUBJECT_TOKEN : (SOURCE_TYPE_ACTOR_TOKEN.equalsIgnoreCase(typeStr) ? SourceType.ACTOR_TOKEN : (SOURCE_TYPE_TOKEN_EXCHANGE_PROCESSOR_POLICY.equals(typeStr) ? SourceType.TOKEN_EXCHANGE_PROCESSOR_POLICY : (SOURCE_TYPE_FRAGMENT.equals(typeStr) ? SourceType.FRAGMENT : (SOURCE_TYPE_INPUT_CONTRACT.equals(typeStr) ? SourceType.INPUTS : null))))))))))))))))))))))))))))))));
        return retType;
    }
}

