/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeRequester;
import org.sourceid.saml20.domain.AuthnSourceToAssertionMapping;
import org.sourceid.saml20.domain.BasePluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.Endpoints;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.LoggingMode;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.WsFedSpSettings;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.util.log.AttributeMap;

public class SpConnection
extends ConnectionBase {
    public static final String TARGET_TYPE_STANDARD = "Standard";
    public static final String TARGET_TYPE_STANDARD_DESCRIPTION = "No Template";
    public static final String TARGET_TYPE_SALESFORCE = "SalesForce";
    public static final String TARGET_TYPE_SALESFORCE_CP = "SalesForceCP";
    public static final String TARGET_TYPE_SALESFORCE_PP = "SalesForcePP";
    public static final String TARGET_TYPE_PING_ONE_SCIM11 = "PingOneSCIM11";
    private static final long serialVersionUID = 1L;
    private IndexedEndpoints assertionConsumerServiceEndpoints = new IndexedEndpoints();
    private boolean authnRequestsSigned;
    private int assertionValidityBeforeMinutes = 5;
    private int assertionValidityAfterMinutes = 5;
    private boolean includeAdditionalTransientAttributes;
    private List<String> nameIdFormats = new ArrayList<String>();
    private boolean doPseudonymAsNameId;
    private boolean doTransientAsNameId;
    private boolean wantAssertionsSigned;
    private boolean signResponseAsRequired;
    private String defaultTargetResource;
    private String connectionTargetType = "Standard";
    private Map<String, AdapterToAssertionMapping> adapterMappings = new HashMap<String, AdapterToAssertionMapping>();
    private Map<String, AdapterToAssertionMapping> baseAdapterMappings = new HashMap<String, AdapterToAssertionMapping>();
    private Map<String, C2cContractToAssertionMapping> c2cMappings = new HashMap<String, C2cContractToAssertionMapping>();
    private AttributeRequester attributeRequester = null;
    private WsTrustFederatedWscSettings wsTrustSettings;
    private boolean enableCDCDuringSSO;
    private String applicationName;
    private URL applicationIconUrl;
    private WsFedSpSettings wsFedSettings = null;

    public SpConnection() {
        this((String)null);
    }

    public SpConnection(String entityId) {
        super(entityId);
    }

    public SpConnection(SpConnection conn) {
        super(conn);
        this.assertionConsumerServiceEndpoints = conn.assertionConsumerServiceEndpoints != null ? conn.assertionConsumerServiceEndpoints.clone() : null;
        this.authnRequestsSigned = conn.authnRequestsSigned;
        this.assertionValidityBeforeMinutes = conn.assertionValidityBeforeMinutes;
        this.assertionValidityAfterMinutes = conn.assertionValidityAfterMinutes;
        this.includeAdditionalTransientAttributes = conn.includeAdditionalTransientAttributes;
        this.nameIdFormats = conn.nameIdFormats != null ? new ArrayList<String>(conn.nameIdFormats) : null;
        this.doPseudonymAsNameId = conn.doPseudonymAsNameId;
        this.doTransientAsNameId = conn.doTransientAsNameId;
        this.wantAssertionsSigned = conn.wantAssertionsSigned;
        this.signResponseAsRequired = conn.signResponseAsRequired;
        this.defaultTargetResource = conn.defaultTargetResource;
        this.connectionTargetType = conn.connectionTargetType;
        this.adapterMappings = conn.adapterMappings != null ? new HashMap<String, AdapterToAssertionMapping>(conn.adapterMappings) : null;
        this.baseAdapterMappings = conn.adapterMappings != null ? new HashMap<String, AdapterToAssertionMapping>(conn.adapterMappings) : new HashMap();
        this.c2cMappings = conn.c2cMappings != null ? new HashMap<String, C2cContractToAssertionMapping>(conn.c2cMappings) : null;
        this.attributeRequester = conn.attributeRequester != null ? conn.attributeRequester.clone() : null;
        this.wsTrustSettings = conn.wsTrustSettings != null ? conn.wsTrustSettings.clone() : null;
        this.enableCDCDuringSSO = conn.enableCDCDuringSSO;
        this.applicationName = conn.applicationName;
        this.applicationIconUrl = conn.applicationIconUrl;
        this.wsFedSettings = conn.wsFedSettings != null ? conn.wsFedSettings.clone() : null;
    }

    public IndexedEndpoints getAssertionConsumerServiceEndpoints() {
        return this.assertionConsumerServiceEndpoints;
    }

    public void setAssertionConsumerServiceEndpoints(IndexedEndpoints endPts) {
        this.assertionConsumerServiceEndpoints = endPts;
    }

    public boolean isAuthnRequestsSigned() {
        return this.authnRequestsSigned;
    }

    public void setAuthnRequestsSigned(boolean authnRequestsSigned) {
        this.authnRequestsSigned = authnRequestsSigned;
    }

    public int getAssertionValidityBeforeMinutes() {
        return this.assertionValidityBeforeMinutes;
    }

    public void setAssertionValidityBeforeMinutes(int assertionValidityBeforeMinutes) {
        this.assertionValidityBeforeMinutes = assertionValidityBeforeMinutes;
    }

    public int getAssertionValidityAfterMinutes() {
        return this.assertionValidityAfterMinutes;
    }

    public void setAssertionValidityAfterMinutes(int assertionValidityAfterMinutes) {
        this.assertionValidityAfterMinutes = assertionValidityAfterMinutes;
    }

    public AttributeMap executeC2cMapping(String c2cContractId, AttributeMap attributesFromC2c, AttributeMap contextAttributes, Map<String, Object> otherState) throws StatusResponseException {
        C2cContractToAssertionMapping c2cToAssertionMapping = this.c2cMappings.get(c2cContractId);
        this.addExtendedPropertiesToContext(contextAttributes);
        if (c2cToAssertionMapping != null) {
            return this.executeAuthnSourceAttributeMapping(c2cToAssertionMapping, attributesFromC2c, contextAttributes);
        }
        if (this.sendPseudonymAsNameId() || this.sendTransientAsNameId()) {
            return new AttributeMap();
        }
        String msg = "No attribute mapping to the specified authentication policy contract (" + c2cContractId + ") is available for Sp connection " + this.getEntityId();
        throw new StatusResponseException(TopLevelStatusCode.RESPONDER, msg);
    }

    public AttributeMap executeAdapterMapping(String adapterId, AttributeMap attributesFromAdapter, AttributeMap contextAttributes, Map<String, Object> otherState) throws StatusResponseException {
        AdapterToAssertionMapping adapterToAssertionMapping;
        IdpAuthnAdapterInstance instance = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstanceWithConnectionOverride(adapterId, this.getEntityId());
        if (instance != null) {
            adapterId = instance.getId();
        }
        if ((adapterToAssertionMapping = this.adapterMappings.get(adapterId)) != null) {
            this.addExtendedPropertiesToContext(contextAttributes);
            return this.executeAuthnSourceAttributeMapping(adapterToAssertionMapping, attributesFromAdapter, contextAttributes);
        }
        if (this.sendPseudonymAsNameId() || this.sendTransientAsNameId()) {
            return new AttributeMap();
        }
        String msg = "No attribute mapping from adapter (" + adapterId + ") available for " + this.getEntityId();
        throw new StatusResponseException(TopLevelStatusCode.RESPONDER, msg);
    }

    private AttributeMap executeAuthnSourceAttributeMapping(AuthnSourceToAssertionMapping authnSourceToAssertionMapping, AttributeMap attributesFromAuthnSource, AttributeMap contextAttributes) throws StatusResponseException {
        AttributeContract attributeContract = this.getAttributeContract();
        Set<String> allAttributeNames = attributeContract.getAllAttributeNames();
        return authnSourceToAssertionMapping.executeAttributeMapping(attributesFromAuthnSource, allAttributeNames, contextAttributes);
    }

    public Collection<AdapterToAssertionMapping> getAdapterMappings() {
        return this.adapterMappings.values();
    }

    public Map<String, AdapterToAssertionMapping> getMappedBaseAdapters() {
        return this.baseAdapterMappings;
    }

    public void setAdapterMappings(Collection<AdapterToAssertionMapping> mappingsCollection) {
        this.adapterMappings.clear();
        this.baseAdapterMappings.clear();
        for (AdapterToAssertionMapping mapping : mappingsCollection) {
            this.adapterMappings.put(mapping.getAdapterInstanceId(), mapping);
            String baseAdapterId = mapping.getConnectionOverrideInstance() == null ? mapping.getAdapterInstanceId() : mapping.getConnectionOverrideInstance().getParentId();
            this.baseAdapterMappings.put(baseAdapterId, mapping);
        }
    }

    public Collection<C2cContractToAssertionMapping> getC2cMappings() {
        return this.c2cMappings.values();
    }

    public void setC2cMappings(Collection<C2cContractToAssertionMapping> mappingsCollection) {
        this.c2cMappings.clear();
        for (C2cContractToAssertionMapping mapping : mappingsCollection) {
            this.c2cMappings.put(mapping.getContractId(), mapping);
        }
    }

    public Endpoint getAssertionConsumerServiceEndpoint(Integer idx) {
        return this.assertionConsumerServiceEndpoints.getEndpoint(idx);
    }

    public boolean hasAssertionConsumerServiceEndpoint(String acsURL) {
        return this.assertionConsumerServiceEndpoints.hasEndpoint(acsURL);
    }

    @Override
    public Role getRoleType() {
        return Role.SP;
    }

    public boolean sendPseudonymAsNameId() {
        return this.doPseudonymAsNameId;
    }

    public boolean sendTransientAsNameId() {
        return this.doTransientAsNameId;
    }

    public boolean isIncludeAdditionalTransientAttributes() {
        return this.includeAdditionalTransientAttributes;
    }

    public void setIncludeAdditionalTransientAttributes(boolean includeAdditionalTransientAttributes) {
        this.includeAdditionalTransientAttributes = includeAdditionalTransientAttributes;
    }

    public String getNameIdFormat() {
        Iterator<String> iterator = this.nameIdFormats.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public void setNameIdFormat(String nameIdFormat) {
        this.setNameIdFormats(Arrays.asList(nameIdFormat));
    }

    public List<String> getNameIdFormats() {
        return this.nameIdFormats;
    }

    public void setNameIdFormats(List<String> nameIdFormats) {
        this.nameIdFormats = nameIdFormats != null ? nameIdFormats : Collections.emptyList();
        String nameIdFormat = this.getNameIdFormat();
        this.doPseudonymAsNameId = "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent".equals(nameIdFormat);
        this.doTransientAsNameId = "urn:oasis:names:tc:SAML:2.0:nameid-format:transient".equals(nameIdFormat);
    }

    public boolean isWantAssertionsSigned() {
        return this.wantAssertionsSigned;
    }

    public void setWantAssertionsSigned(boolean wantAssertionsSigned) {
        this.wantAssertionsSigned = wantAssertionsSigned;
    }

    public Boolean isSignResponseAsRequired() {
        return this.signResponseAsRequired;
    }

    public void setSignResponseAsRequired(Boolean signResponseAsRequired) {
        this.signResponseAsRequired = signResponseAsRequired;
    }

    @Override
    protected Endpoints getEndpoints() {
        return this.assertionConsumerServiceEndpoints;
    }

    public boolean hasDefaultTargetResource() {
        return !StringUtils.isBlank((String)this.defaultTargetResource);
    }

    public String getDefaultTargetResource() {
        return this.defaultTargetResource;
    }

    public void setDefaultTargetResource(String defaultTargetResource) {
        this.defaultTargetResource = defaultTargetResource;
    }

    public String getConnectionTargetType() {
        return this.connectionTargetType;
    }

    public void setConnectionTargetType(String connectionTargetType) {
        this.connectionTargetType = connectionTargetType;
    }

    public AttributeRequester getAttributeRequester() {
        return this.attributeRequester;
    }

    public void setAttributeRequester(AttributeRequester attributeRequester) {
        this.attributeRequester = attributeRequester;
    }

    @Override
    public LoggingMode getLoggingMode() {
        SpConnection spConnection = this;
        if (spConnection.loggingMode.isSpOverrideOn()) {
            SpConnection spConnection2 = this;
            return spConnection2.loggingMode.getSpOverrideMode();
        }
        return this.loggingMode;
    }

    @Override
    boolean specificHasExpressions() {
        for (AdapterToAssertionMapping mapping : this.getAdapterMappings()) {
            if (!mapping.hasExpressions()) continue;
            return true;
        }
        return false;
    }

    public WsTrustFederatedWscSettings getWsTrustSettings() {
        return this.wsTrustSettings;
    }

    public void setWsTrustSettings(WsTrustFederatedWscSettings wsTrustSettings) {
        this.wsTrustSettings = wsTrustSettings;
    }

    @Override
    public boolean doesWsTrustSettingsExist() {
        return this.wsTrustSettings != null;
    }

    @Override
    public boolean isBrowserSsoProfileConfigured() {
        return this.getEnabledProfiles().isIdpInitiatedSSOEnabled() || this.getEnabledProfiles().isSpInitiatedSSOEnabled() || this.getAttributeRequester() != null;
    }

    @Override
    public boolean doesInboundProvisioningExist() {
        return false;
    }

    @Override
    public boolean doesInboundGroupProvisioningExist() {
        return false;
    }

    public boolean isEnableCDCDuringSSO() {
        return this.enableCDCDuringSSO;
    }

    public void setEnableCDCDuringSSO(boolean enableCDCDuringSSO) {
        this.enableCDCDuringSSO = enableCDCDuringSSO;
    }

    public URL getApplicationIconUrl() {
        return this.applicationIconUrl;
    }

    public void setApplicationIconUrl(URL applicationIconUrl) {
        this.applicationIconUrl = applicationIconUrl;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public org.sourceid.saml20.xmlbinding.assertion.AssertionType[] customizeAssertions(HttpServletRequest req, HttpServletResponse resp, org.sourceid.saml20.xmlbinding.assertion.AssertionType assertion, Map<String, Object> context, Map<String, Object> stateParams) {
        return this.messageCustomize("assertion", org.sourceid.saml20.xmlbinding.assertion.AssertionType[].class, req, resp, new org.sourceid.saml20.xmlbinding.assertion.AssertionType[]{assertion}, "AssertionTypes", context, stateParams);
    }

    public AssertionType[] customizeAssertions(HttpServletRequest req, HttpServletResponse resp, AssertionType assertion, Map<String, Object> context, Map<String, Object> stateParams) {
        Class<AssertionType[]> type = AssertionType[].class;
        AssertionType[] assertions = new AssertionType[]{assertion};
        return this.messageCustomize("assertion", type, req, resp, assertions, "AssertionTypes", context, stateParams);
    }

    public AssertionType customizeAssertion(HttpServletRequest req, HttpServletResponse resp, AssertionType assertion, Map<String, Object> context, Map<String, Object> stateParams) {
        return this.messageCustomize("assertion", AssertionType.class, req, resp, assertion, "AssertionType", context, stateParams);
    }

    public <T> T customizeResponse(Class<T> type, HttpServletRequest req, HttpServletResponse resp, T message, String messageVariableName, Map<String, Object> context, Map<String, Object> stateParams) {
        return this.messageCustomize("authn-response", type, req, resp, message, messageVariableName, context, stateParams);
    }

    public <T> T customizeWsTrustResponse(Class<T> type, HttpServletRequest req, HttpServletResponse resp, T message, String messageVariableName, Map<String, Object> context) {
        return this.wsTrustmessageCustomize("authn-response", type, req, resp, message, messageVariableName, context);
    }

    public WsFedSpSettings getWsFedSettings() {
        return this.wsFedSettings;
    }

    public void setWsFedSettings(WsFedSpSettings wsFedSettings) {
        this.wsFedSettings = wsFedSettings;
    }

    @Override
    public Collection<ConfigurablePluginInstance> getConnBasedPluginOverrides(PluginManagementSupport.PluginManagementType pluginManagementType) {
        BasePluginInstance instance;
        ArrayList<ConfigurablePluginInstance> instances = new ArrayList<ConfigurablePluginInstance>();
        if (pluginManagementType == null || pluginManagementType == PluginManagementSupport.PluginManagementType.IDP_ADAPTER) {
            for (AdapterToAssertionMapping adapterToAssertionMapping : this.getAdapterMappings()) {
                instance = adapterToAssertionMapping.getConnectionOverrideInstance();
                if (instance == null) continue;
                instances.add(instance);
            }
        }
        if ((pluginManagementType == null || pluginManagementType == PluginManagementSupport.PluginManagementType.TOKEN_PROCESSOR) && this.doesWsTrustSettingsExist()) {
            for (TokenPluginAttributeMapping tokenPluginAttributeMapping : this.getWsTrustSettings().getTokenToAssertionMappings()) {
                instance = tokenPluginAttributeMapping.getConnectionOverrideInstance();
                if (instance == null) continue;
                instances.add(instance);
            }
        }
        return instances;
    }
}

