/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.VirtualServerIdsReferencer;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.SpAdapterManager;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class TargetAttributeMapping
extends AttributeMapping
implements VirtualServerIdsReferencer,
Serializable {
    private static final long serialVersionUID = 20050515L;
    private static final SpAdapterManager spAdapterManager = MgmtFactory.getSpAdapterManager();
    private String adapterInstanceId;
    private String originalInstanceId;
    private AuthnAdapterInstance connectionOverrideInstance;
    private boolean savedConnectionOverride;
    private boolean restrictVirtualServerIds;
    private List<String> restrictedVirtualServerIds = Collections.emptyList();

    public String getBaseAdapterInstanceId() {
        if (this.connectionOverrideInstance != null) {
            return this.connectionOverrideInstance.getParentId();
        }
        return this.adapterInstanceId;
    }

    public String getAdapterInstanceId() {
        return this.adapterInstanceId;
    }

    public void setAdapterInstanceId(String adapterInstanceId) {
        if (this.originalInstanceId == null) {
            this.originalInstanceId = adapterInstanceId;
        }
        this.adapterInstanceId = adapterInstanceId;
    }

    @Override
    public boolean isRestrictVirtualServerIds() {
        return this.restrictVirtualServerIds;
    }

    @Override
    public void setRestrictVirtualServerIds(boolean restrictVirtualServerIds) {
        this.restrictVirtualServerIds = restrictVirtualServerIds;
    }

    @Override
    public List<String> getRestrictedVirtualServerIds() {
        return this.restrictedVirtualServerIds;
    }

    @Override
    public void setRestrictedVirtualServerIds(List<String> restrictedVirtualServerIds) {
        this.restrictedVirtualServerIds = restrictedVirtualServerIds;
    }

    public AttributeMap executeMapping(AttributeMap srcAttributes, AttributeMap contextAttributes) throws AttrLookupException, AuthorizationException {
        AuthnAdapterInstance spAuthnAdapterInstance = (AuthnAdapterInstance)spAdapterManager.getInstance(this.adapterInstanceId);
        AttributeContract attributeContract = spAuthnAdapterInstance.getAttributeContract();
        Set<String> allAttributeNames = attributeContract.getAllAttributeNames();
        AttributeMap attributeMap = super.executeMapping(srcAttributes, allAttributeNames, contextAttributes);
        if (attributeMap.isEmpty()) {
            throw new ProcessRuntimeException("User attribute mapping produced empty result.");
        }
        return attributeMap;
    }

    @Override
    boolean isAbortOnAttrLookupFailure() {
        return false;
    }

    public boolean isMapped(String assertionAttribName) {
        boolean isMapped = false;
        block0: for (List attrMappingValueList : this.attributeMap.values()) {
            for (AttrMappingValue value : attrMappingValueList) {
                if (value.getType() != SourceType.ASSERTION && value.getType() != SourceType.CLAIMS || !assertionAttribName.equals(value.getValue())) continue;
                isMapped = true;
                continue block0;
            }
        }
        return isMapped;
    }

    public AuthnAdapterInstance getConnectionOverrideInstance() {
        return this.connectionOverrideInstance;
    }

    public void setConnectionOverrideInstance(AuthnAdapterInstance instance) {
        this.connectionOverrideInstance = instance;
    }

    public boolean isSavedConnectionOverride() {
        return this.savedConnectionOverride;
    }

    public void setSavedConnectionOverride(boolean savedConnectionOverride) {
        this.savedConnectionOverride = savedConnectionOverride;
    }

    public void resetAdapterInstanceId() {
        if (this.originalInstanceId != null) {
            this.adapterInstanceId = this.originalInstanceId;
        }
        this.originalInstanceId = null;
    }
}

