/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.AppliesTo;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.WsTrustTokenAttributeContract;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class WsTrustFederatedWscSettings
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private boolean useSamlHoK;
    private boolean encryptAssertion;
    private String requestContractId;
    private WsTrustTokenAttributeContract attributeContract;
    private Set<AppliesTo> appliesTo = new HashSet<AppliesTo>();
    private boolean abortIfNotFulfilledFromRequest;
    private boolean enableOAuthAssertionProfiles;
    private String tokenType;
    private HashMap<String, TokenPluginAttributeMapping> tokenToAssertionMappings = new HashMap();
    private int assertionValidityBeforeMinutes;
    private int assertionValidityAfterMinutes;

    public String getRequestContractId() {
        return this.requestContractId;
    }

    public void setRequestContractId(String requestContractId) {
        this.requestContractId = requestContractId;
    }

    public boolean isEncryptAssertion() {
        return this.encryptAssertion;
    }

    public void setEncryptAssertion(boolean encryptAssertion) {
        this.encryptAssertion = encryptAssertion;
    }

    public boolean isUseSamlHoK() {
        return this.useSamlHoK;
    }

    public void setUseSamlHoK(boolean useSamlHoK) {
        this.useSamlHoK = useSamlHoK;
    }

    public boolean isAbortIfNotFulfilledFromRequest() {
        return this.abortIfNotFulfilledFromRequest;
    }

    public void setAbortIfNotFulfilledFromRequest(boolean abortIfNotFulfilledFromRequest) {
        this.abortIfNotFulfilledFromRequest = abortIfNotFulfilledFromRequest;
    }

    public Set<AppliesTo> getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(Set<AppliesTo> appliesTo) {
        this.appliesTo = appliesTo;
    }

    public Collection<TokenPluginAttributeMapping> getTokenToAssertionMappings() {
        return this.tokenToAssertionMappings.values();
    }

    public Set<String> getIncomingTokenProcessors() {
        return this.tokenToAssertionMappings.keySet();
    }

    public TokenPluginAttributeMapping getTokenToAssertionMappingByProcessorId(String processorId) {
        if (!this.tokenToAssertionMappings.containsKey(processorId)) {
            throw new ProcessRuntimeException("No mapping for token processor with ID: " + processorId);
        }
        return this.tokenToAssertionMappings.get(processorId);
    }

    public void setTokenToAssertionMappings(Collection<TokenPluginAttributeMapping> mappingsCollection) {
        this.tokenToAssertionMappings.clear();
        for (TokenPluginAttributeMapping mapping : mappingsCollection) {
            this.tokenToAssertionMappings.put(mapping.getPluginId(), mapping);
        }
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public boolean hasIssueToken() {
        return this.tokenType != null;
    }

    public int getAssertionValidityBeforeMinutes() {
        return this.assertionValidityBeforeMinutes;
    }

    public void setAssertionValidityBeforeMinutes(int assertionValidityBeforeMinutes) {
        this.assertionValidityBeforeMinutes = assertionValidityBeforeMinutes;
    }

    public int getAssertionValidityAfterMinutes() {
        return this.assertionValidityAfterMinutes;
    }

    public void setAssertionValidityAfterMinutes(int assertionValidityAfterMinutes) {
        this.assertionValidityAfterMinutes = assertionValidityAfterMinutes;
    }

    public WsTrustTokenAttributeContract getAttributeContract() {
        return this.attributeContract;
    }

    public void setAttributeContract(WsTrustTokenAttributeContract attributeContract) {
        this.attributeContract = attributeContract;
    }

    public boolean isRequestContractDefined() {
        return this.requestContractId != null;
    }

    public boolean isEnableOAuthAssertionProfiles() {
        return this.enableOAuthAssertionProfiles;
    }

    public void setEnableOAuthAssertionProfiles(boolean enableOAuthAssertionProfiles) {
        this.enableOAuthAssertionProfiles = enableOAuthAssertionProfiles;
    }

    public WsTrustFederatedWscSettings clone() {
        WsTrustFederatedWscSettings clone = new WsTrustFederatedWscSettings();
        clone.useSamlHoK = this.useSamlHoK;
        clone.encryptAssertion = this.encryptAssertion;
        clone.requestContractId = this.requestContractId;
        clone.attributeContract = this.attributeContract != null ? new WsTrustTokenAttributeContract(this.attributeContract) : null;
        clone.appliesTo = this.appliesTo;
        clone.abortIfNotFulfilledFromRequest = this.abortIfNotFulfilledFromRequest;
        clone.enableOAuthAssertionProfiles = this.enableOAuthAssertionProfiles;
        clone.tokenType = this.tokenType;
        clone.tokenToAssertionMappings = this.tokenToAssertionMappings != null ? new HashMap<String, TokenPluginAttributeMapping>(this.tokenToAssertionMappings) : null;
        clone.assertionValidityBeforeMinutes = this.assertionValidityBeforeMinutes;
        clone.assertionValidityAfterMinutes = this.assertionValidityAfterMinutes;
        return clone;
    }
}

