/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.datasource.tag;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.datasource.tag.DataSourceInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.DataSourceTagConfig;
import org.sourceid.saml20.domain.datasource.tag.JdbcInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.LdapInstanceIdentifier;

public class DataSourceTagUtil {
    private static final Log log = LogFactory.getLog(DataSourceTagUtil.class);

    public static LdapInstanceIdentifier findMatchingDataSource(LdapInfo ldapInfo, List<String> targetTagsList) {
        if (ldapInfo != null) {
            if (CollectionUtils.isNotEmpty((Collection)ldapInfo.getLdapTagConfigList())) {
                return (LdapInstanceIdentifier)DataSourceTagUtil.findMatchingDataSource(ldapInfo.getLdapTagConfigList(), targetTagsList);
            }
            if (StringUtils.isNotEmpty((String)ldapInfo.getHost())) {
                log.debug((Object)("No connection tags configured. Returning legacy hostname field: " + ldapInfo.getHost()));
                return new LdapInstanceIdentifier(ldapInfo.getHost());
            }
        }
        return null;
    }

    public static JdbcInstanceIdentifier findMatchingDataSource(JdbcDataSource jdbcDataSource, List<String> targetTagsList) {
        if (jdbcDataSource != null) {
            if (CollectionUtils.isNotEmpty(jdbcDataSource.getJdbcTagConfigList())) {
                return (JdbcInstanceIdentifier)DataSourceTagUtil.findMatchingDataSource(jdbcDataSource.getJdbcTagConfigList(), targetTagsList);
            }
            if (StringUtils.isNotEmpty((String)jdbcDataSource.getConnectionUrl())) {
                log.debug((Object)("No connection tags configured. Returning legacy JDBC URL field: " + jdbcDataSource.getConnectionUrl()));
                return new JdbcInstanceIdentifier(jdbcDataSource.getConnectionUrl());
            }
        }
        return null;
    }

    public static DataSourceInstanceIdentifier findMatchingDataSource(List<? extends DataSourceTagConfig> tagConfigList, List<String> targetTagsList) {
        if (CollectionUtils.isNotEmpty(tagConfigList)) {
            if (CollectionUtils.isNotEmpty(targetTagsList)) {
                for (String string : targetTagsList) {
                    for (DataSourceTagConfig dataSourceTagConfig : tagConfigList) {
                        Set tagsHashSet = dataSourceTagConfig.getTagsHashSet();
                        if (!tagsHashSet.contains(string)) continue;
                        log.debug((Object)("Found match on tag '" + string + "'. Returning connection: " + dataSourceTagConfig.getIdentifier()));
                        return dataSourceTagConfig.getIdentifier();
                    }
                }
            }
            for (DataSourceTagConfig dataSourceTagConfig : tagConfigList) {
                if (!dataSourceTagConfig.isDefaultSource()) continue;
                log.debug((Object)("No matching tags. Returning default connection: " + dataSourceTagConfig.getIdentifier()));
                return dataSourceTagConfig.getIdentifier();
            }
            log.debug((Object)("No matching nor default data source found in the list of tagged data sources for the target tag(s) '" + targetTagsList + "'"));
            return null;
        }
        log.debug((Object)("No list of tagged data sources provided. Could not determine matching data source for tag(s) '" + targetTagsList + "'"));
        return null;
    }
}

