/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.impl;

import com.pingidentity.common.util.Substituter;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.unboundid.ldap.sdk.Filter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.SystemAttrLookupException;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.impl.AttributeSourceBase;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;

public class LdapAttributeSource
extends AttributeSourceBase {
    private static final long serialVersionUID = 20050515L;
    static final transient Log log = LogFactory.getLog(LdapAttributeSource.class);

    @Override
    public DataSource getDataSource() {
        if (!StringUtils.isBlank((String)this.dataSourceId)) {
            DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
            return dataSourceManager.getLdapDataSource(this.dataSourceId);
        }
        return null;
    }

    @Override
    public AttributeMap executeAttributeLookup(AttributeMap srcAttrs, Collection<String> attrNames) throws AttrLookupException {
        DataSource dataSrc = this.getDataSource();
        if (dataSrc instanceof LdapDataSource) {
            return this.executeLdapAttributeLookup((LdapDataSource)dataSrc, srcAttrs, attrNames);
        }
        return new AttributeMap();
    }

    @Override
    public Collection<String> getFilterAttributeReferences() {
        String searchBase;
        HashSet<String> result = new HashSet<String>();
        String filter = this.getParameter("filter");
        if (filter != null) {
            result.addAll(Substituter.parseReferences((String)filter));
        }
        if ((searchBase = this.getParameter("search_base")) != null) {
            result.addAll(Substituter.parseReferences((String)searchBase));
        }
        return result;
    }

    protected AttributeMap executeLdapAttributeLookup(LdapDataSource dataSource, AttributeMap srcAttrs, Collection<String> attrNames) throws AttrLookupException {
        try {
            String baseParam = this.getParameter("search_base");
            String base = Substituter.substituteValues(baseParam, (Map)srcAttrs);
            String filterParam = this.getParameter("filter");
            Map<String, String> escapedAttrs = this.escapeForLdapFilter(srcAttrs);
            String filter = Substituter.substituteValues(filterParam, escapedAttrs);
            String searchScopeStr = this.getParameter("search_scope");
            boolean memberOfNestedGroup = Boolean.valueOf(this.getParameter("memberof_nested_group"));
            Object[] attribNamesArray = new String[attrNames.size()];
            Object[] tmp = attrNames.toArray();
            for (int i = 0; i < attrNames.size(); ++i) {
                attribNamesArray[i] = (String)tmp[i];
            }
            if (log.isDebugEnabled()) {
                Set maskedAttrNames = srcAttrs.getMaskedAttributeNames();
                StringBuilder msg = new StringBuilder();
                msg.append("LDAP Attr Src search: search base=");
                msg.append(this.needMask(maskedAttrNames, baseParam) ? baseParam : base);
                msg.append(" | filter=");
                msg.append(this.needMask(maskedAttrNames, filterParam) ? filterParam : filter);
                msg.append(" | searchScope=").append(searchScopeStr);
                msg.append(" | attrNames=").append(Arrays.toString(attribNamesArray));
                msg.append(" | nestedGroup=").append(memberOfNestedGroup);
                log.debug((Object)msg.toString());
            }
            AttributeMap lookupResult = dataSource.getAttributesOfFirstMatchingObject(base, filter, searchScopeStr, (String[])attribNamesArray);
            this.applyEncodingToBinaryAttributes(dataSource, lookupResult);
            this.retrieveNestedGroupMembership(base, dataSource, lookupResult, memberOfNestedGroup);
            if (log.isDebugEnabled()) {
                log.debug((Object)("LDAP Attr Src search result: " + lookupResult));
            }
            return lookupResult;
        }
        catch (NamingException e) {
            String idForLog = this.id != null ? this.id : this.getType();
            String message = "Error occurred while performing an attribute lookup (" + idForLog + ")";
            throw new SystemAttrLookupException(message, e);
        }
        catch (Substituter.UnknownKeyException ex) {
            String idForLog = this.id != null ? this.id : this.getType();
            String message = "Error occurred while performing an attribute substitution (" + idForLog + ")";
            throw new AttrLookupException(message, (Throwable)((Object)ex));
        }
    }

    private void retrieveNestedGroupMembership(String base, LdapDataSource dataSource, AttributeMap lookupResult, boolean memberOfNestedGroup) throws NamingException {
        if (memberOfNestedGroup && LdapInfo.LdapType.ActiveDirectory.equals((Object)dataSource.getLdapType()) && lookupResult.containsKey((Object)"memberOf")) {
            List<AttributeMap> results;
            String dn = ((AttributeValue)lookupResult.get((Object)"Subject DN")).getValue();
            String encodedDN = Filter.encodeValue((String)dn);
            String nestedFilter = "member:1.2.840.113556.1.4.1941:=" + encodedDN;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving nested groups for memeberOf using filter: " + nestedFilter));
            }
            if (!Util.isEmpty(results = dataSource.getAttributesOfMatchingObjects(base, nestedFilter, 2, null, 0))) {
                ArrayList<String> groups = new ArrayList<String>();
                for (AttributeMap attributeMap : results) {
                    AttributeValue attributeValue = (AttributeValue)attributeMap.get((Object)"Subject DN");
                    groups.add(attributeValue.getValue());
                }
                AttributeValue nestedGroupsAttributeValues = AttrValueSupport.make(groups, (boolean)true);
                lookupResult.put("memberOf", nestedGroupsAttributeValues);
            }
        }
    }

    private void applyEncodingToBinaryAttributes(LdapDataSource dataSource, AttributeMap lookupResult) {
        for (String binaryAttribute : dataSource.getBinaryAttributes()) {
            if (!lookupResult.containsKey((Object)binaryAttribute)) continue;
            ArrayList<String> attrValuesArray = new ArrayList<String>();
            block7: for (Object value : ((AttributeValue)lookupResult.get((Object)binaryAttribute)).getAllObjectValues()) {
                byte[] attrBytes = (byte[])value;
                LdapDataSource.LdapAttrEncodingType encodingType = LdapDataSource.LdapAttrEncodingType.BASE64;
                if (this.getAttributeEncodingTypeMap().get(binaryAttribute) != null) {
                    encodingType = LdapDataSource.LdapAttrEncodingType.valueOf(this.getAttributeEncodingTypeMap().get(binaryAttribute));
                }
                switch (encodingType) {
                    case HEX: {
                        attrValuesArray.add(Hex.encodeHexString((byte[])attrBytes));
                        continue block7;
                    }
                    case SID: {
                        try {
                            String sid = LDAPUtil.convertBinarySidToString(attrBytes);
                            attrValuesArray.add(sid);
                        }
                        catch (Exception e) {
                            log.warn((Object)("An error occured when encoding " + binaryAttribute + ". Attribute will be encoded using Base64.  Encoding Error: " + e.getMessage()));
                            attrValuesArray.add(new String(Base64.encodeBase64((byte[])attrBytes, (boolean)false, (boolean)false), StandardCharsets.UTF_8));
                        }
                        continue block7;
                    }
                }
                attrValuesArray.add(new String(Base64.encodeBase64((byte[])attrBytes, (boolean)false, (boolean)false), StandardCharsets.UTF_8));
            }
            lookupResult.put(binaryAttribute, new AttributeValue(attrValuesArray));
        }
    }

    protected Map<String, String> escapeForLdapFilter(AttributeMap incoming) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : incoming.entrySet()) {
            AttributeValue value = (AttributeValue)entry.getValue();
            if (value != null) {
                result.put((String)entry.getKey(), LDAPUtil.encodeFilter(value.toString()));
                continue;
            }
            result.put((String)entry.getKey(), null);
        }
        return result;
    }

    @Override
    public String getType() {
        return DataSource.DSType.LDAP.toString();
    }
}

