/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.log;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.sdk.logging.LoggingUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.servlet.filter.ServletRequestCleanupService;
import org.sourceid.servlet.filter.ThreadLocalCleanupCallback;

public class AdminAuditLogger {
    private static final Log logger = LogFactory.getLog((String)"AuditLogger");
    private static final String KEY_EVENT = "event";
    protected static final String KEY_USER = "user";
    private static final String KEY_ROLES = "roles";
    private static final String KEY_COMPONENT = "component";
    protected static final String KEY_EVENTDETAILID = "eventdetailid";
    private static final String KEY_REMOTE_ADDRESS = "ip";
    private static final String KEY_ADMIN_SESSION_ID = "adminsessionid";
    public static final String KEY_ID_TOKEN_JTI = "idtjti";
    private static final String KEY_AT_HASH = "athash";
    private static final ThreadLocal<Deque<Boolean>> filesModified = ThreadLocal.withInitial(ArrayDeque::new);
    private static final ThreadLocal<Deque<String>> eventDetailIdStack = ThreadLocal.withInitial(ArrayDeque::new);

    public static void initEventDetail() {
        if (PropertyInfo.isEventDetailLogging()) {
            eventDetailIdStack.get().push(UUID.randomUUID().toString());
        }
        filesModified.get().push(false);
    }

    public static void log(Component component, Event event, String message) {
        message = StringUtils.isBlank((String)message) ? "" : message;
        AdminAuditLogger.handleEventDetailLoggingId();
        component = component == null ? Component.COMPONENT : component;
        event = event == null ? Event.EVENT : event;
        AdminAuditLogger.setLogAttribute(KEY_COMPONENT, component.name());
        AdminAuditLogger.setLogAttribute(KEY_EVENT, event.name());
        logger.info((Object)message);
    }

    private static void handleEventDetailLoggingId() {
        if (PropertyInfo.isEventDetailLogging() && AdminAuditLogger.isFilesModified()) {
            String eventDetailId = AdminAuditLogger.getEventDetailId();
            ThreadContext.put((String)KEY_EVENTDETAILID, (String)eventDetailId);
        } else {
            ThreadContext.remove((String)KEY_EVENTDETAILID);
        }
    }

    private static void setLogAttribute(String key, String value) {
        if (value == null) {
            ThreadContext.remove((String)key);
        } else {
            ThreadContext.put((String)key, (String)value);
        }
    }

    public static void setUser(String user) {
        String cleansedUser = LogGuard.truncateAndEncode(user);
        AdminAuditLogger.setLogAttribute(KEY_USER, cleansedUser);
    }

    public static void setRoles(String roles) {
        AdminAuditLogger.setLogAttribute(KEY_ROLES, roles);
    }

    public static void setIpAddress(String ipAddress) {
        AdminAuditLogger.setLogAttribute(KEY_REMOTE_ADDRESS, ipAddress);
    }

    public static void cleanupEventDetail() {
        ThreadContext.remove((String)KEY_EVENTDETAILID);
        ThreadContext.remove((String)KEY_COMPONENT);
        ThreadContext.remove((String)KEY_EVENT);
        AdminAuditLogger.removeItemFromStack(filesModified);
        if (PropertyInfo.isEventDetailLogging()) {
            AdminAuditLogger.removeItemFromStack(eventDetailIdStack);
        }
    }

    private static void removeItemFromStack(ThreadLocal<? extends Deque<?>> threadLocal) {
        if (!threadLocal.get().isEmpty()) {
            threadLocal.get().pop();
        }
        if (threadLocal.get().isEmpty()) {
            threadLocal.remove();
        }
    }

    public static void setFilesModified() {
        if (!filesModified.get().isEmpty()) {
            filesModified.get().pop();
        }
        filesModified.get().push(true);
    }

    public static boolean isFilesModified() {
        if (!filesModified.get().isEmpty()) {
            return filesModified.get().peek();
        }
        return false;
    }

    public static String getEventDetailId() {
        if (!eventDetailIdStack.get().isEmpty()) {
            return eventDetailIdStack.get().peek();
        }
        return null;
    }

    public static void setHashedSessionId(String hashedSessionId) {
        AdminAuditLogger.setLogAttribute(KEY_ADMIN_SESSION_ID, hashedSessionId);
    }

    public static void setCurrentIdTokenJti(String jti) {
        AdminAuditLogger.setLogAttribute(KEY_ID_TOKEN_JTI, jti);
    }

    public static void setCurrentAccessTokenHash(String accessToken) {
        Optional.ofNullable(LoggingUtil.calculateHashForLogging((String)accessToken)).ifPresent(hash -> ThreadContext.put((String)KEY_AT_HASH, (String)hash));
    }

    static {
        ServletRequestCleanupService.getAdminInstance().addCleanupCallback(new ThreadLocalCleanupCallback(filesModified));
        ServletRequestCleanupService.getAdminInstance().addCleanupCallback(new ThreadLocalCleanupCallback(eventDetailIdStack));
        ServletRequestCleanupService.getAdminInstance().addCleanupCallback((context, request, response) -> {
            ThreadContext.remove((String)KEY_USER);
            ThreadContext.remove((String)KEY_ROLES);
            ThreadContext.remove((String)KEY_REMOTE_ADDRESS);
            ThreadContext.remove((String)KEY_ADMIN_SESSION_ID);
            ThreadContext.remove((String)KEY_ID_TOKEN_JTI);
            ThreadContext.remove((String)KEY_AT_HASH);
        });
    }

    public static enum Event {
        EVENT,
        CREATE,
        MODIFY,
        DELETE,
        UNDELETE,
        EXPORT,
        IMPORT,
        DEPLOY,
        REPLICATE,
        SELECTIVE_REPLICATE,
        SIGNED,
        UPDATE,
        ROTATE,
        TEST_CONNECTION,
        VALIDATE_SECRET_REFERENCE,
        LOGIN_ATTEMPT,
        LOGOUT,
        PASSWORD_RESET,
        PASSWORD_CHANGE,
        ACTIVATE,
        DEACTIVATE,
        ROLE_CHANGE,
        NOTIFICATION_PUBLISHER_CHANGED,
        SESSION_TIMEOUT,
        TEST_EXPRESSION;

    }

    public static enum Component {
        COMPONENT,
        IDP_ADAPTER,
        SP_ADAPTER,
        TOKEN_PROCESSOR,
        TOKEN_GENERATOR,
        AUTH_SELECTOR,
        AUTH_SELECTION_POLICY,
        IDENTITY_STORE_PROVISIONER,
        PCV,
        OOB_AUTH_PLUGIN,
        SECRET_MANAGER,
        AUTHORIZATION_DETAIL_PROCESSOR,
        CAPTCHA_PROVIDER,
        OAUTH_SERVER_SETTINGS,
        OAUTH_SCOPE_SETTINGS,
        OAUTH_POLICY,
        OAUTH_CLIENTS,
        OAUTH_CLIENT_REGISTRATION_SETTINGS,
        OAUTH_CLIENT_REGISTRATION_POLICIES,
        OAUTH_RESOURCE_OWNER_CREDS_MAPPING,
        OAUTH_IDP_ADAPTER_MAPPING,
        OAUTH_APC_TO_PERS_GRANT_MAPPING,
        OAUTH_TEPP_TO_PRES_GRANT_MAPPING,
        OAUTH_ACCESS_TOKEN_MAPPING,
        OAUTH_ACCESS_TOKEN,
        OAUTH_OIDC_KEYS,
        OAUTH_OIDC_KEY_SETS,
        OAUTH_CIBA_POLICY,
        OAUTH_TOKEN_EXCHANGE_PROCESSOR_POLICY,
        OAUTH_TOKEN_EXCHANGE_GENERATOR_POLICY,
        OAUTH_TOKEN_EXCHANGE_PROCESSOR_POLICY_TO_TOKEN_GENERATOR_MAPPING,
        OAUTH_VIRTUAL_ISSUERS,
        OAUTH_AUTHORIZATION_DETAIL_TYPE,
        AUTHN_APPLICATIONS,
        AUTHN_API_SETTINGS,
        ADMIN_XML_SIGNATURES,
        APPLICATION_AUTH,
        ADAPTER_TO_ADAPTER_MAPPING,
        APC_TO_SP_ADAPTER_MAPPING,
        TOKEN_TO_TOKEN_MAPPING,
        AFFILIATION,
        ATTRIBUTE_REQUESTOR,
        BULK_CONFIG,
        CERTIFICATE,
        CERTIFICATE_REVOCATION,
        CERTIFICATE_ROTATION,
        CLUSTER_MANAGEMENT,
        CONFIG_ARCHIVE,
        CONTRACT_CONN_MAPPING,
        DATA_STORE,
        DEPLOYER,
        EXTENDED_PROPERTIES,
        GENERAL_SETTINGS,
        LOG_CATEGORY_SETTINGS,
        KERBEROS_SETTINGS,
        KERBEROS_REALM,
        SP_CONNECTION,
        SP_CONNECTION_DRAFT,
        IDP_CONNECTION,
        IDP_CONNECTION_DRAFT,
        REDIRECT_VALIDATION,
        SESSION_POLICIES,
        NOTIFICATION_PUBLISHERS,
        SERVER_SETTINGS,
        STS_REQUEST_PARAM,
        IDP_CONFIG_DEFAULT_URLS,
        SP_CONFIG_DEFAULT_URLS,
        LICENSE,
        METADATA,
        METADATA_URL,
        SYSTEM,
        TARGET_URL,
        USER,
        VIRTUAL_HOSTNAMES,
        SP_WHITE_LIST,
        IDP_WHITE_LIST,
        NOTIFICATION_SETTINGS,
        EMAIL_SERVER,
        ADMIN_CHANGES_NOTIFICATION_PUBLISHER,
        LOCAL_IDENTITY_PROFILE,
        SYSTEM_KEYS,
        POLICY_FRAGMENT,
        PINGONE_ACCOUNT_ASSOCIATION,
        PINGONE_IDP_METADATA,
        PINGONE_CONNECTION,
        CONFIGURATION_ENCRYPTION_KEYS,
        ADMIN_API_CORS_SETTINGS,
        AUDIT_LOGGING_SETTINGS;

    }
}

