/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.log;

import difflib.Delta;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.saml20.domain.log.AdminAuditLogger;

public class EventDetailAuditLogger {
    private static final String PLUS = " + ";
    private static final String MINUS = " - ";
    private static final Logger log = LogManager.getLogger((String)"EventDetailAuditLogger");

    private EventDetailAuditLogger() {
    }

    public static void log(List<Delta> deltas, String filename) {
        ThreadContext.put((String)"eventdetailid", (String)AdminAuditLogger.getEventDetailId());
        StringBuilder sb = new StringBuilder();
        for (Delta delta : deltas) {
            sb.setLength(0);
            ThreadContext.put((String)THREADCONTEXT_KEY.FILENAME.getName(), (String)filename);
            ThreadContext.put((String)THREADCONTEXT_KEY.POSITION.getName(), (String)String.valueOf(delta.getOriginal().getPosition()));
            sb.append(System.getProperty("line.separator"));
            switch (delta.getType()) {
                case CHANGE: {
                    ThreadContext.put((String)THREADCONTEXT_KEY.DELTA.getName(), (String)Delta.TYPE.CHANGE.name());
                    EventDetailAuditLogger.formatChunk(sb, MINUS, delta.getOriginal().getLines());
                    EventDetailAuditLogger.formatChunk(sb, PLUS, delta.getRevised().getLines());
                    log.info(sb.toString());
                    break;
                }
                case DELETE: {
                    ThreadContext.put((String)THREADCONTEXT_KEY.DELTA.getName(), (String)Delta.TYPE.DELETE.name());
                    EventDetailAuditLogger.formatChunk(sb, MINUS, delta.getOriginal().getLines());
                    log.info(sb.toString());
                    break;
                }
                case INSERT: {
                    ThreadContext.put((String)THREADCONTEXT_KEY.DELTA.getName(), (String)Delta.TYPE.INSERT.name());
                    EventDetailAuditLogger.formatChunk(sb, PLUS, delta.getRevised().getLines());
                    log.info(sb.toString());
                    break;
                }
            }
        }
        EventDetailAuditLogger.cleanup();
    }

    public static void cleanup() {
        for (THREADCONTEXT_KEY key : THREADCONTEXT_KEY.values()) {
            ThreadContext.remove((String)key.getName());
        }
    }

    private static void formatChunk(StringBuilder sb, String sign, List<?> lines) {
        for (Object line : lines) {
            sb.append(sign).append(line).append(System.getProperty("line.separator"));
        }
    }

    private static enum THREADCONTEXT_KEY {
        FILENAME("filename"),
        POSITION("position"),
        DELTA("delta");

        private final String name;

        private THREADCONTEXT_KEY(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

