/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserManagerCertImpl;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserManagerImpl;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserManagerLDAPImpl;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserManagerNullImpl;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserManagerRadiusImpl;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserOIDCManagerImpl;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public abstract class AbstractAuthManager {
    private static final Log LOG = LogFactory.getLog(AbstractAuthManager.class);
    protected static final String PF_AUTHENTICATION_PROPERTY_NONE = "none";
    protected static final String PF_AUTHENTICATION_PROPERTY_NATIVE = "native";
    protected static final String PF_AUTHENTICATION_PROPERTY_LDAP = "LDAP";
    protected static final String PF_AUTHENTICATION_PROPERTY_CERT = "cert";
    protected static final String PF_AUTHENTICATION_PROPERTY_RADIUS = "RADIUS";
    protected static final String PF_AUTHENTICATION_PROPERTY_OIDC = "OIDC";
    protected static final String PF_AUTHENTICATION_PROPERTY_OAUTH = "OAuth2";
    protected static final String PF_AUTHENTICATION_PROPERTY_JWT = "JWT";
    private final String authMethod = this.getPropertyValue(this.getPropertyName());
    private AdminUserManager userManager = null;

    private String getPropertyValue(String property) {
        String propValue = System.getProperty(property, this.getDefaultPropertyValue());
        if (this.isPropertyValid(propValue)) {
            LOG.info((Object)(this.getPropertyName() + " Authentication: " + propValue));
            return propValue;
        }
        LOG.warn((Object)(this.getPropertyName() + ": " + propValue + " is not a valid authentication type. Defaulting to " + this.getDefaultPropertyValue()));
        return this.getDefaultPropertyValue();
    }

    protected String getDefaultPropertyValue() {
        return PF_AUTHENTICATION_PROPERTY_NATIVE;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    protected boolean isPropertyValid(String property) {
        return PF_AUTHENTICATION_PROPERTY_NONE.equalsIgnoreCase(property) || PF_AUTHENTICATION_PROPERTY_NATIVE.equalsIgnoreCase(property) || PF_AUTHENTICATION_PROPERTY_LDAP.equalsIgnoreCase(property) || PF_AUTHENTICATION_PROPERTY_CERT.equalsIgnoreCase(property) || PF_AUTHENTICATION_PROPERTY_RADIUS.equalsIgnoreCase(property);
    }

    public boolean isNullAuthnMethod() {
        return PF_AUTHENTICATION_PROPERTY_NONE.equalsIgnoreCase(this.authMethod);
    }

    public boolean isLdap() {
        return PF_AUTHENTICATION_PROPERTY_LDAP.equalsIgnoreCase(this.authMethod);
    }

    public boolean isCert() {
        return PF_AUTHENTICATION_PROPERTY_CERT.equalsIgnoreCase(this.authMethod);
    }

    public boolean isRadius() {
        return PF_AUTHENTICATION_PROPERTY_RADIUS.equalsIgnoreCase(this.authMethod);
    }

    public boolean isOidc() {
        return PF_AUTHENTICATION_PROPERTY_OIDC.equalsIgnoreCase(this.authMethod);
    }

    public boolean isOAuth2() {
        return PF_AUTHENTICATION_PROPERTY_OAUTH.equalsIgnoreCase(this.authMethod);
    }

    public boolean isNative() {
        return PF_AUTHENTICATION_PROPERTY_NATIVE.equalsIgnoreCase(this.authMethod);
    }

    public boolean isBasicAuthentication() {
        return this.isNative() || this.isLdap() || this.isRadius();
    }

    public synchronized AdminUserManager getAdminUserManager() {
        if (this.userManager == null) {
            this.userManager = this.initUserManager();
        }
        return this.userManager;
    }

    public boolean hasAdminManager() {
        for (AdministrativeUser user : this.getAdminUserManager().getUsers()) {
            if (!user.isActive() || !user.isAdminManager()) continue;
            return true;
        }
        return false;
    }

    protected AdminUserManager initUserManager() {
        if (this.isNullAuthnMethod()) {
            return new AdminUserManagerNullImpl();
        }
        if (this.isLdap()) {
            return new AdminUserManagerLDAPImpl();
        }
        if (this.isCert()) {
            return new AdminUserManagerCertImpl();
        }
        if (this.isRadius()) {
            return new AdminUserManagerRadiusImpl();
        }
        if (this.isOidc()) {
            return new AdminUserOIDCManagerImpl();
        }
        return AdminUserManagerImpl.getInstance();
    }

    protected abstract String getPropertyName();

    protected abstract String getName();
}

