/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.authnselection.ApcMappingAction;
import com.pingidentity.authnselection.AttributeRule;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.AuthnSelectorAction;
import com.pingidentity.authnselection.AuthnSourceAction;
import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.authnselection.NoOpAction;
import com.pingidentity.authnselection.fragment.FragmentAction;
import com.pingidentity.authnselection.xmlbinding.ApcMappingActionType;
import com.pingidentity.authnselection.xmlbinding.AstActionType;
import com.pingidentity.authnselection.xmlbinding.AstNodeType;
import com.pingidentity.authnselection.xmlbinding.AttributeRuleType;
import com.pingidentity.authnselection.xmlbinding.AuthnSelectionTreeType;
import com.pingidentity.authnselection.xmlbinding.AuthnSelectorActionType;
import com.pingidentity.authnselection.xmlbinding.AuthnSourceActionType;
import com.pingidentity.authnselection.xmlbinding.AuthnSourceKeyType;
import com.pingidentity.authnselection.xmlbinding.FragmentActionType;
import com.pingidentity.authnselection.xmlbinding.LocalIdentityMappingActionType;
import com.pingidentity.authnselection.xmlbinding.NoOpActionType;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConditionType;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.SourceTypeString;
import org.sourceid.saml20.metadata.partner.ConnectionUtil;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeMapType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeMappingType;

public abstract class AbstractPolicyTreeConfigManager {
    private static final Log LOG = LogFactory.getLog(AbstractPolicyTreeConfigManager.class);

    protected AuthnSelectionTree parseTreeFromDoc(AuthnSelectionTreeType rootNode) {
        try {
            Tree.Node<AuthnSelectionAction> asaRootNode = this.buildAuthnSelectionActionNode(rootNode.getAstRoot());
            AuthnSelectionTree ast = new AuthnSelectionTree(asaRootNode);
            ast.setId(rootNode.getTreeId());
            ast.setDescription(rootNode.getTreeDescription());
            ast.setName(rootNode.getTreeName());
            ast.setDisabled(rootNode.getDisabled());
            ast.setOverrideAuthnApiApplicationId(rootNode.getAuthnApiApp());
            ast.setHandleFailuresLocally(rootNode.getHandleFailuresLocally());
            return ast;
        }
        catch (TreeLoadException e) {
            LOG.error((Object)("Unable to load authn selection tree. Skipping. Reason: " + e.getMessage()));
            return null;
        }
    }

    protected Tree.Node<AuthnSelectionAction> buildAuthnSelectionActionNode(AstNodeType xmlNode) throws TreeLoadException {
        ConnectionUtil connUtil;
        AstActionType xmlAstAction = xmlNode.getAstAction();
        AuthnSelectionAction newAction = null;
        if (xmlAstAction instanceof AuthnSelectorActionType) {
            newAction = new AuthnSelectorAction(((AuthnSelectorActionType)xmlAstAction).getAuthnSelectorId());
        } else if (xmlAstAction instanceof AuthnSourceActionType) {
            AuthnSourceActionType asat = (AuthnSourceActionType)xmlAstAction;
            AuthnSourceAction authnSourceAction = new AuthnSourceAction(this.buildAuthnSourceKey(asat.getAuthnSourceKey()));
            List<AttributeRule> attrRules = this.parseAttributeRules(asat.getAttributeRuleArray());
            authnSourceAction.setAttributeRules(attrRules);
            if (asat.isSetFallbackToSuccess()) {
                authnSourceAction.setFallbackToSuccess(asat.getFallbackToSuccess());
            }
            if (asat.isSetInputIdMapping()) {
                AttributeMapType amt = asat.getInputIdMapping();
                authnSourceAction.setInputUserIdMapping(new AttrMappingValue(SourceTypeString.strToType(amt.getType()), amt.isSetValue() ? amt.getValue() : amt.getValueText(), null, amt.getAttributeSourceId()));
            }
            authnSourceAction.setUserIdAuthenticated(asat.getUserIdAuthenticated());
            newAction = authnSourceAction;
        } else if (xmlAstAction instanceof ApcMappingActionType) {
            ApcMappingActionType apcMappingActionType = (ApcMappingActionType)xmlAstAction;
            String apcId = apcMappingActionType.getApcId();
            connUtil = new ConnectionUtil();
            AttributeMapping attrMapping = connUtil.getAttributeMapping(apcMappingActionType.getAttributeMapping());
            newAction = new ApcMappingAction(apcId, attrMapping);
        } else if (xmlAstAction instanceof LocalIdentityMappingActionType) {
            LocalIdentityMappingActionType lipMappingActionType = (LocalIdentityMappingActionType)xmlAstAction;
            String lipId = lipMappingActionType.getLipId();
            connUtil = new ConnectionUtil();
            AttributeMapping inboundAttrMapping = connUtil.getAttributeMapping(lipMappingActionType.getInboundAttributeMapping());
            AttributeMapping outboundAttrMapping = connUtil.getAttributeMapping(lipMappingActionType.getOutboundAttributeMapping());
            newAction = new LocalIdentityMappingAction(lipId, inboundAttrMapping, outboundAttrMapping);
        } else if (xmlAstAction instanceof FragmentActionType) {
            FragmentActionType fragmentActionType = (FragmentActionType)xmlAstAction;
            ConnectionUtil connUtil2 = new ConnectionUtil();
            AttributeMapping mapping = connUtil2.getFragmentInputAttributeMapping(fragmentActionType.getAttributeMapping());
            newAction = new FragmentAction(fragmentActionType.getFragmentId(), this.parseAttributeRules(fragmentActionType.getAttributeRuleArray()), fragmentActionType.getFallbackToSuccess(), mapping);
        } else if (xmlAstAction instanceof NoOpActionType) {
            NoOpAction.Type type;
            String xmlType = ((NoOpActionType)xmlAstAction).getNoOpType();
            try {
                type = NoOpAction.Type.valueOf(xmlType);
            }
            catch (IllegalArgumentException e) {
                throw new TreeLoadException("NoOpAction type '" + xmlType + "' is not recognized.");
            }
            newAction = new NoOpAction(type);
        } else {
            throw new TreeLoadException("Node type '" + xmlAstAction.getClass().getSimpleName() + "' is not handled.");
        }
        String context = xmlNode.getContext();
        if (context != null) {
            newAction.setContext(context);
        }
        Tree.Node asaNode = new Tree.Node((Object)newAction);
        for (AstNodeType xmlChildNode : xmlNode.getAstChildArray()) {
            asaNode.addChildNode(this.buildAuthnSelectionActionNode(xmlChildNode));
        }
        return asaNode;
    }

    protected List<AttributeRule> parseAttributeRules(AttributeRuleType[] ruleArray) {
        ArrayList<AttributeRule> attrRules = new ArrayList<AttributeRule>();
        for (AttributeRuleType xmlAttrRule : ruleArray) {
            AttributeRule attrRule = new AttributeRule();
            if (xmlAttrRule.getSourceType() != null) {
                attrRule.setAuthenticationSourceType(SourceType.valueOf(xmlAttrRule.getSourceType()));
                attrRule.setAuthenticationSourceId(xmlAttrRule.getAuthenticationSourceId());
            }
            if (xmlAttrRule.getSourceType() == null || !SourceType.EXPRESSION.equals((Object)SourceType.valueOf(xmlAttrRule.getSourceType()))) {
                attrRule.setAttribute(xmlAttrRule.getIncomingAttr());
                attrRule.setCondition(ConditionType.valueOf(xmlAttrRule.getOperand()));
                attrRule.setExpectedValue(xmlAttrRule.getExpectedValue());
            } else {
                attrRule.setExpression(xmlAttrRule.getExpression());
            }
            attrRule.setResult(xmlAttrRule.getResult());
            attrRules.add(attrRule);
        }
        return attrRules;
    }

    private AuthnSourceKey buildAuthnSourceKey(AuthnSourceKeyType xmlAskt) throws TreeLoadException {
        AuthnSourceKey authnSourceKey;
        String xmlActionType = xmlAskt.getType();
        String xmlActionId = xmlAskt.getStringValue();
        if (AuthnSourceKey.AuthnSourceType.ADAPTER.name().equals(xmlActionType)) {
            authnSourceKey = new AdapterAuthnSourceKey(xmlActionId);
        } else if (AuthnSourceKey.AuthnSourceType.IDP_CONN.name().equals(xmlActionType)) {
            authnSourceKey = new IdpConnAuthnSourceKey(xmlActionId);
        } else {
            throw new TreeLoadException("AuthnSource '" + xmlActionType + "' is not handled.");
        }
        return authnSourceKey;
    }

    protected void convertTreeToXml(AuthnSelectionTree authnSelectionTree, AuthnSelectionTreeType xmlAst) {
        if (StringUtils.isNotBlank((String)authnSelectionTree.getId())) {
            xmlAst.setTreeId(authnSelectionTree.getId());
        }
        if (StringUtils.isNotBlank((String)authnSelectionTree.getName())) {
            xmlAst.setTreeName(authnSelectionTree.getName());
        }
        if (StringUtils.isNotBlank((String)authnSelectionTree.getDescription())) {
            xmlAst.setTreeDescription(authnSelectionTree.getDescription());
        }
        xmlAst.setDisabled(authnSelectionTree.isDisabled());
        xmlAst.setAuthnApiApp(authnSelectionTree.getOverrideAuthnApiApplicationId());
        xmlAst.setHandleFailuresLocally(authnSelectionTree.isHandleFailuresLocally());
        Tree.Node rootNode = authnSelectionTree.getRootNode();
        AstNodeType xmlAstRootNode = xmlAst.addNewAstRoot();
        this.convertAsaNodeToXml((Tree.Node<AuthnSelectionAction>)rootNode, xmlAstRootNode);
    }

    protected void convertAsaNodeToXml(Tree.Node<AuthnSelectionAction> asaNode, AstNodeType xmlAstNode) {
        Object xmlAstAction;
        AuthnSelectionAction asAction = (AuthnSelectionAction)asaNode.getData();
        if (asAction instanceof AuthnSourceAction) {
            AuthnSourceAction asaAction = (AuthnSourceAction)asAction;
            AuthnSourceKey authnSourceKey = asaAction.getAuthnSourceKey();
            AuthnSourceActionType xmlAuthnSourceAction = AuthnSourceActionType.Factory.newInstance();
            AuthnSourceKeyType xmlAuthnSourceKey = xmlAuthnSourceAction.addNewAuthnSourceKey();
            xmlAuthnSourceKey.setType(authnSourceKey.getType().name());
            xmlAuthnSourceKey.setStringValue(authnSourceKey.getId());
            for (AttributeRule attrRule : asaAction.getAttributeRules()) {
                AttributeRuleType xmlAttrRule = xmlAuthnSourceAction.addNewAttributeRule();
                if (attrRule.getAuthenticationSourceType() != null) {
                    xmlAttrRule.setSourceType(attrRule.getAuthenticationSourceType().toString());
                    xmlAttrRule.setAuthenticationSourceId(attrRule.getAuthenticationSourceId());
                }
                if (attrRule.getAuthenticationSourceType() == null || !SourceType.EXPRESSION.equals((Object)attrRule.getAuthenticationSourceType())) {
                    xmlAttrRule.setIncomingAttr(attrRule.getAttribute());
                    xmlAttrRule.setOperand(attrRule.getCondition().name());
                    xmlAttrRule.setExpectedValue(attrRule.getExpectedValue());
                } else {
                    xmlAttrRule.setExpression(attrRule.getExpression());
                }
                xmlAttrRule.setResult(attrRule.getResult());
            }
            xmlAuthnSourceAction.setFallbackToSuccess(asaAction.isFallbackToSuccess());
            AttrMappingValue inputUserId = asaAction.getInputUserIdMapping();
            if (inputUserId != null) {
                AttributeMapType xmlUserIdInput = xmlAuthnSourceAction.addNewInputIdMapping();
                xmlUserIdInput.setType(inputUserId.getTypeString());
                if (inputUserId.getAttributeSourceId() != null) {
                    xmlUserIdInput.setAttributeSourceId(inputUserId.getAttributeSourceId());
                }
                xmlUserIdInput.setValueText(inputUserId.getValue());
            }
            xmlAuthnSourceAction.setUserIdAuthenticated(asaAction.isUserIdAuthenticated());
            xmlAstAction = xmlAuthnSourceAction;
        } else if (asAction instanceof AuthnSelectorAction) {
            String authnSelectorId = ((AuthnSelectorAction)asAction).getAuthnSelectorId();
            AuthnSelectorActionType xmlAuthnSelectorAction = AuthnSelectorActionType.Factory.newInstance();
            xmlAuthnSelectorAction.setAuthnSelectorId(authnSelectorId);
            xmlAstAction = xmlAuthnSelectorAction;
        } else if (asAction instanceof ApcMappingAction) {
            ApcMappingAction apcMappingAction = (ApcMappingAction)asAction;
            String apcId = apcMappingAction.getApcId();
            ApcMappingActionType xmlApcMappingType = ApcMappingActionType.Factory.newInstance();
            xmlApcMappingType.setApcId(apcId);
            AttributeMappingType xmlAttrMappingType = xmlApcMappingType.addNewAttributeMapping();
            ConnectionUtil connUtil = new ConnectionUtil();
            connUtil.fillInAttributeMappingType(xmlAttrMappingType, apcMappingAction.getAttributeMapping());
            xmlAstAction = xmlApcMappingType;
        } else if (asAction instanceof LocalIdentityMappingAction) {
            LocalIdentityMappingAction lipMappingAction = (LocalIdentityMappingAction)asAction;
            String lipId = lipMappingAction.getLipId();
            LocalIdentityMappingActionType xmlLipMappingType = LocalIdentityMappingActionType.Factory.newInstance();
            xmlLipMappingType.setLipId(lipId);
            AttributeMappingType xmlLipInboundAttrMappingType = xmlLipMappingType.addNewInboundAttributeMapping();
            AttributeMappingType xmlLipOutboundAttrMappingType = xmlLipMappingType.addNewOutboundAttributeMapping();
            ConnectionUtil connUtil = new ConnectionUtil();
            if (lipMappingAction.getInboundAttributeMapping() != null) {
                connUtil.fillInAttributeMappingType(xmlLipInboundAttrMappingType, lipMappingAction.getInboundAttributeMapping());
            }
            connUtil.fillInAttributeMappingType(xmlLipOutboundAttrMappingType, lipMappingAction.getOutboundAttributeMapping());
            xmlAstAction = xmlLipMappingType;
        } else if (asAction instanceof FragmentAction) {
            FragmentAction fragmentAction = (FragmentAction)asAction;
            FragmentActionType xmlFragmentType = FragmentActionType.Factory.newInstance();
            xmlFragmentType.setFragmentId(fragmentAction.getFragmentId());
            xmlFragmentType.setFallbackToSuccess(fragmentAction.isFallbackToSuccess());
            for (AttributeRule attrRule : fragmentAction.getAttributeRules()) {
                AttributeRuleType xmlAttrRule = xmlFragmentType.addNewAttributeRule();
                if (attrRule.getAuthenticationSourceType() != null) {
                    xmlAttrRule.setSourceType(attrRule.getAuthenticationSourceType().toString());
                    xmlAttrRule.setAuthenticationSourceId(attrRule.getAuthenticationSourceId());
                }
                if (attrRule.getAuthenticationSourceType() == null || !SourceType.EXPRESSION.equals((Object)attrRule.getAuthenticationSourceType())) {
                    xmlAttrRule.setIncomingAttr(attrRule.getAttribute());
                    xmlAttrRule.setOperand(attrRule.getCondition().name());
                    xmlAttrRule.setExpectedValue(attrRule.getExpectedValue());
                } else {
                    xmlAttrRule.setExpression(attrRule.getExpression());
                }
                xmlAttrRule.setResult(attrRule.getResult());
            }
            AttributeMappingType xmlAttrMappingType = xmlFragmentType.addNewAttributeMapping();
            ConnectionUtil connUtil = new ConnectionUtil();
            connUtil.fillInAttributeMappingType(xmlAttrMappingType, fragmentAction.getAttributeMapping());
            xmlAstAction = xmlFragmentType;
        } else if (asAction instanceof NoOpAction) {
            String action = ((NoOpAction)asAction).getType().name();
            NoOpActionType xmlNoOpAction = NoOpActionType.Factory.newInstance();
            xmlNoOpAction.setNoOpType(action);
            xmlAstAction = xmlNoOpAction;
        } else {
            throw new IllegalStateException("AuthnSelectionAction '" + asAction.getClass().getSimpleName() + "' is not handled.");
        }
        xmlAstNode.setAstAction((AstActionType)xmlAstAction);
        xmlAstNode.setContext(asAction.getContext());
        if (asaNode.hasChildren()) {
            for (Tree.Node childAsaNode : asaNode.getChildren()) {
                AstNodeType xmlChildAstNode = xmlAstNode.addNewAstChild();
                this.convertAsaNodeToXml((Tree.Node<AuthnSelectionAction>)childAsaNode, xmlChildAstNode);
            }
        }
    }

    public static class TreeLoadException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TreeLoadException(String msg) {
            super(msg);
        }
    }
}

