/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.ConfigEventListener;
import com.pingidentity.configservice.ConfigEventType;
import com.pingidentity.configservice.ListenerRegistry;
import com.pingidentity.configservice.Reloadable;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.sourceid.a2a.domain.mgmt.Adapter2AdapterManager;
import org.sourceid.a2a.domain.mgmt.Apc2SpAdapterManager;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.UserAuthorizationConsentPageSetting;
import org.sourceid.saml20.adapter.AuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.kerberos.KerberosRealmFieldDescriptor;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.sp.authn.SpAuthenticationAdapter;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.UrlToTargetMapping;
import org.sourceid.saml20.domain.UrlToTargetMappings;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.ConfigurationException;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdapterMgmtConfigSupport;
import org.sourceid.saml20.domain.mgmt.impl.AdapterUser;
import org.sourceid.saml20.domain.mgmt.impl.IdpAdapterMgmtConfigSupport;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementFactory;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.domain.mgmt.impl.PluginSupport;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.TargetSessionId;

public class AdapterManagerImpl
implements AdapterManager,
AutoReloadable {
    private final Log log = LogFactory.getLog(this.getClass());
    private Adapter2AdapterManager adapter2AdapterManager;
    private AuthzServerManager authzServerManager;
    private AuthnSelectionConfigManager adapterSelectorConfigManager;
    private final PluginManagementSupport idpMgmtSupport;
    private final PluginManagementSupport spMgmtSupport;

    public AdapterManagerImpl() {
        PluginManagementFactory pluginManagementFactory = new PluginManagementFactory();
        this.idpMgmtSupport = pluginManagementFactory.makeIdpAdapterMgmtSupport();
        this.spMgmtSupport = pluginManagementFactory.makeSpAdapterMgmtSupport();
    }

    public void finishInit() {
        this.idpMgmtSupport.loadInstanceCaches();
        this.spMgmtSupport.loadInstanceCaches();
        this.idpMgmtSupport.earlyLoadConfigurations();
        this.spMgmtSupport.earlyLoadConfigurations();
    }

    @Override
    public void reloadConnBasedPluginOverrides(ConnectionBase conn) {
        if (conn instanceof IdpConnection) {
            this.spMgmtSupport.reloadConnBasedInstances(conn);
        } else {
            this.idpMgmtSupport.reloadConnBasedInstances(conn);
        }
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ADAPTERS_UPDATED);
    }

    @Override
    public void removeConnBasedPluginOverrides(ConnectionBase conn) {
        if (conn instanceof IdpConnection) {
            this.spMgmtSupport.removeConnBasedInstances(conn);
        } else {
            this.idpMgmtSupport.removeConnBasedInstances(conn);
        }
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ADAPTERS_UPDATED);
    }

    @Override
    public void clearVirtualInstanceCache() {
        this.idpMgmtSupport.clearVirtualInstanceCache();
        this.spMgmtSupport.clearVirtualInstanceCache();
    }

    @Override
    public void clearLocalIdentityInstanceCache() {
        this.idpMgmtSupport.clearLipInstanceCache();
    }

    public void setAuthzServerManager(AuthzServerManager authzServerManager) {
        this.authzServerManager = authzServerManager;
    }

    @Override
    public Adapter2AdapterManager getAdapter2AdapterManager() {
        return this.adapter2AdapterManager;
    }

    public void setAdapter2AdapterManager(Adapter2AdapterManager adapter2AdapterManager) {
        this.adapter2AdapterManager = adapter2AdapterManager;
    }

    public void setAdapterSelectorConfigManager(AuthnSelectionConfigManager adapterSelectorConfigManager) {
        this.adapterSelectorConfigManager = adapterSelectorConfigManager;
    }

    @Override
    public void registerForReloadEvents(Reloadable reloadable) {
        MgmtFactory.getMediator().registerForReloadEvents(reloadable);
        ListenerRegistry.getInstance().addListener(ConfigEventType.ADAPTERS_RELOADED, reloadable, r -> r.reload());
    }

    @Override
    public void registerForConfigEvents(ConfigEventListener listener) {
        ListenerRegistry.getInstance().addListener(ConfigEventType.ADAPTERS_UPDATED, listener, l -> l.onConfigUpdated());
    }

    @Override
    public void registerForIdpReloadEvents(Reloadable reloadable) {
        this.registerForReloadEvents(reloadable);
    }

    @Override
    public void registerForSpReloadEvents(Reloadable reloadable) {
        this.registerForReloadEvents(reloadable);
    }

    @Override
    public void reload() {
        this.idpMgmtSupport.clearInstanceCaches();
        this.spMgmtSupport.clearInstanceCaches();
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ADAPTERS_RELOADED);
    }

    @Override
    public void reloadIdpAdapters() {
        this.idpMgmtSupport.clearInstanceCaches();
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ADAPTERS_RELOADED);
    }

    @Override
    public void reloadSpAdapters() {
        this.spMgmtSupport.clearInstanceCaches();
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ADAPTERS_RELOADED);
    }

    @Override
    public Collection<AuthnAdapterDescriptor> getInstalledSpAuthnAdapterDescriptors() {
        Collection<PluginDescriptor> installedPluginDescriptors = this.spMgmtSupport.getInstalledPluginDescriptors();
        return installedPluginDescriptors;
    }

    @Override
    public Collection<IdpAuthnAdapterDescriptor> getInstalledIdpAuthnAdapterDescriptors() {
        Collection<PluginDescriptor> installedPluginDescriptors = this.idpMgmtSupport.getInstalledPluginDescriptors();
        return installedPluginDescriptors;
    }

    public IdpAuthnAdapterDescriptor getIdpAuthnAdapterDescriptor(String className) {
        return (IdpAuthnAdapterDescriptor)this.getAuthnAdapterDescriptor(className);
    }

    public AuthnAdapterDescriptor getAuthnAdapterDescriptor(String className) {
        Collection<AuthnAdapterDescriptor> installedDescriptors = this.getInstalledSpAuthnAdapterDescriptors();
        installedDescriptors.addAll(this.getInstalledIdpAuthnAdapterDescriptors());
        for (AuthnAdapterDescriptor desc : installedDescriptors) {
            String adapterClassName = desc.getAdapterClassName();
            if (!className.equals(adapterClassName)) continue;
            return desc;
        }
        return null;
    }

    @Override
    public Collection<IdpAuthnAdapterInstance> getIdpAuthnAdapterInstances() {
        Collection<ConfigurablePluginInstance> pluginInstances = this.idpMgmtSupport.getPluginInstances();
        return pluginInstances;
    }

    @Override
    public Collection<IdpAuthnAdapterInstance> getIdpAuthnAdapterNonConnectionBasedInstances() {
        Collection<ConfigurablePluginInstance> pluginInstances = this.idpMgmtSupport.getNonConnectionBasedPlugins();
        return pluginInstances;
    }

    @Override
    public Collection<IdpAuthnAdapterInstance> getIdpAuthnAdapterVirtualInstances() {
        Collection<ConfigurablePluginInstance> pluginInstances = this.idpMgmtSupport.getVirtualPlugins();
        return pluginInstances;
    }

    @Override
    public void saveIdpAuthnAdapterInstance(ConfigurablePluginInstance instance) {
        this.idpMgmtSupport.savePluginInstance(instance);
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ADAPTERS_UPDATED);
    }

    @Override
    public void deleteIdpAuthnAdapterInstance(ConfigurablePluginInstance instance) {
        MgmtFactory.getAuthnSessionPolicyManager().deleteSourcePolicyBySourceKey(new AdapterAuthnSourceKey(instance.getId()));
        this.idpMgmtSupport.deletePluginInstance(instance);
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ADAPTERS_UPDATED);
    }

    @Override
    public boolean isIdpAuthnAdapterInstanceInUse(String instanceId) {
        return this.isIdpAuthnAdapterInstanceInUseInternally(instanceId) || this.isIdpAuthnAdapterInstanceInUseExternally(instanceId);
    }

    @Override
    public boolean isIdpAuthnAdapterInstanceInUseInternally(String instanceId) {
        for (AuthnAdapterInstance instance : MgmtFactory.getIdpAdapterManager().getInstances()) {
            String parentId = instance.getParentId();
            if (parentId != null && parentId.equals(instanceId)) {
                return true;
            }
            IdpAuthenticationAdapter adapter = this.getIdpAuthnAdapter(instance.getId());
            if (!(adapter instanceof AdapterUser) || !((AdapterUser)adapter).isInUse(instanceId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIdpAuthnAdapterInstanceInUseExternally(String instanceId) {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        return connectionManager.getSpConnectionsUsingAdapterInstance(instanceId).size() > 0 || this.adapter2AdapterManager.isSourceInUse(instanceId) || this.authzServerManager.getAdapterToUserKeyMapping(instanceId) != null || this.adapterSelectorConfigManager.isAuthnSourceInUse(new AdapterAuthnSourceKey(instanceId)) || MgmtFactory.getAuthnSelectorManager().isAuthnSourceInUse(new AdapterAuthnSourceKey(instanceId)) || MgmtFactory.getPolicyFragmentManager().isAuthnSourceInUse(new AdapterAuthnSourceKey(instanceId)) || UserAuthorizationConsentPageSetting.ADAPTER.getValue().equals(this.authzServerManager.getAuthzConsentSetting()) && instanceId.equals(this.authzServerManager.getExternalConsentAdapterId());
    }

    @Override
    public IdpAuthnAdapterInstance getIdpAuthnAdapterInstance(String instanceId) {
        ConfigurablePluginInstance pluginInstance = this.idpMgmtSupport.getPluginInstance(instanceId);
        return (IdpAuthnAdapterInstance)pluginInstance;
    }

    @Override
    public AuthnAdapterInstance getSpAuthnAdapterInstance(String instanceId) {
        ConfigurablePluginInstance pluginInstance = this.spMgmtSupport.getPluginInstance(instanceId);
        return (AuthnAdapterInstance)pluginInstance;
    }

    @Override
    public Collection<AuthnAdapterInstance> getSpAuthnAdapterInstances() {
        Collection<ConfigurablePluginInstance> pluginInstances = this.spMgmtSupport.getPluginInstances();
        return pluginInstances;
    }

    @Override
    public Collection<AuthnAdapterInstance> getSpAuthnAdapterNonConnectionBasedInstances() {
        Collection<ConfigurablePluginInstance> pluginInstances = this.spMgmtSupport.getNonConnectionBasedPlugins();
        return pluginInstances;
    }

    @Override
    public Collection<AuthnAdapterInstance> getSpAuthnAdapterVirtualInstances() {
        Collection<ConfigurablePluginInstance> pluginInstances = this.spMgmtSupport.getVirtualPlugins();
        return pluginInstances;
    }

    @Override
    public boolean isSpAuthnAdapterInstanceInUse(String instanceId) {
        return this.isSpAuthnAdapterInstanceInUseInternally(instanceId) || this.isSpAuthnAdapterInstanceInUseExternally(instanceId);
    }

    @Override
    public boolean isSpAuthnAdapterInstanceInUseInternally(String instanceId) {
        for (AuthnAdapterInstance instance : MgmtFactory.getSpAdapterManager().getInstances()) {
            String parentId = instance.getParentId();
            if (parentId == null || !parentId.equals(instanceId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSpAuthnAdapterInstanceInUseExternally(String instanceId) {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        Apc2SpAdapterManager apc2SpAdapterMgr = MgmtFactory.getApc2SpAdapterManager();
        if (connectionManager.getIdpConnectionsUsingAdapterInstance(instanceId).size() > 0 || this.adapter2AdapterManager.isTargetInUse(instanceId) || apc2SpAdapterMgr.isTargetInUse(instanceId)) {
            return true;
        }
        UrlToTargetMappings urlMapping = MgmtFactory.getLocalSettingsManager().getUrlToAdapterMapping();
        for (UrlToTargetMapping urlEntry : urlMapping.getMappings()) {
            if (urlEntry.getTargetType() != TargetSessionId.TargetSessionType.ADAPTER || !urlEntry.getTargetId().equals(instanceId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDuplicateInstanceId(String instanceId) {
        return this.idpMgmtSupport.isDuplicateInstanceId(instanceId) || this.spMgmtSupport.isDuplicateInstanceId(instanceId);
    }

    @Override
    public void saveSpAuthnAdapterInstance(ConfigurablePluginInstance instance) {
        this.spMgmtSupport.savePluginInstance(instance);
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ADAPTERS_UPDATED);
    }

    @Override
    public void deleteSpAuthnAdapterInstance(ConfigurablePluginInstance instance) {
        this.spMgmtSupport.deletePluginInstance(instance);
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ADAPTERS_UPDATED);
    }

    @Override
    public IdpAuthenticationAdapter getIdpAuthnAdapter(String instanceId) {
        ConfigurablePlugin plugin = this.idpMgmtSupport.getPlugin(instanceId);
        return (IdpAuthenticationAdapter)plugin;
    }

    @Override
    public SpAuthenticationAdapter getSpAuthnAdapter(String instanceId) {
        ConfigurablePlugin plugin = this.spMgmtSupport.getPlugin(instanceId);
        return (SpAuthenticationAdapter)plugin;
    }

    @Override
    public String exportIdpAdapterConfiguration(String instanceId) {
        String xml = null;
        IdpAuthnAdapterInstance idpAdapterInstance = this.getIdpAuthnAdapterInstance(instanceId);
        if (idpAdapterInstance != null) {
            IdpAdapterMgmtConfigSupport support = new IdpAdapterMgmtConfigSupport();
            xml = support.toXml(idpAdapterInstance);
        }
        return xml;
    }

    @Override
    public void importIdpAdapterConfiguration(String instanceId, String className, String xml, String parentId, boolean allowUpdate) throws XmlException, ConfigurationException {
        IdpAdapterMgmtConfigSupport idpAdapterMgmtConfigSupport = new IdpAdapterMgmtConfigSupport();
        IdpAuthnAdapterInstance adapterInstance = idpAdapterMgmtConfigSupport.parseXml(xml, className);
        this.checkClassName(className, IdpAuthenticationAdapter.class);
        if (adapterInstance != null) {
            adapterInstance.setId(instanceId);
            adapterInstance.setParentId(parentId);
            if (this.getIdpAuthnAdapterInstance(instanceId) != null && !allowUpdate) {
                throw new ConfigurationException("The adapter instance with id=" + instanceId + " already exists. [allowUpdate=false]");
            }
            this.idpMgmtSupport.savePluginInstance(adapterInstance);
            ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ADAPTERS_UPDATED);
            this.log.info((Object)("Adapter instance " + instanceId + " is imported successfully."));
        }
    }

    @Override
    public String exportSpAdapterConfiguration(String instanceId) {
        String xml = null;
        AuthnAdapterInstance instance = this.getSpAuthnAdapterInstance(instanceId);
        if (instance != null) {
            AdapterMgmtConfigSupport support = new AdapterMgmtConfigSupport();
            xml = support.toXml(instance);
        }
        return xml;
    }

    @Override
    public void importSpAdapterConfiguration(String instanceId, String className, String xml, String parentId, boolean allowUpdate) throws XmlException, ConfigurationException {
        AdapterMgmtConfigSupport adapterMgmtConfigSupport = new AdapterMgmtConfigSupport();
        AuthnAdapterInstance adapterInstance = adapterMgmtConfigSupport.parseXml(xml, className);
        this.checkClassName(className, SpAuthenticationAdapter.class);
        if (adapterInstance != null) {
            adapterInstance.setId(instanceId);
            adapterInstance.setParentId(parentId);
            if (this.getSpAuthnAdapterInstance(instanceId) != null && !allowUpdate) {
                throw new ConfigurationException("The adapter instance with id=" + instanceId + " already exists. [allowUpdate=false]");
            }
            this.spMgmtSupport.savePluginInstance(adapterInstance);
            ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ADAPTERS_UPDATED);
            this.log.info((Object)("Adapter instance " + instanceId + " is imported successfully."));
        }
    }

    @Override
    public void loadAdapterConfigurations() {
        this.loadIdpAdapterConfigurations();
        this.loadSpAdapterConfigurations();
    }

    @Override
    public void loadIdpAdapterConfigurations() {
        this.idpMgmtSupport.loadConfigurations();
    }

    @Override
    public void loadSpAdapterConfigurations() {
        this.spMgmtSupport.loadConfigurations();
    }

    private void checkClassName(String className, Class interfaceClass) throws ConfigurationException {
        if (new PluginSupport().createInstance(className, interfaceClass) == null) {
            throw new ConfigurationException("Could not load class: \"" + className + "\". Is the adapter JAR deployed or does  it implement " + interfaceClass.getCanonicalName() + " ?");
        }
    }

    @Override
    public boolean isKerberosRealmInUse(String kerberosRealmName) {
        for (IdpAuthnAdapterInstance instance : this.getIdpAuthnAdapterInstances()) {
            GuiConfigDescriptor guiConfigDescriptor = instance.getDescriptor().getGuiConfigDescriptorBuilder().buildNewGuiDescriptor();
            ArrayList adapterGuiFields = new ArrayList();
            adapterGuiFields.addAll(guiConfigDescriptor.getFields());
            adapterGuiFields.addAll(guiConfigDescriptor.getAdvancedFields());
            ArrayList<FieldDescriptor> adapterKerberosRealms = new ArrayList<FieldDescriptor>();
            for (FieldDescriptor field : adapterGuiFields) {
                if (!(field instanceof KerberosRealmFieldDescriptor)) continue;
                adapterKerberosRealms.add(field);
            }
            ArrayList configurationList = new ArrayList();
            configurationList.addAll(instance.getConfiguration().getFields());
            configurationList.addAll(instance.getConfiguration().getAdvancedFields().getFields());
            for (FieldDescriptor kerberosRealmGuiField : adapterKerberosRealms) {
                for (Field field : configurationList) {
                    String kerberosRealmGuiFieldName = kerberosRealmGuiField.getName();
                    String configurationFieldName = field.getName();
                    String configurationFieldValue = field.getValue();
                    if (kerberosRealmGuiFieldName == null || !kerberosRealmGuiFieldName.equals(configurationFieldName) || configurationFieldValue == null || !configurationFieldValue.equals(kerberosRealmName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public IdpAuthenticationAdapter getIdpAuthnAdapterWithConnectionOverride(String instanceId, String connectionId) {
        ConfigurablePlugin plugin = this.idpMgmtSupport.getPluginForConnection(instanceId, connectionId);
        return (IdpAuthenticationAdapter)plugin;
    }

    @Override
    public IdpAuthenticationAdapter getIdpAuthnAdapter(AuthnSourceKey authnSourceKey) {
        if (authnSourceKey instanceof AdapterAuthnSourceKey) {
            AdapterAuthnSourceKey adapterAuthnSourceKey = (AdapterAuthnSourceKey)authnSourceKey;
            return this.getIdpAuthnAdapterWithConnectionOverride(adapterAuthnSourceKey.getId(), adapterAuthnSourceKey.getConnectionId());
        }
        return null;
    }

    @Override
    public IdpAuthnAdapterInstance getIdpAuthnAdapterInstanceWithConnectionOverride(String instanceId, String connectionId) {
        return (IdpAuthnAdapterInstance)this.idpMgmtSupport.getPluginInstanceForConnection(instanceId, connectionId);
    }

    @Override
    public boolean idpAdapterHasConnectionBasedOverride(String instanceId, String connectionId) {
        return this.idpMgmtSupport.pluginHasConnectionBasedOverride(instanceId, connectionId);
    }

    @Override
    public AuthnAdapterInstance getSpAuthnAdapterInstanceWithConnectionOverride(String instanceId, String connectionId) {
        return (AuthnAdapterInstance)this.spMgmtSupport.getPluginInstanceForConnection(instanceId, connectionId);
    }

    @Override
    public List<IdpAuthnAdapterInstance> getIdpCBPOInstances(String instanceId) {
        return this.idpMgmtSupport.getCBPOInstances(instanceId);
    }

    @Override
    public List<AuthnAdapterInstance> getSpCBPOInstances(String instanceId) {
        return this.spMgmtSupport.getCBPOInstances(instanceId);
    }

    @Override
    public <T> Collection<T> getIdpAdaptersOfType(Class<T> type) {
        return this.idpMgmtSupport.getPluginsOfType(type);
    }

    @Override
    public <T> Collection<T> getSpAdaptersOfType(Class<T> type) {
        return this.spMgmtSupport.getPluginsOfType(type);
    }
}

