/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.sdk.DescribablePlugin;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.impl.PluginMgmtConfigSupport;
import org.sourceid.saml20.domain.mgmt.impl.PluginSupport;
import org.sourceid.saml20.xmlbinding.adapterconf.AdapterConfigurationDocument;
import org.sourceid.saml20.xmlbinding.adapterconf.AdapterConfigurationType;
import org.sourceid.saml20.xmlbinding.adapterconf.ConfigType;

public class AdapterMgmtConfigSupport
extends PluginMgmtConfigSupport {
    static final String ADAPTER_CONFIG_SUB_DIR = "adapter-config";

    public AdapterMgmtConfigSupport() {
        super(ADAPTER_CONFIG_SUB_DIR);
    }

    @Override
    ConfigType constructConfigType(XmlObject document, ConfigurablePluginInstance pluginInstance) {
        AdapterConfigurationDocument adapterConfigDoc = (AdapterConfigurationDocument)document;
        AdapterConfigurationType adapterConfigurationType = adapterConfigDoc.getAdapterConfiguration();
        return this.constructConfigType((ConfigType)adapterConfigurationType, pluginInstance);
    }

    @Override
    ConfigType constructConfigType(ConfigType configType, ConfigurablePluginInstance pluginInstance) {
        if (configType instanceof AdapterConfigurationType && pluginInstance instanceof AuthnAdapterInstance) {
            AdapterConfigurationType adapterConfigType = (AdapterConfigurationType)configType;
            AuthnAdapterInstance authnAdapterInstance = (AuthnAdapterInstance)pluginInstance;
            boolean isInheritTargetApplicationInfo = adapterConfigType.getIsInheritTargetApplicationInfo();
            authnAdapterInstance.setInheritingTargetApplicationInfo(isInheritTargetApplicationInfo);
            if (!isInheritTargetApplicationInfo) {
                URL applicationIconUrl;
                authnAdapterInstance.setApplicationName(adapterConfigType.getApplicationName());
                try {
                    applicationIconUrl = new URL(adapterConfigType.getApplicationIcon());
                }
                catch (Exception e) {
                    applicationIconUrl = null;
                }
                authnAdapterInstance.setApplicationIconUrl(applicationIconUrl);
            }
        }
        return configType;
    }

    @Override
    public void saveConf(ConfigurablePluginInstance pluginInstance) {
        this.saveConf((AuthnAdapterInstance)pluginInstance);
    }

    public void saveConf(AuthnAdapterInstance authnAdapterInstance) {
        AdapterConfigurationDocument adapterConfigDoc = AdapterConfigurationDocument.Factory.newInstance();
        AdapterConfigurationType adapterConfigType = adapterConfigDoc.addNewAdapterConfiguration();
        this.populateAdapterConfigType(adapterConfigType, authnAdapterInstance);
        this.saveConf(authnAdapterInstance, (ConfigType)adapterConfigType, (XmlObject)adapterConfigDoc);
    }

    private void populateAdapterConfigType(AdapterConfigurationType adapterConfigurationType, AuthnAdapterInstance instance) {
        boolean inheritingTargetApplicationInfo = instance.isInheritingTargetApplicationInfo();
        adapterConfigurationType.setIsInheritTargetApplicationInfo(inheritingTargetApplicationInfo);
        if (!inheritingTargetApplicationInfo) {
            if (StringUtils.isNotBlank((String)instance.getApplicationName())) {
                adapterConfigurationType.setApplicationName(instance.getApplicationName());
            }
            if (instance.getApplicationIconUrl() != null) {
                adapterConfigurationType.setApplicationIcon(instance.getApplicationIconUrl().toExternalForm());
            }
        }
    }

    public String toXml(AuthnAdapterInstance authnAdapterInstance) {
        String xml = "";
        if (authnAdapterInstance != null) {
            AdapterConfigurationDocument adapterConfigDoc = AdapterConfigurationDocument.Factory.newInstance();
            AdapterConfigurationType adapterConfigType = adapterConfigDoc.addNewAdapterConfiguration();
            this.populateAdapterConfigType(adapterConfigType, authnAdapterInstance);
            super.fillInDoc(authnAdapterInstance, (ConfigType)adapterConfigType);
            XmlOptions opts = XmlBeansUtil.getXmlOptions();
            opts.setSavePrettyPrint();
            xml = adapterConfigDoc.xmlText(opts);
        }
        return xml;
    }

    public AuthnAdapterInstance parseXml(String xml, String className) throws XmlException {
        AuthnAdapterInstance adapterInstance = null;
        if (xml != null) {
            ByteArrayInputStream inStream;
            adapterInstance = new AuthnAdapterInstance();
            PluginSupport pluginSupport = new PluginSupport();
            DescribablePlugin pluginImpl = pluginSupport.createInstance(className, DescribablePlugin.class);
            if (pluginImpl != null) {
                adapterInstance.setDescriptor(pluginImpl.getPluginDescriptor());
            }
            try {
                inStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new XmlException((Throwable)e);
            }
            XmlObject document = this.xmlLoader.load(inStream);
            ConfigType configType = this.constructConfigType(document, (ConfigurablePluginInstance)adapterInstance);
            this.loadConf(adapterInstance, configType);
        }
        return adapterInstance;
    }
}

