/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.sourceid.oauth20.validate.admin.auth.JwtAdminApiAuthValidator;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.BasePropsAdminUserManager;
import org.sourceid.saml20.domain.mgmt.impl.JwtIssuer;
import org.sourceid.saml20.domain.util.AdminAuthUtil;
import org.sourceid.saml20.util.SystemUtil;

public class AdminUserJwtManagerImpl
extends BasePropsAdminUserManager {
    private final Map<String, JwtIssuer> issuersMap = new HashMap<String, JwtIssuer>();
    private final Map<String, Set<String>> roleMap = new HashMap<String, Set<String>>();
    private static final String ADMIN_USER_JWT_FILE = "jwt.properties.file";
    private static final Log log = LogFactory.getLog(AdminUserJwtManagerImpl.class);

    public AdminUserJwtManagerImpl() {
        this.init();
    }

    @Override
    public AdministrativeUser authenticate(String username, String password, HttpServletRequest request) throws AdminUserException {
        log.error((Object)"Unsupported authenticate operation for local JWT. Username and password cannot be accepted as 'LOCAL_JWT' is the configured API authentication method.");
        throw new AdminUserException(AdminUserException.Code.USER);
    }

    @Override
    public AdministrativeUser authenticate(HttpServletRequest request) throws AdminUserException {
        log.error((Object)"Unsupported authenticate operation for local JWT. Username and password cannot be accepted as 'LOCAL_JWT' is the configured API authentication method.");
        throw new AdminUserException(AdminUserException.Code.USER);
    }

    @Override
    protected String getBasePropertiesFileName() {
        return ADMIN_USER_JWT_FILE;
    }

    @Override
    protected String getRolePropertyName(String role) {
        return String.join((CharSequence)".", Arrays.asList("role", role));
    }

    @Override
    protected void loadProperties(Properties properties) {
        try {
            ArrayList issuerIds = new ArrayList();
            AdminUserJwtManagerImpl.splitAndNormalize(AdminAuthUtil.getProperty(properties, "issuerIds", true, "Issuers"), ',', issuerIds, false);
            ArrayList<JwtIssuer> issuers = new ArrayList<JwtIssuer>();
            for (String issuerId : issuerIds) {
                String issuer2 = AdminAuthUtil.getProperty(properties, issuerId + ".issuer", false, "Issuer");
                String issuerAudience = AdminAuthUtil.getProperty(properties, issuerId + ".aud", false, "Audience");
                String issuerJwkUri = AdminAuthUtil.getProperty(properties, issuerId + ".jwks.endpoint", true, "JWKS endpoint");
                HashSet<String> scopes = new HashSet<String>();
                AdminUserJwtManagerImpl.splitAndNormalize(AdminAuthUtil.getProperty(properties, issuerId + ".required.scopes", false, "Scopes"), ' ', scopes, false);
                String usernameAttribute = AdminAuthUtil.getProperty(properties, issuerId + ".username.attribute.name", true, "Username Attribute Name");
                String roleSearchAttribute = AdminAuthUtil.getProperty(properties, issuerId + ".role.attribute.name", true, "Attribute Name for determining admin roles");
                issuers.add(new JwtIssuer(issuerId, issuer2, issuerAudience, issuerJwkUri, scopes, usernameAttribute, roleSearchAttribute));
            }
            this.roleMap.putAll(AdminAuthUtil.getRoleValues(properties));
            issuers.forEach(arg_0 -> ((Log)log).info(arg_0));
            JwtAdminApiAuthValidator validator = new JwtAdminApiAuthValidator(issuers);
            if (!validator.validate()) {
                String errorMsg = "Invalid configuration found in " + System.getProperty(this.getBasePropertiesFileName()) + ".";
                SystemUtil.hardShutdown(errorMsg);
            }
            issuers.forEach(issuer -> this.issuersMap.put(issuer.getIssuer(), (JwtIssuer)issuer));
        }
        catch (RuntimeException e) {
            String errorMsg = "Invalid configuration found in " + System.getProperty(this.getBasePropertiesFileName()) + ".";
            log.debug((Object)errorMsg, (Throwable)e);
            SystemUtil.hardShutdown(errorMsg);
        }
    }

    @Override
    public Map<String, Set<String>> getRoleMap() {
        return this.roleMap;
    }

    @Override
    public JwtIssuer getJwtIssuer(String accessToken) {
        try {
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build();
            JwtClaims jwtClaims = jwtConsumer.processToClaims(accessToken);
            if (jwtClaims.hasClaim("iss")) {
                String issuer = jwtClaims.getIssuer();
                if (this.issuersMap.containsKey(issuer)) {
                    return new JwtIssuer(this.issuersMap.get(jwtClaims.getIssuer()));
                }
                log.debug((Object)("Unknown JWT issuer: " + issuer + ". Unable to verify JWT."));
                return null;
            }
            log.debug((Object)"JWT does not contain issuer claim.");
            return null;
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            log.debug((Object)"Unable to process JWT claims", e);
            return null;
        }
    }
}

