/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.crypto.X509ClientCertExtractor;
import com.pingidentity.crypto.X509ClientCertExtractorFactory;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.BasePropsAdminUserManager;

public class AdminUserManagerCertImpl
extends BasePropsAdminUserManager {
    private static final String ROOTCA_ISSUER = "rootca.issuer.";
    private static final String USERNAME_LAST_VALUE = "username.last.value";
    private static final String USERNAME_DROP_EMAIL_DOMAIN = "username.drop.email.domain";
    private static final String CLIENT_CERTIFICATE_HEADER_NAME = "client.certificate.header.name";
    private static final String CLIENT_CERTIFICATE_CHAIN_HEADER_NAME = "client.certificateChain.header.name";
    private static final String CLIENT_CERT_ENCODING_FORMAT = "client.certificate.header.encoding";
    private static final Log _log = LogFactory.getLog(AdminUserManagerCertImpl.class);
    private static final String DN_FORMAT = "RFC2253";
    protected static final String ADMIN_USER_CERT_PROPERTY_FILE = "cert.properties.file";
    private static final String TYPE_EMAIL_ADDRESS = "EMAILADDRESS";
    private final Set<String> _rootCaIssuers = new HashSet<String>();
    private final Map<String, List<String>> _rolesSubjects = new HashMap<String, List<String>>();
    private boolean _usernameLastValue = false;
    private boolean _usernameDropEmailDomain = false;
    private String _clientCertificateHeaderName;
    private String _clientCertificateChainHeaderName;
    private LocalSettings.ClientCertEncodingFormat _clientCertEncodingFormat = LocalSettings.ClientCertEncodingFormat.APACHE_MOD_SSL;

    public AdminUserManagerCertImpl() {
        this.init();
    }

    @Override
    public AdministrativeUser authenticate(HttpServletRequest request) throws AdminUserException {
        if (StringUtils.isNotBlank((CharSequence)this._clientCertificateHeaderName) || StringUtils.isNotBlank((CharSequence)this._clientCertificateChainHeaderName)) {
            X509ClientCertExtractor extractor = X509ClientCertExtractorFactory.newInstance(this._clientCertEncodingFormat, this._clientCertificateHeaderName, this._clientCertificateChainHeaderName);
            X509Certificate[] certs = extractor.extractClientCert(request);
            return this.authenticate(certs);
        }
        return this.authenticate((X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate"));
    }

    protected AdministrativeUser authenticate(X509Certificate[] clientCerts) throws AdminUserException {
        if (clientCerts == null || clientCerts.length == 0) {
            _log.error((Object)"No certificate found!");
            throw new AdminUserException(AdminUserException.Code.CERT_NOT_FOUND);
        }
        if (!this.validateRootCa(clientCerts)) {
            throw new AdminUserException(AdminUserException.Code.CERT_NOT_TRUSTED);
        }
        X509Certificate clientCert = clientCerts[0];
        X500Principal subjectX500Principal = clientCert.getSubjectX500Principal();
        String subjectDn = subjectX500Principal.getName(DN_FORMAT);
        if (subjectDn.isEmpty()) {
            _log.error((Object)"Invalid certificate, no Subject DN!");
            throw new AdminUserException(AdminUserException.Code.CERT_INVALID);
        }
        AdministrativeUser result = new AdministrativeUser();
        result.setUserName(this.extractUsername(subjectX500Principal));
        result.setPhoneNumber("");
        result.setEmailAddress(AdminUserManagerCertImpl.extractEmail(subjectX500Principal));
        result.setDepartment("");
        result.setDescription("");
        result.setActive(true);
        result.setChangeRequired(false);
        result.setAdmin(this._rolesSubjects.get("admin").contains(subjectDn));
        result.setAdminManager(this._rolesSubjects.get("userAdmin").contains(subjectDn));
        result.setCryptoManager(this._rolesSubjects.get("cryptoManager").contains(subjectDn));
        result.setExpressionAdmin(this._rolesSubjects.get("expressionAdmin").contains(subjectDn));
        result.setDataCollectionAdmin(this._rolesSubjects.get("dataCollectionAdmin").contains(subjectDn));
        result.setAuditor(this._rolesSubjects.get("auditor").contains(subjectDn));
        if (!(result.getAdmin() || result.getAdminManager() || result.getCryptoManager() || result.getAuditor())) {
            _log.debug((Object)("No PingFederate roles mapped for user: " + subjectDn));
        }
        return result;
    }

    @Override
    protected String getBasePropertiesFileName() {
        return ADMIN_USER_CERT_PROPERTY_FILE;
    }

    @Override
    protected String getRolePropertyName(String role) {
        return String.join((CharSequence)".", Arrays.asList("role", role, "subject"));
    }

    @Override
    protected void loadProperties(Properties props) {
        for (String role : PF_ROLES) {
            this._rolesSubjects.put(role, this.loadMultiValueProp(props, "role." + role + ".subject."));
        }
        this._rootCaIssuers.addAll(this.loadMultiValueProp(props, ROOTCA_ISSUER));
        this._usernameLastValue = Boolean.parseBoolean(props.getProperty(USERNAME_LAST_VALUE, "false"));
        this._usernameDropEmailDomain = Boolean.parseBoolean(props.getProperty(USERNAME_DROP_EMAIL_DOMAIN, "false"));
        this._clientCertificateHeaderName = props.getProperty(CLIENT_CERTIFICATE_HEADER_NAME);
        this._clientCertificateChainHeaderName = props.getProperty(CLIENT_CERTIFICATE_CHAIN_HEADER_NAME);
        String encodingFormat = props.getProperty(CLIENT_CERT_ENCODING_FORMAT, LocalSettings.ClientCertEncodingFormat.APACHE_MOD_SSL.toString());
        this._clientCertEncodingFormat = LocalSettings.ClientCertEncodingFormat.valueOf(encodingFormat);
    }

    @Override
    protected String normalizeId(String principal) {
        try {
            X500Principal principalObj = new X500Principal(principal);
            return principalObj.getName(DN_FORMAT);
        }
        catch (IllegalArgumentException e) {
            _log.error((Object)("Invalid principal, cannot be normalized: " + principal), (Throwable)e);
            return principal;
        }
    }

    private boolean validateRootCa(X509Certificate[] clientCerts) throws AdminUserException {
        X509Certificate lastClientCert = clientCerts[clientCerts.length - 1];
        X500Principal issuerX500Principal = lastClientCert.getIssuerX500Principal();
        if (issuerX500Principal == null) {
            _log.error((Object)"Invalid certificate, no issuer!");
            throw new AdminUserException(AdminUserException.Code.CERT_INVALID);
        }
        String issuer = issuerX500Principal.getName(DN_FORMAT);
        if (issuer == null || issuer.isEmpty()) {
            _log.error((Object)"Invalid certificate, no issuer!");
            throw new AdminUserException(AdminUserException.Code.CERT_INVALID);
        }
        if (this._rootCaIssuers.contains(issuer)) {
            _log.info((Object)("Issuer DN: " + issuerX500Principal));
            return true;
        }
        _log.warn((Object)("Issuer not trusted: " + issuerX500Principal));
        return false;
    }

    private static String extractEmail(X500Principal subjectX500Principal) {
        String subjectDn = subjectX500Principal.toString();
        try {
            LdapName dn = new LdapName(subjectDn);
            Rdn last = dn.getRdn(dn.size() - 1);
            if (TYPE_EMAIL_ADDRESS.equals(last.getType())) {
                return last.getValue().toString();
            }
        }
        catch (InvalidNameException e) {
            _log.error((Object)("Cannot parse subject DN: " + subjectDn), (Throwable)e);
        }
        return "";
    }

    private String extractUsername(X500Principal subjectX500Principal) {
        String subjectDn = subjectX500Principal.toString();
        _log.info((Object)("Subject DN: " + subjectDn));
        if (this._usernameLastValue) {
            try {
                LdapName dn = new LdapName(subjectDn);
                Rdn last = dn.getRdn(dn.size() - 1);
                Object value = last.getValue();
                String username = null;
                if (value instanceof String) {
                    username = value.toString();
                } else if (value instanceof byte[]) {
                    username = new String((byte[])value, StandardCharsets.UTF_8);
                } else {
                    _log.error((Object)("Cannot extract username, unknow value type: " + value.toString()));
                }
                if (username != null) {
                    if (this._usernameDropEmailDomain && username.indexOf(64) != -1) {
                        _log.debug((Object)"Dropping domain part of email like username.");
                        username = username.substring(0, username.indexOf(64));
                    }
                    _log.info((Object)("Username: " + username));
                    return username;
                }
            }
            catch (InvalidNameException e) {
                _log.error((Object)("Cannot parse subject DN: " + subjectDn), (Throwable)e);
            }
        }
        return subjectDn;
    }

    @Override
    public AdministrativeUser authenticate(String username, String password, HttpServletRequest request) throws AdminUserException {
        throw new UnsupportedOperationException();
    }
}

