/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.LockingService;
import com.pingidentity.config.xml.adminusers.AdministrativeUsers;
import com.pingidentity.config.xml.adminusers.AdministrativeUsersDocument;
import com.pingidentity.config.xml.adminusers.User;
import com.pingidentity.util.InitialSetupConfigStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.ConfigManagerBase;

public class AdminUserManagerImpl
extends ConfigManagerBase
implements AdminUserManager {
    private static final Log log = LogFactory.getLog(AdminUserManagerImpl.class);
    static final String ADMIN_USER_XML_FILE_NAME = "pingfederate-admin-user.xml";
    private final ConfigStore config = ConfigStoreFarm.getConfig(AdminUserManager.class);
    private static final String LOCKOUT_PERIOD = "LockoutPeriod";
    private final LockingService accountLockingService = MgmtFactory.getAccountLockingService().getInstance(this.getClass().getSimpleName());
    private static final AdminUserManagerImpl instance = new AdminUserManagerImpl();
    private final Map<String, AdministrativeUser> administrativeUsers = new CaseInsensitiveMap(new HashMap());

    private AdminUserManagerImpl() {
        this.reload();
    }

    public static AdminUserManagerImpl getInstance() {
        return instance;
    }

    @Override
    public synchronized void reload() {
        this.loadUsers();
    }

    @Override
    public synchronized Collection<AdministrativeUser> getUsers() {
        return this.administrativeUsers.values().stream().map(AdministrativeUser::getClone).collect(Collectors.toList());
    }

    @Override
    public synchronized AdministrativeUser getUser(String userName) {
        AdministrativeUser existingUser = this.administrativeUsers.get(userName);
        AdministrativeUser user = null;
        if (existingUser != null) {
            user = existingUser.getClone();
            user.setLocalAccount(true);
        }
        return user;
    }

    private synchronized void loadUsers() {
        block3: {
            this.administrativeUsers.clear();
            try {
                User[] users;
                AdministrativeUsersDocument doc = this.getDoc();
                for (User user : users = doc.getAdministrativeUsers().getUserArray()) {
                    AdministrativeUser adminUser = new AdministrativeUser();
                    String userName = user.getUserName();
                    adminUser.setUserName(userName);
                    adminUser.setActive(user.getActive());
                    adminUser.setSalt(user.getSalt());
                    adminUser.setHash(user.getHash());
                    adminUser.setPhoneNumber(user.getPhoneNumber());
                    adminUser.setEmailAddress(user.getEmailAddress());
                    adminUser.setDepartment(user.getDepartment());
                    adminUser.setDescription(user.getDescription());
                    adminUser.setAdminManager(user.getAdminManager());
                    adminUser.setAdmin(user.getAdmin());
                    adminUser.setCryptoManager(user.getCryptoManager());
                    adminUser.setExpressionAdmin(user.getExpressionManager());
                    adminUser.setDataCollectionAdmin(user.getDataCollectionAdmin());
                    adminUser.setAuditor(user.getAuditor());
                    adminUser.setActive(user.getActive());
                    adminUser.setChangeRequired(user.getPasswordChangeRequired());
                    adminUser.setLocalAccount(true);
                    this.administrativeUsers.put(userName, adminUser);
                }
            }
            catch (ConfigurationException ex) {
                InitialSetupConfigStore configStore = new InitialSetupConfigStore();
                if (!configStore.isInitialSetupDone()) break block3;
                AdminAuditLogger.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.EVENT, "User store lost");
                log.debug((Object)("Unable to load Administrative Users. " + ex.getMessage()));
                AdministrativeUser administrativeUser = new AdministrativeUser();
                administrativeUser.setUserName("Administrator");
                administrativeUser.setPassword("2Federate");
                administrativeUser.setPhoneNumber("");
                administrativeUser.setEmailAddress("");
                administrativeUser.setDepartment("");
                administrativeUser.setDescription("");
                administrativeUser.setAdminManager(true);
                administrativeUser.setAdmin(true);
                administrativeUser.setCryptoManager(true);
                administrativeUser.setAuditor(false);
                administrativeUser.setExpressionAdmin(true);
                administrativeUser.setDataCollectionAdmin(true);
                administrativeUser.setActive(true);
                administrativeUser.setChangeRequired(true);
                administrativeUser.setLocalAccount(true);
                this.administrativeUsers.put(administrativeUser.getUserName(), administrativeUser);
            }
        }
    }

    @Override
    public synchronized void saveUsers(Collection<AdministrativeUser> usersToSave) {
        log.debug((Object)"Saving Admin Users...");
        AdministrativeUsersDocument doc = AdministrativeUsersDocument.Factory.newInstance();
        AdministrativeUsers users = doc.addNewAdministrativeUsers();
        for (AdministrativeUser adminUser : usersToSave) {
            User user = users.addNewUser();
            user.setUserName(adminUser.getUserName());
            user.setSalt(adminUser.getSalt());
            user.setHash(adminUser.getHash());
            user.setPhoneNumber(adminUser.getPhoneNumber());
            user.setEmailAddress(adminUser.getEmailAddress());
            user.setDepartment(adminUser.getDepartment());
            user.setDescription(adminUser.getDescription());
            user.setAdminManager(adminUser.getAdminManager());
            user.setAdmin(adminUser.getAdmin());
            user.setCryptoManager(adminUser.getCryptoManager());
            user.setAuditor(adminUser.getAuditor());
            user.setActive(adminUser.isActive());
            user.setExpressionManager(adminUser.isExpressionAdmin());
            user.setDataCollectionAdmin(adminUser.isDataCollectionAdmin());
            user.setPasswordChangeRequired(adminUser.getChangeRequired());
        }
        this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), ADMIN_USER_XML_FILE_NAME, (XmlObject)doc);
        this.reload();
    }

    private AdministrativeUsersDocument getDoc() {
        String dataDir = this.sysDirInfo.getDataDirectory();
        return (AdministrativeUsersDocument)this.xmlLoader.load(dataDir, ADMIN_USER_XML_FILE_NAME);
    }

    @Override
    public synchronized Collection<String> getListOfUserNames() {
        return new ArrayList<String>(this.administrativeUsers.keySet());
    }

    @Override
    public synchronized void changePassword(String userName, String newPassword, boolean changeRequired) {
        CaseInsensitiveMap users = new CaseInsensitiveMap(this.administrativeUsers);
        AdministrativeUser user = (AdministrativeUser)users.get(userName);
        user.setPassword(newPassword);
        user.setChangeRequired(changeRequired);
        users.put(user.getUserName(), user);
        this.saveUsers(users.values());
    }

    @Override
    public AdministrativeUser authenticate(String username, String password, HttpServletRequest request) throws AdminUserException {
        AdministrativeUser user = this.getUser(username);
        String userKey = AccountLockingService.getUserKey(request.getRemoteAddr(), username);
        if (this.accountLockingService.isLocked(userKey, AccountLockingService.getMaxConsecutiveFailures(), AdminUserManagerImpl.getLockoutPeriod())) {
            throw new AdminUserException(AdminUserException.Code.LOCKED);
        }
        if (user == null || !user.matches(password)) {
            this.accountLockingService.logFailedLogin(userKey);
            if (this.accountLockingService.isLocked(userKey, AccountLockingService.getMaxConsecutiveFailures(), AdminUserManagerImpl.getLockoutPeriod())) {
                throw new AdminUserException(AdminUserException.Code.LOCKED);
            }
            if (user == null) {
                throw new AdminUserException(AdminUserException.Code.USER);
            }
            throw new AdminUserException(AdminUserException.Code.PASSWORD);
        }
        this.accountLockingService.clearFailedLogins(userKey);
        return user;
    }

    @Override
    public AdministrativeUser authenticate(HttpServletRequest request) throws AdminUserException {
        return null;
    }

    @Override
    public boolean allowAddUser() {
        return true;
    }

    private static int getLockoutPeriod() {
        return ConfigStoreFarm.getConfig(AdminUserManagerImpl.class).getIntValue(LOCKOUT_PERIOD, 1);
    }

    @Override
    public Map<String, AdministrativeUser> getUsersMap() {
        return Collections.unmodifiableMap(this.administrativeUsers);
    }

    @Override
    public synchronized boolean removeUser(String username) {
        if (username == null) {
            return false;
        }
        AdministrativeUser userToDelete = this.getUser(username);
        if (userToDelete == null) {
            return false;
        }
        Collection<AdministrativeUser> existingUsers = this.getUsers();
        boolean exists = existingUsers.remove(userToDelete);
        if (exists) {
            this.saveUsers(existingUsers);
        }
        return exists;
    }

    @Override
    public synchronized boolean updateUser(AdministrativeUser user) {
        Collection<AdministrativeUser> existingUsers = this.getUsers();
        boolean exists = existingUsers.remove(user);
        if (exists) {
            existingUsers.add(user);
            this.saveUsers(existingUsers);
        }
        return exists;
    }

    @Override
    public synchronized void addUser(AdministrativeUser user) {
        Collection<AdministrativeUser> existingUsers = this.getUsers();
        existingUsers.add(user);
        this.saveUsers(existingUsers);
    }

    @Override
    public synchronized void updateConfiguration() {
        boolean isDcRoleUpdated;
        boolean isEaRoleUpdated = this.config.getBooleanValue("isEaRoleUpdated", false);
        if (!isEaRoleUpdated) {
            this.loadUsers();
            Collection<AdministrativeUser> users = this.getUsers();
            for (AdministrativeUser user : users) {
                if (!user.isAdmin()) continue;
                user.setExpressionAdmin(true);
                log.info((Object)("Updating the administrator '" + user.getUserName() + "' to have Expression Role enabled."));
            }
            this.saveUsers(users);
            this.config.setBooleanValue("isEaRoleUpdated", true);
        }
        if (!(isDcRoleUpdated = this.config.getBooleanValue("isDcRoleUpdated", false))) {
            this.loadUsers();
            Collection<AdministrativeUser> users = this.getUsers();
            for (AdministrativeUser user : users) {
                if (!user.isAdmin() || !user.isCryptoManager() || !user.isAdminManager()) continue;
                user.setDataCollectionAdmin(true);
                log.info((Object)("Updating the administrator '" + user.getUserName() + "' to have the Data Collection Role enabled."));
            }
            this.saveUsers(users);
            this.config.setBooleanValue("isDcRoleUpdated", true);
        }
    }
}

