/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.api.authn.internal.AuthnApiEnvironmentBase;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.internal.RequestContextParameterNames;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.mgmt.AuthnApiManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.state.PasswordResetStateSupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.servlet.HttpServletRespProxy;
import org.sourceid.websso.authn.AuthnApiCookielessUtils;
import org.sourceid.websso.authn.AuthnApiPolicyUtil;
import org.sourceid.websso.authn.AuthnPluginKey;
import org.sourceid.websso.authn.AuthnPolicyUtil;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.RenderPageException;

public class AuthnApiEnvironmentImpl
extends AuthnApiEnvironmentBase {
    private static final Log log = LogFactory.getLog(AuthnApiEnvironmentImpl.class);
    private static final Map<InternalAuthnApiSupport.AuthnPluginType, AuthnPluginKey.Type> authnPluginTypeMapping = new HashMap<InternalAuthnApiSupport.AuthnPluginType, AuthnPluginKey.Type>();

    public String getLocalizedMessage(HttpServletRequest request, String resourceBundleBaseName, String messageKey) {
        if (resourceBundleBaseName == null) {
            resourceBundleBaseName = "pingfederate-messages";
        }
        return LocaleUtil.getLocalizedString(request, resourceBundleBaseName, messageKey, new String[0]);
    }

    public String getLocalizedMessage(HttpServletRequest request, String resourceBundleBaseName, String messageKey, String[] params) {
        if (resourceBundleBaseName == null) {
            resourceBundleBaseName = "pingfederate-messages";
        }
        return LocaleUtil.getLocalizedString(request, resourceBundleBaseName, messageKey, params);
    }

    public boolean isDefaultAuthnAppEnabled() {
        AuthnApiManager mgr = MgmtFactory.getAuthnApiManager();
        return mgr.isApiEnabled() && mgr.getDefaultApplication() != null;
    }

    public void createFlowAndRedirectToDefaultAuthnApp(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams) throws IOException {
        AuthnApiApplication defaultApp = this.getDefaultApplication();
        this.doSaveStateParamsAndRedirect(req, resp, stateParams, defaultApp);
    }

    public void redirectToDefaultAuthnApp(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, String authnApiFlowId) throws IOException {
        this.doUpdateStateParamsAndRedirect(req, resp, this.getDefaultApplication(), authnApiFlowId, stateParams);
    }

    public void createFlowAndRedirectToAuthnApp(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, String authnApiAppId) throws IOException {
        AuthnApiApplication authnApiApp = this.getAuthnApiApplication(authnApiAppId);
        this.doSaveStateParamsAndRedirect(req, resp, stateParams, authnApiApp);
    }

    public void redirectToAuthnApp(HttpServletRequest req, HttpServletResponse resp, String authnApiAppId, String authnApiFlowId, Map<String, Object> stateParams) throws IOException {
        this.doUpdateStateParamsAndRedirect(req, resp, this.getAuthnApiApplication(authnApiAppId), authnApiFlowId, stateParams);
    }

    public String getAuthnApiAppId(Map<String, Object> stateParams) {
        AuthnApiApplication apiApplication = AuthnApiPolicyUtil.getDefault().getLastAuthnApiApplication(stateParams);
        return apiApplication == null ? null : apiApplication.getId();
    }

    public String getPluginTypeId(Map<String, Object> stateParams) {
        AuthnPluginKey currentPlugin = AuthnPolicyUtil.getDefault().getCurrentAuthnPlugin(null, stateParams);
        if (currentPlugin == null) {
            return null;
        }
        return AuthnApiPolicyUtil.getDefault().makePluginTypeId(currentPlugin);
    }

    public void setCurrentAuthnPlugin(HttpServletRequest request, Map<String, Object> stateParams, InternalAuthnApiSupport.AuthnPluginType pluginType, String pluginId) {
        AuthnPluginKey.Type authnPluginType = authnPluginTypeMapping.get(pluginType);
        if (authnPluginType == null) {
            throw new RuntimeException(pluginType.toString() + " is not a supported plugin type.");
        }
        AuthnPolicyUtil.getDefault().setCurrentAuthnPlugin(request, stateParams, new AuthnPluginKey(authnPluginType, pluginId));
    }

    public void saveLastAuthnApiApplication(Map<String, Object> stateParams, String authnAppId) {
        AuthnApiPolicyUtil.getDefault().saveLastAuthnApiApplication(stateParams, MgmtFactory.getAuthnApiManager().getApiApplication(authnAppId));
    }

    private AuthnApiManager getAuthnApiManager() {
        AuthnApiManager mgr = MgmtFactory.getAuthnApiManager();
        if (!mgr.isApiEnabled()) {
            throw new IllegalStateException("Authentication API not enabled");
        }
        return mgr;
    }

    private AuthnApiApplication getDefaultApplication() {
        AuthnApiApplication defaultApp = this.getAuthnApiManager().getDefaultApplication();
        if (defaultApp == null) {
            throw new IllegalStateException("Default authn API application is not defined");
        }
        return defaultApp;
    }

    private AuthnApiApplication getAuthnApiApplication(String appId) {
        AuthnApiApplication app = this.getAuthnApiManager().getApiApplication(appId);
        if (app == null) {
            throw new IllegalStateException("Authn API application '" + appId + "' is not found");
        }
        return app;
    }

    private void doRedirect(HttpServletResponse response, String flowId, AuthnApiApplication apiApplication) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirecting to authn API application '" + apiApplication.getId() + "'"));
        }
        AuthnApiPolicyUtil.getDefault().redirectAuthnApiApplication(response, flowId, apiApplication);
    }

    private void doSaveStateParamsAndRedirect(HttpServletRequest request, HttpServletResponse response, Map<String, Object> stateParams, AuthnApiApplication apiApplication) throws IOException {
        PasswordResetStateSupport stateSupport = new PasswordResetStateSupport(MetaDataFactory.getLocalMetaData());
        String resumePath = stateSupport.saveState(request, response, null, null, stateParams, null, true);
        this.doRedirect(response, stateSupport.getContextId(resumePath), apiApplication);
    }

    private void doUpdateStateParamsAndRedirect(HttpServletRequest request, HttpServletResponse response, AuthnApiApplication authnApp, String flowId, Map<String, Object> stateParams) throws IOException {
        StateSupport stateSupport = new StateSupport(MetaDataFactory.getLocalMetaData());
        String stateKey = stateSupport.buildStateKey(request, response, flowId);
        try {
            State state = StateMgmtFactory.retrieveAndRemoveState(stateKey, false, request, response);
            Map<String, Object> existingStateParams = state.getParameters();
            for (Map.Entry<String, Object> entry : stateParams.entrySet()) {
                existingStateParams.put(entry.getKey(), entry.getValue());
            }
            StateMgmtFactory.saveState(request, response, stateKey, state);
            this.doRedirect(response, flowId, authnApp);
        }
        catch (RenderPageException e) {
            throw new ProcessRuntimeException("Unable to retrieve state associated with flow id '" + flowId + "' and state key '" + stateKey + "'.");
        }
    }

    public boolean isIncludeRequestContext() {
        boolean requestContext = MgmtFactory.getAuthnApiManager().getSettings().isIncludeRequestContext();
        return requestContext;
    }

    public RequestContextParameterNames getRequestContextParameterNames() {
        return new RequestContextParameterNames(Parameters.CLIENT_ID, "PartnerEntityId", "APU.CurrentAuthnPluginId", "pf.TrackedHttpParams", "SpSessionAuthnAdapterId", "applicationName", "ui_locales", "applicationIcon", "extendedProperties");
    }

    public boolean supportsRedirectlessStateParam() {
        return true;
    }

    public boolean isRedirectlessApiFlow(Map<String, Object> stateParams) {
        return AuthnApiPolicyUtil.getDefault().isRedirectlessApiFlow(stateParams);
    }

    public Optional<String> getCookielessState(HttpServletRequest req, HttpServletResponse resp) {
        AuthnApiCookielessUtils authnApiCookielessUtils = AuthnApiCookielessUtils.newInstance();
        Map stateParams = InternalAuthnApiSupport.getDefault().getStateParams(req);
        if (stateParams == null) {
            return Optional.empty();
        }
        if (!authnApiCookielessUtils.isCookielessApiFlow(stateParams)) {
            return Optional.empty();
        }
        if (!(resp instanceof HttpServletRespProxy)) {
            return Optional.empty();
        }
        HttpServletRespProxy response = (HttpServletRespProxy)resp;
        HttpServletRespProxy.executePreCommitRunnable(response);
        HashMap<String, Cookie> responseCookies = new HashMap<String, Cookie>(HttpServletRespProxy.getLazyCookies(response));
        if (req.getCookies() != null) {
            Arrays.stream(req.getCookies()).forEach(cookie -> {
                if (!responseCookies.containsKey(cookie.getName())) {
                    response.addCookie((Cookie)cookie);
                }
            });
        }
        String state = authnApiCookielessUtils.generateState(req, response);
        return Optional.of(state);
    }

    static {
        authnPluginTypeMapping.put(InternalAuthnApiSupport.AuthnPluginType.IDP_ADAPTER, AuthnPluginKey.Type.IDP_ADAPTER);
        authnPluginTypeMapping.put(InternalAuthnApiSupport.AuthnPluginType.SELECTOR, AuthnPluginKey.Type.SELECTOR);
    }
}

