/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.impl.JaxbXmlLoader;
import com.pingidentity.pingcommons.crypto.IDGenerator;
import com.pingidentity.sdk.api.authn.internal.AuthnApiEnvironment;
import com.pingidentity.sdk.api.authn.internal.AuthnApiFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.CorsSettings;
import org.sourceid.oauth20.domain.CorsSettingsUtil;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.AuthnApiSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.AuthnApiManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AuthnApiEnvironmentImpl;
import org.xml.sax.SAXException;

public class AuthnApiManagerImpl
implements AuthnApiManager,
AutoReloadable {
    private static final String AUTHN_API_CONFIG_FILE = "authn-api-config.xml";
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.domain.mgmt.impl.AuthnApiManagerImpl");
    private Map<String, AuthnApiApplication> apiApplications = new HashMap<String, AuthnApiApplication>();
    private AuthnApiSettings apiSettings = new AuthnApiSettings();
    private CorsSettings corsSettings;
    private CorsSettings corsSettingsForAuthzEndpoint;
    private CorsSettings corsSettingsForUserAuthzEndpoint;
    private static final List<String> DEFAULT_URL_PATTERNS = Arrays.asList("/pf-ws/authn/flows(/*)?");
    private static final Log log = LogFactory.getLog(AuthnApiManagerImpl.class);

    public AuthnApiManagerImpl() {
        this.loadConfig();
    }

    @Override
    public synchronized void init() {
        AuthnApiFactory.setEnvironment((AuthnApiEnvironment)new AuthnApiEnvironmentImpl());
    }

    private synchronized void loadConfig() {
        File file = new File(this.getStorageFileName());
        if (file.exists()) {
            try {
                JaxbXmlLoader<AuthnApiConfig> loader = new JaxbXmlLoader<AuthnApiConfig>(AuthnApiConfig.class);
                AuthnApiConfig config = loader.load(MgmtFactory.getSysDirInfo().getDataDirectory(), AUTHN_API_CONFIG_FILE);
                this.apiSettings = config.getApiSettings();
                this.apiApplications.clear();
                for (AuthnApiApplication app : config.getApiApplications().getApplications()) {
                    this.apiApplications.put(app.getId(), app);
                }
            }
            catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException("Unexpected error deserializing config from file", e);
            }
        }
        this.updateCorsSettings();
    }

    @Override
    public synchronized AuthnApiSettings getSettings() {
        return new AuthnApiSettings(this.apiSettings);
    }

    @Override
    public synchronized void saveSettings(AuthnApiSettings settings) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.apiSettings = new AuthnApiSettings(settings);
            this.saveConfig();
            auditLoggerScope.log(AdminAuditLogger.Component.AUTHN_API_SETTINGS, AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public synchronized boolean isApiEnabled() {
        return this.apiSettings.isApiEnabled();
    }

    @Override
    public synchronized AuthnApiApplication getDefaultApplication() {
        if (this.apiSettings.getDefaultApplicationId() == null) {
            return null;
        }
        return this.getApiApplication(this.apiSettings.getDefaultApplicationId());
    }

    @Override
    public synchronized AuthnApiApplication getApiApplication(String id) {
        AuthnApiApplication app = this.apiApplications.get(id);
        if (app == null) {
            return null;
        }
        return new AuthnApiApplication(app);
    }

    @Override
    public synchronized void saveApiApplication(AuthnApiApplication app, boolean isUpdate) {
        this.checkIdIsSet(app);
        AuthnApiApplication copy = new AuthnApiApplication(app);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.apiApplications.put(copy.getId(), copy);
            this.saveConfig();
            auditLoggerScope.log(AdminAuditLogger.Component.AUTHN_APPLICATIONS, isUpdate ? AdminAuditLogger.Event.MODIFY : AdminAuditLogger.Event.CREATE);
        }
    }

    @Override
    public synchronized void saveAllApiApplications(Collection<AuthnApiApplication> apps) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.apiApplications.clear();
            for (AuthnApiApplication app : apps) {
                this.checkIdIsSet(app);
                AuthnApiApplication copy = new AuthnApiApplication(app);
                this.apiApplications.put(copy.getId(), copy);
            }
            this.saveConfig();
            auditLoggerScope.log(AdminAuditLogger.Component.AUTHN_APPLICATIONS, AdminAuditLogger.Event.MODIFY);
        }
    }

    @Override
    public synchronized Collection<AuthnApiApplication> getApiApplications() {
        return this.apiApplications.values().stream().map(app -> new AuthnApiApplication((AuthnApiApplication)app)).collect(Collectors.toList());
    }

    @Override
    public synchronized void deleteApiApplication(String id) {
        this.apiApplications.remove(id);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.saveConfig();
            auditLoggerScope.log(AdminAuditLogger.Component.AUTHN_APPLICATIONS, AdminAuditLogger.Event.DELETE);
        }
    }

    @Override
    public synchronized AuthnApiApplication newApiApplication() {
        AuthnApiApplication result = new AuthnApiApplication();
        result.setId(IDGenerator.rndAlphaNumeric((int)25));
        return result;
    }

    private void checkIdIsSet(AuthnApiApplication app) {
        if (app.getId() == null) {
            throw new IllegalStateException("Application ID must be initialized. Please call AuthnApiManager.newApiApplication() to create an instance with the ID initialized.");
        }
    }

    private void saveConfig() {
        AuthnApiConfig config = new AuthnApiConfig();
        config.setApiSettings(this.apiSettings);
        config.getApiApplications().setApplications(this.apiApplications.values());
        try {
            JaxbXmlLoader<AuthnApiConfig> loader = new JaxbXmlLoader<AuthnApiConfig>(AuthnApiConfig.class);
            loader.save(MgmtFactory.getSysDirInfo().getDataDirectory(), AUTHN_API_CONFIG_FILE, config);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unexpected error serializing config to file", e);
        }
        this.updateCorsSettings();
    }

    private String getStorageFileName() {
        String dataDirectory = MgmtFactory.getSysDirInfo().getDataDirectory();
        return dataDirectory + File.separator + AUTHN_API_CONFIG_FILE;
    }

    @Override
    public synchronized CorsSettings getCorsSettings() {
        return this.corsSettings;
    }

    @Override
    public synchronized CorsSettings getCorsSettingsForAuthzEndpoint() {
        return this.corsSettingsForAuthzEndpoint;
    }

    @Override
    public synchronized CorsSettings getCorsSettingsForUserAuthzEndpoint() {
        return this.corsSettingsForUserAuthzEndpoint;
    }

    @Override
    public boolean isIncludeUserInfoInResponses() {
        return this.configStore.getBooleanValue("IncludeUserInfoInResponses", true);
    }

    private List<String> getAllowedOrigins(Predicate<AuthnApiApplication> filter) {
        if (!this.apiSettings.isApiEnabled()) {
            return Collections.emptyList();
        }
        return this.getApiApplications().stream().filter(filter).map(AuthnApiApplication::getAllAllowedOrigins).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void updateCorsSettings() {
        this.corsSettings = this.makeDefaultCorsSettings();
        this.corsSettingsForUserAuthzEndpoint = this.makeDefaultCorsSettings();
        this.corsSettingsForUserAuthzEndpoint.setUrlPatterns(Arrays.asList("/as/user_authz.oauth2"));
        this.corsSettingsForAuthzEndpoint = !this.apiSettings.isRestrictAccessToRedirectlessMode() ? this.makeDefaultCorsSettings() : new CorsSettingsUtil().getCorsSettings("authn-api-cors-configuration", DEFAULT_URL_PATTERNS, this.getAllowedOrigins(app -> app.getClientIdForRedirectlessMode() != null));
        this.corsSettingsForAuthzEndpoint.setUrlPatterns(Arrays.asList("/as/authorization.oauth2"));
    }

    private CorsSettings makeDefaultCorsSettings() {
        return new CorsSettingsUtil().getCorsSettings("authn-api-cors-configuration", DEFAULT_URL_PATTERNS, this.getAllowedOrigins(app -> true));
    }

    public static class ApiApplications {
        private Collection<AuthnApiApplication> applications = new ArrayList<AuthnApiApplication>();

        @XmlElement(name="application")
        public Collection<AuthnApiApplication> getApplications() {
            return this.applications;
        }

        public void setApplications(Collection<AuthnApiApplication> applications) {
            this.applications = applications;
        }
    }

    @XmlRootElement
    public static class AuthnApiConfig {
        private AuthnApiSettings apiSettings = new AuthnApiSettings();
        private ApiApplications apiApplications = new ApiApplications();

        public AuthnApiSettings getApiSettings() {
            return this.apiSettings;
        }

        public void setApiSettings(AuthnApiSettings settings) {
            this.apiSettings = settings;
        }

        public ApiApplications getApiApplications() {
            return this.apiApplications;
        }

        public void setApiApplications(ApiApplications applications) {
            this.apiApplications = applications;
        }
    }
}

