/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.ObfuscationException;
import com.pingidentity.common.util.ServiceInformation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.ldap.Rdn;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pingidentity.utils.EnvironmentVariableUtil;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserJwtManagerImpl;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public abstract class BasePropsAdminUserManager
implements AdminUserManager,
ServiceInformation {
    private static Log _log = LogFactory.getLog(BasePropsAdminUserManager.class);
    protected static final String ROLE_PREFIX = "role";
    protected static final String ROLE_MAP_SEGMENT = "map";
    protected static final String PROPERTY_NAME_DELIMINATOR = ".";
    public static final String ROLE_ADMIN = "admin";
    public static final String ROLE_CRYPTO = "cryptoManager";
    public static final String ROLE_AUDITOR = "auditor";
    public static final String ROLE_USERADMIN = "userAdmin";
    public static final String ROLE_EXPRESSIONADMIN = "expressionAdmin";
    public static final String ROLE_DATA_COLLECTION_ADMIN = "dataCollectionAdmin";
    protected static final String ISSUER_IDS = "issuerIds";
    protected static final String ISSUER = "issuer";
    protected static final String AUDIENCE = "aud";
    protected static final String JWKS_ENDPOINT = "jwks.endpoint";
    protected static final String REQUIRED_SCOPE = "required.scopes";
    protected static final String USERNAME_ATTRIBUTE_NAME = "username.attribute.name";
    protected static final String ROLE_ATTRIBUTE_NAME = "role.attribute.name";
    static final Set<String> PF_ROLES = new HashSet<String>();
    protected boolean _initialized = false;

    public String getServiceName() {
        return "admin-user-manager";
    }

    @Override
    public boolean allowAddUser() {
        return true;
    }

    @Override
    public void reload() {
    }

    @Override
    public Collection<AdministrativeUser> getUsers() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, AdministrativeUser> getUsersMap() {
        return Collections.emptyMap();
    }

    @Override
    public void changePassword(String userName, String newPassword, boolean changeRequired) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> getListOfUserNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AdministrativeUser getUser(String userName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void saveUsers(Collection<AdministrativeUser> users) {
        throw new UnsupportedOperationException();
    }

    protected void init() {
        if (this._initialized) {
            return;
        }
        String authPropFileName = System.getProperty(this.getBasePropertiesFileName());
        if (authPropFileName == null) {
            _log.error((Object)String.format("Property [%s] is not set, authentication disabled", this.getBasePropertiesFileName()));
            return;
        }
        File runPropFile = new File(System.getProperty("run.properties"));
        File authPropFile = new File(runPropFile.getParent(), authPropFileName);
        if (!authPropFile.exists()) {
            _log.error((Object)String.format("Property file [%s] is not found, authentication disabled", authPropFile.getAbsolutePath()));
            return;
        }
        _log.info((Object)("Console Authentication Config File: " + authPropFile.getAbsolutePath()));
        Properties props = new Properties();
        this.preloadPropertiesForEnvironmentVariables(props, authPropFileName, authPropFile);
        try (FileInputStream inputStream = new FileInputStream(authPropFile);
             InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
            EnvironmentVariableUtil.loadPropertyWithEnvVar((Properties)props, (Reader)reader, (String)authPropFileName);
        }
        catch (IOException e) {
            _log.error((Object)("Error loading properties from: " + authPropFile.getAbsolutePath()), (Throwable)e);
            return;
        }
        try {
            this.loadProperties(props);
        }
        catch (ObfuscationException e) {
            _log.error((Object)"Unable to load properties", (Throwable)e);
            return;
        }
        this._initialized = true;
    }

    private void preloadPropertiesForEnvironmentVariables(Properties propsToPreload, String authPropFileName, File authPropFile) {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(authPropFile);
             InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
            properties.load(reader);
            this.handlePrefixedIssuers(authPropFileName, properties, propsToPreload);
            this.handleIndexedRoles(authPropFileName, propsToPreload);
        }
        catch (IOException e) {
            _log.error((Object)("Error preloading properties from: " + authPropFile.getAbsolutePath()), (Throwable)e);
            return;
        }
    }

    private void handleIndexedRoles(String authPropFileName, Properties propsToPreload) {
        this.addIndexedRoleProperty(authPropFileName, ROLE_ADMIN, propsToPreload);
        this.addIndexedRoleProperty(authPropFileName, ROLE_CRYPTO, propsToPreload);
        this.addIndexedRoleProperty(authPropFileName, ROLE_AUDITOR, propsToPreload);
        this.addIndexedRoleProperty(authPropFileName, ROLE_USERADMIN, propsToPreload);
        this.addIndexedRoleProperty(authPropFileName, ROLE_EXPRESSIONADMIN, propsToPreload);
        this.addIndexedRoleProperty(authPropFileName, ROLE_DATA_COLLECTION_ADMIN, propsToPreload);
    }

    private void addIndexedRoleProperty(String authPropFileName, String role, Properties propsToPreload) {
        String environmentVariableKey;
        CharSequence[] variableNameSegmentsNoIndex;
        Map<String, String> envs = System.getenv();
        String environmentVariableKeyNoIndex = this.getEnvironmentVariableKey(envs, authPropFileName, (String[])(variableNameSegmentsNoIndex = this.getRolePropertyName(role).split("\\.")));
        if (environmentVariableKeyNoIndex != null) {
            propsToPreload.setProperty(String.join((CharSequence)PROPERTY_NAME_DELIMINATOR, variableNameSegmentsNoIndex), "");
        }
        int index = 1;
        do {
            CharSequence[] variableNameSegments;
            if ((environmentVariableKey = this.getEnvironmentVariableKey(envs, authPropFileName, (String[])(variableNameSegments = (String[])ArrayUtils.add((Object[])this.getRolePropertyName(role).split("\\."), (Object)String.valueOf(index))))) != null) {
                propsToPreload.setProperty(String.join((CharSequence)PROPERTY_NAME_DELIMINATOR, variableNameSegments), "");
            }
            ++index;
        } while (environmentVariableKey != null);
    }

    private String getEnvironmentVariableKey(Map<String, String> envs, String authPropFileName, String ... variableNameSegments) {
        String variableName = EnvironmentVariableUtil.getEnvVarName((String)authPropFileName, (String[])variableNameSegments);
        return envs.entrySet().stream().filter(entry -> variableName.equalsIgnoreCase((String)entry.getKey())).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    private void handlePrefixedIssuers(String authPropFileName, Properties properties, Properties propsToPreload) {
        String issuerIds;
        if (!(this instanceof AdminUserJwtManagerImpl)) {
            return;
        }
        _log.debug((Object)"Preloading properties for custom issuers");
        Map<String, String> envs = System.getenv();
        String environmentVariableKey = this.getEnvironmentVariableKey(envs, authPropFileName, ISSUER_IDS);
        if (environmentVariableKey != null) {
            _log.debug((Object)("IssuerId found in environment variable: " + environmentVariableKey));
            issuerIds = envs.get(environmentVariableKey);
        } else {
            _log.debug((Object)"Retrieving IssuerIds from JWT properties file");
            issuerIds = properties.getProperty(ISSUER_IDS);
        }
        if (issuerIds != null) {
            HashSet issuerIdsSet = new HashSet();
            BasePropsAdminUserManager.splitAndNormalize(issuerIds, ',', issuerIdsSet, false);
            for (String customIssuer : issuerIdsSet) {
                _log.debug((Object)("Preloading properties for custom issuer: " + customIssuer));
                this.addCustomIssuerPrefixProperty(customIssuer, propsToPreload);
            }
        }
    }

    private void addCustomIssuerPrefixProperty(String customIssuerId, Properties propsToPreload) {
        propsToPreload.setProperty(ISSUER_IDS, "");
        propsToPreload.setProperty(customIssuerId + ".issuer", "");
        propsToPreload.setProperty(customIssuerId + ".aud", "");
        propsToPreload.setProperty(customIssuerId + ".jwks.endpoint", "");
        propsToPreload.setProperty(customIssuerId + ".required.scopes", "");
        propsToPreload.setProperty(customIssuerId + ".username.attribute.name", "");
        propsToPreload.setProperty(customIssuerId + ".role.attribute.name", "");
    }

    protected abstract String getRolePropertyName(String var1);

    protected abstract String getBasePropertiesFileName();

    protected abstract void loadProperties(Properties var1);

    protected List<String> loadMultiValueProp(Properties props, String baseName) {
        String value;
        ArrayList<String> values = new ArrayList<String>();
        int idx = 0;
        while ((value = props.getProperty(baseName + ++idx)) != null) {
            if ((value = value.trim()).length() == 0) continue;
            values.add(this.normalizeId(value));
        }
        return values;
    }

    protected static boolean hasRole(Set<String> usernameRoles, Set<String> mappedRoles, String username, Set<String> externalRoles) {
        if (usernameRoles.contains(username)) {
            return true;
        }
        for (String externalRole : externalRoles) {
            for (String mappedRole : mappedRoles) {
                if (!externalRole.trim().equalsIgnoreCase(mappedRole.trim())) continue;
                return true;
            }
        }
        return false;
    }

    protected static Set<String> splitAndNormalize(String names) {
        HashSet<String> result = new HashSet<String>();
        BasePropsAdminUserManager.splitAndNormalize(names, ',', result, true);
        return result;
    }

    protected static void splitAndNormalize(String names, char separator, Collection result, boolean lowercase) {
        String[] parts;
        if (names == null) {
            return;
        }
        for (String s : parts = names.split("(?<!\\\\)" + separator)) {
            s = lowercase ? Rdn.unescapeValue(s.trim().toLowerCase()).toString() : Rdn.unescapeValue(s.trim()).toString();
            if (s.length() <= 0) continue;
            result.add(s);
        }
    }

    protected String normalizeId(String principal) {
        return principal;
    }

    static {
        PF_ROLES.add(ROLE_ADMIN);
        PF_ROLES.add(ROLE_CRYPTO);
        PF_ROLES.add(ROLE_AUDITOR);
        PF_ROLES.add(ROLE_USERADMIN);
        PF_ROLES.add(ROLE_EXPRESSIONADMIN);
        PF_ROLES.add(ROLE_DATA_COLLECTION_ADMIN);
    }
}

