/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.TokenEndpointAttributeContract;
import org.sourceid.saml20.domain.mgmt.impl.PluginMgmtConfigSupport;
import org.sourceid.saml20.xmlbinding.adapterconf.AccessTokenManagerConfigurationDocument;
import org.sourceid.saml20.xmlbinding.adapterconf.AccessTokenManagerConfigurationType;
import org.sourceid.saml20.xmlbinding.adapterconf.ConfigType;
import org.sourceid.saml20.xmlbinding.adapterconf.PluginConfigurationDocument;
import org.sourceid.saml20.xmlbinding.adapterconf.TokenEndpointAttributeHolderType;
import org.sourceid.saml20.xmlbinding.adapterconf.TokenEndpointContractAttributesType;

public class BearerAccessTokenMgmtConfigSupport
extends PluginMgmtConfigSupport {
    public BearerAccessTokenMgmtConfigSupport(String configSubDirectory) {
        super(configSubDirectory);
    }

    @Override
    void loadConf(ConfigurablePluginInstance pluginInstance, ConfigType configType) {
        super.loadConf(pluginInstance, configType);
        if (StringUtils.isBlank((String)pluginInstance.getName())) {
            pluginInstance.setName(pluginInstance.getDescriptor().getType());
        }
    }

    @Override
    ConfigType constructConfigType(XmlObject document, ConfigurablePluginInstance pluginInstance) {
        try {
            AccessTokenManagerConfigurationDocument atmConfigDoc = (AccessTokenManagerConfigurationDocument)document;
            AccessTokenManagerConfigurationType configType = atmConfigDoc.getAccessTokenManagerConfiguration();
            return this.constructConfigType((ConfigType)configType, pluginInstance);
        }
        catch (Exception e) {
            PluginConfigurationDocument pluginConfigDoc = (PluginConfigurationDocument)document;
            ConfigType configType = pluginConfigDoc.getPluginConfiguration();
            return this.constructConfigType(configType, pluginInstance);
        }
    }

    @Override
    public ConfigType constructConfigType(ConfigType configType, ConfigurablePluginInstance pluginInstance) {
        if (pluginInstance instanceof BearerAccessTokenMgmtPluginInstance && configType instanceof AccessTokenManagerConfigurationType) {
            BearerAccessTokenMgmtPluginInstance atmInstance = (BearerAccessTokenMgmtPluginInstance)pluginInstance;
            AccessTokenManagerConfigurationType atmConfigType = (AccessTokenManagerConfigurationType)configType;
            atmInstance.setInheritAccessControlSettings(atmConfigType.getInheritAccessControlSettings());
            atmInstance.setInheritSelectionSettings(atmConfigType.getInheritSelectionSettings());
            atmInstance.setInheritSessionValidationSettings(atmConfigType.getInheritSessionValidationSettings());
            atmInstance.setOwnRestrictClients(atmConfigType.getRestrictClients());
            atmInstance.setOwnAllowedClients(Arrays.asList(atmConfigType.getAllowedClientIdArray()));
            atmInstance.setOwnResourceUris(Arrays.asList(atmConfigType.getResourceUriArray()));
            atmInstance.setIncludeSessionIdentifier(atmConfigType.getIncludeSessionIdentifier());
            atmInstance.setCheckSessionValidationStatus(atmConfigType.getCheckValidAuthnSession());
            atmInstance.setCheckSessionRevocationStatus(atmConfigType.getCheckSessionRevocationStatus());
            atmInstance.setUpdateAuthSessionActivity(atmConfigType.getUpdateAuthnSessionActivity());
            atmInstance.setDefaultSubjectAttribute(atmConfigType.getDefaultSubjectAttribute());
            boolean isInheritingTokenEndpointAttrs = atmConfigType.getIsInheritTokenEndpointContractAttributes();
            atmInstance.setInheritTokenEndpointAttributeContract(isInheritingTokenEndpointAttrs);
            if (!isInheritingTokenEndpointAttrs && atmConfigType.getTokenEndpointContractAttributes() != null) {
                HashSet<String> attributes = new HashSet<String>();
                HashSet<String> multiValued = new HashSet<String>();
                HashMap<String, Set<String>> mappedScopes = new HashMap<String, Set<String>>();
                for (TokenEndpointAttributeHolderType tokenEndpointAttributeHolderType : atmConfigType.getTokenEndpointContractAttributes().getTokenEndpointAttributeArray()) {
                    HashSet<String> scopeSet;
                    attributes.add(tokenEndpointAttributeHolderType.getName());
                    if (tokenEndpointAttributeHolderType.getMultiValued()) {
                        multiValued.add(tokenEndpointAttributeHolderType.getName());
                    }
                    if ((scopeSet = new HashSet<String>(Arrays.asList(tokenEndpointAttributeHolderType.getMappedScopeArray()))).isEmpty()) continue;
                    mappedScopes.put(tokenEndpointAttributeHolderType.getName(), scopeSet);
                }
                TokenEndpointAttributeContract tokenEndpointAttributeContract = new TokenEndpointAttributeContract();
                tokenEndpointAttributeContract.setMutableAttributeNames(attributes);
                tokenEndpointAttributeContract.setMultiValued(multiValued);
                tokenEndpointAttributeContract.setMappedScopes(mappedScopes);
                atmInstance.setTokenEndpointAttributeContract(tokenEndpointAttributeContract);
            }
        }
        return configType;
    }

    @Override
    public void saveConf(ConfigurablePluginInstance atmInstance) {
        this.saveConf((BearerAccessTokenMgmtPluginInstance)atmInstance);
    }

    private void saveConf(BearerAccessTokenMgmtPluginInstance atmInstance) {
        AccessTokenManagerConfigurationDocument atmConfigDoc = AccessTokenManagerConfigurationDocument.Factory.newInstance();
        AccessTokenManagerConfigurationType atmConfigType = this.addAtmConfigType(atmConfigDoc, atmInstance);
        this.saveConf(atmInstance, (ConfigType)atmConfigType, (XmlObject)atmConfigDoc);
    }

    private AccessTokenManagerConfigurationType addAtmConfigType(AccessTokenManagerConfigurationDocument atmConfigDoc, BearerAccessTokenMgmtPluginInstance atmInstance) {
        AccessTokenManagerConfigurationType atmConfigType = atmConfigDoc.addNewAccessTokenManagerConfiguration();
        return this.fillInAtmConfigType(atmInstance, atmConfigType);
    }

    private AccessTokenManagerConfigurationType fillInAtmConfigType(BearerAccessTokenMgmtPluginInstance atmInstance, AccessTokenManagerConfigurationType atmConfigType) {
        TokenEndpointAttributeContract tokenEndpointAttributeContract;
        atmConfigType.setInheritAccessControlSettings(atmInstance.isInheritAccessControlSettings());
        atmConfigType.setInheritSelectionSettings(atmInstance.isInheritSelectionSettings());
        atmConfigType.setInheritSessionValidationSettings(atmInstance.isInheritSessionValidationSettings());
        if (!atmInstance.isInheritAccessControlSettings()) {
            atmConfigType.setRestrictClients(atmInstance.isOwnRestrictClients());
            atmConfigType.setAllowedClientIdArray(atmInstance.getOwnAllowedClients().toArray(new String[0]));
        }
        if (!atmInstance.isInheritSelectionSettings()) {
            atmConfigType.setResourceUriArray(atmInstance.getOwnResourceUris().toArray(new String[0]));
        }
        if (!atmInstance.isInheritSessionValidationSettings()) {
            atmConfigType.setIncludeSessionIdentifier(atmInstance.isIncludeSessionIdentifier());
            atmConfigType.setCheckSessionRevocationStatus(atmInstance.isCheckSessionRevocationStatus());
            atmConfigType.setCheckValidAuthnSession(atmInstance.isCheckSessionValidationStatus());
            atmConfigType.setUpdateAuthnSessionActivity(atmInstance.isUpdateAuthSessionActivity());
        }
        if (!atmInstance.isInheritingExtendedContractAttributes()) {
            atmConfigType.setDefaultSubjectAttribute(atmInstance.getDefaultSubjectAttribute());
        }
        boolean isInheritingTokenEndpointAttrs = atmInstance.isInheritTokenEndpointAttributeContract();
        atmConfigType.setIsInheritTokenEndpointContractAttributes(isInheritingTokenEndpointAttrs);
        if (!isInheritingTokenEndpointAttrs && (tokenEndpointAttributeContract = atmInstance.getOwnTokenEndpointAttributeContract()) != null) {
            TokenEndpointContractAttributesType tokenEndpointContractAttributesType = atmConfigType.addNewTokenEndpointContractAttributes();
            for (String attr : tokenEndpointAttributeContract.getMutableAttributeNames()) {
                TokenEndpointAttributeHolderType tokenEndpointAttributeHolderType = tokenEndpointContractAttributesType.addNewTokenEndpointAttribute();
                tokenEndpointAttributeHolderType.setName(attr);
                tokenEndpointAttributeHolderType.setMultiValued(tokenEndpointAttributeContract.getMultiValued().contains(attr));
                Set<String> scopeList = tokenEndpointAttributeContract.getMappedScopes().getOrDefault(attr, Collections.emptySet());
                tokenEndpointAttributeHolderType.setMappedScopeArray(scopeList.toArray(new String[scopeList.size()]));
            }
        }
        return atmConfigType;
    }
}

