/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.ConfigEventListener;
import com.pingidentity.configservice.ConfigEventType;
import com.pingidentity.configservice.ListenerRegistry;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.AccessToken;
import com.pingidentity.sdk.oauth20.AccessTokenRevocable;
import com.pingidentity.sdk.oauth20.BearerAccessTokenManagementPlugin;
import com.pingidentity.sdk.oauth20.IssuedAccessToken;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.jose.jwk.AccessTokenMgmtPublishableJwk;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientCredentialAccessTokenMapping;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.oauth20.token.AccessTokenWrapper;
import org.sourceid.oauth20.token.plugin.impl.ReferenceBearerAccessTokenManagementPlugin;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.domain.BasePluginInstance;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ConfigAbstract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AuthenticationSessionValidator;
import org.sourceid.saml20.domain.mgmt.impl.AuthnSessionValidationException;
import org.sourceid.saml20.domain.mgmt.impl.BearerAccessTokenMgmtConfigSupport;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class BearerAccessTokenMgmtPluginMgrImpl
implements BearerAccessTokenMgmtPluginManager,
AutoReloadable {
    private static final String CONFIG_BASE_NAME = "bearer-access-token-management-plugins";
    private static final String TOKEN_MANAGEMENT_PLUGIN_SEQUENCE = "bearer-access-token-management-plugin-sequence";
    private final Log log = LogFactory.getLog(this.getClass());
    private final PluginManagementSupport pluginMgmtSupport;
    private final Map<String, Map<String, String>> accessTokenManagementIdToKeyIdCert = new ConcurrentHashMap<String, Map<String, String>>();

    BearerAccessTokenMgmtPluginMgrImpl(PluginManagementSupport pluginMgmtSupport) {
        this.pluginMgmtSupport = pluginMgmtSupport;
    }

    public BearerAccessTokenMgmtPluginMgrImpl() {
        this.pluginMgmtSupport = new PluginManagementSupport(CONFIG_BASE_NAME, new BearerAccessTokenMgmtConfigSupport(CONFIG_BASE_NAME), true, AdminAuditLogger.Component.OAUTH_ACCESS_TOKEN);
        this.pluginMgmtSupport.setPluginInstanceFactory(new PluginManagementSupport.PluginInstanceFactory(){

            @Override
            public ConfigurablePluginInstance constructPluginInstance() {
                return new BearerAccessTokenMgmtPluginInstance();
            }
        });
    }

    public void finishInit() {
        this.pluginMgmtSupport.loadInstanceCaches();
        this.buildSequenceNumberMap();
        this.pluginMgmtSupport.earlyLoadConfigurations();
        this.populateJwkKeyIdsToPublish();
    }

    @Override
    public Collection<PluginDescriptor> getInstalledDescriptors() {
        return this.pluginMgmtSupport.getInstalledPluginDescriptors();
    }

    @Override
    public boolean isDuplicateId(String instanceId) {
        return this.pluginMgmtSupport.isDuplicateInstanceId(instanceId);
    }

    @Override
    public Collection<BearerAccessTokenMgmtPluginInstance> getInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getPluginInstances();
        return instances;
    }

    @Override
    public BearerAccessTokenMgmtPluginInstance getInstance(String instanceId) {
        return (BearerAccessTokenMgmtPluginInstance)this.pluginMgmtSupport.getPluginInstance(instanceId);
    }

    @Override
    public void saveInstance(ConfigurablePluginInstance instance) {
        Map<String, String> sequenceMap = new HashMap();
        try {
            sequenceMap = this.pluginMgmtSupport.getConfigStore().getMapValue(TOKEN_MANAGEMENT_PLUGIN_SEQUENCE);
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        if (!sequenceMap.containsKey(instance.getId())) {
            String sequenceNumber = BearerAccessTokenMgmtPluginMgrImpl.findSequenceNumber(sequenceMap.values());
            sequenceMap.put(instance.getId(), sequenceNumber);
            this.pluginMgmtSupport.getConfigStore().setMapValue(TOKEN_MANAGEMENT_PLUGIN_SEQUENCE, sequenceMap);
        }
        this.pluginMgmtSupport.savePluginInstance(instance);
        this.populateJwkKeyIdsToPublish();
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ACCESS_TOKEN_MANAGERS_UPDATED);
    }

    @Override
    public void deleteInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.deletePluginInstance(instance);
        try {
            Map sequenceMap = this.pluginMgmtSupport.getConfigStore().getMapValue(TOKEN_MANAGEMENT_PLUGIN_SEQUENCE);
            sequenceMap.remove(instance.getId());
            this.pluginMgmtSupport.getConfigStore().setMapValue(TOKEN_MANAGEMENT_PLUGIN_SEQUENCE, sequenceMap);
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        this.populateJwkKeyIdsToPublish();
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.ACCESS_TOKEN_MANAGERS_UPDATED);
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        return this.isPluginInUseInternally(pluginId) || this.isPluginInUseExternally(pluginId);
    }

    @Override
    public boolean isPluginInUseInternally(String pluginId) {
        for (BearerAccessTokenMgmtPluginInstance instance : MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstances()) {
            String parentId = instance.getParentId();
            if (parentId == null || !parentId.equals(pluginId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        BearerAccessTokenMgmtPluginInstance instance = (BearerAccessTokenMgmtPluginInstance)MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstance(pluginId);
        if (instance == null) {
            return false;
        }
        OpenIdConnectProviderPolicyManager policy = MgmtFactory.getOIDCProviderPolicyManager();
        if (policy.getPolicy() != null && policy.getPolicy().getPolicyGroups() != null) {
            for (OpenIdConnectProviderPolicy.PolicyGroup policyGroup : policy.getPolicy().getPolicyGroups().values()) {
                if (policyGroup.getAccessTokenManagerId() == null || !policyGroup.getAccessTokenManagerId().equals(instance.getId())) continue;
                return true;
            }
        }
        AuthzServerManager asMgr = MgmtFactory.getAuthzServerManager();
        for (UserKeyToAccessTokenMapping ukMapping : asMgr.getUserKeyToAccessTokenMappings()) {
            if (ukMapping.getTokenManagerId() == null || !ukMapping.getTokenManagerId().equals(instance.getId())) continue;
            return true;
        }
        for (ClientCredentialAccessTokenMapping ccMapping : asMgr.getClientCredentialsToAccessTokenMappings()) {
            if (ccMapping.getTokenManagerId() == null || !ccMapping.getTokenManagerId().equals(instance.getId())) continue;
            return true;
        }
        String string = asMgr.getAtmIdForOAuthGrantManagement();
        if (StringUtils.isNotBlank((String)string) && string.equals(instance.getId())) {
            return true;
        }
        TokenProcessorManager tokenProcessorManager = MgmtFactory.getTokenProcessorManager();
        for (Object tp : tokenProcessorManager.getInstancesForTokenType("urn:pingidentity.com:oauth2:grant_type:validate_bearer")) {
            Field f = ((BasePluginInstance)tp).getConfiguration().getField("Access Token Manager");
            if (f == null || !f.getValue().equals(instance.getId())) continue;
            return true;
        }
        ConnectionManager connMgr = MgmtFactory.getConnectionManager();
        for (IdpConnection idpConnection : connMgr.getAllIdpConnections()) {
            if (idpConnection.getOAuthSettings() == null) continue;
            for (OAuthAssertionGrantMapping mapping : idpConnection.getOAuthSettings().getOAuthAssertionGrantMappingList()) {
                if (mapping.getTokenManagerId() == null || !mapping.getTokenManagerId().equals(instance.getId())) continue;
                return true;
            }
        }
        ClientManager clientManager = MgmtFactory.getClientManager();
        Collection<Client> clients = clientManager.getClientsByAtmId(pluginId);
        return !clients.isEmpty();
    }

    @Override
    public BearerAccessTokenMgmtPluginInstance newInstance() {
        return new BearerAccessTokenMgmtPluginInstance();
    }

    @Override
    public void loadConfigurations() {
        this.pluginMgmtSupport.loadConfigurations();
    }

    @Override
    public BearerAccessTokenMgmtPluginInstance getDefaultInstance() {
        BearerAccessTokenMgmtPluginInstance defaultInstance = (BearerAccessTokenMgmtPluginInstance)this.pluginMgmtSupport.getDefaultInstance();
        if (defaultInstance == null) {
            defaultInstance = this.getInstance("default");
        }
        return defaultInstance;
    }

    @Override
    public boolean isDefaultInstanceConfigured() {
        return this.getDefaultInstance() != null;
    }

    @Override
    public void setDefaultInstance(String pluginId) {
        this.pluginMgmtSupport.setDefaultInstance(pluginId);
    }

    @Override
    public Set<String> getAllResourceUris() {
        return this.getInstances().stream().flatMap(instance -> instance.getResourceUris().stream()).collect(Collectors.toSet());
    }

    public BearerAccessTokenManagementPlugin getPlugin(String id) {
        return (BearerAccessTokenManagementPlugin)this.pluginMgmtSupport.getPlugin(id);
    }

    @Override
    public IssuedAccessToken issueAccessToken(String tokenManagerId, Map<String, AttributeValue> attributes, Scope scope, Client client, AccessGrant accessGrant, AuthorizationDetails authorizationDetails) {
        if (attributes == null || attributes.isEmpty()) {
            throw new IllegalArgumentException("access token attributes cannot be " + (attributes == null ? null : " empty"));
        }
        String clientId = client != null ? client.getClientId() : null;
        String accessGrantGuid = accessGrant != null ? accessGrant.getGuid() : null;
        BearerAccessTokenManagementPlugin plugin = this.getPlugin(tokenManagerId);
        if (plugin == null) {
            throw new IllegalArgumentException("Unrecognized token manager ID: " + tokenManagerId);
        }
        this.addAttributeForGrantManagement(tokenManagerId, attributes, scope, accessGrant, client);
        int sequenceNumber = MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getSequenceNumber(tokenManagerId);
        IssuedAccessToken token = plugin.issueAccessToken(attributes, scope, clientId, accessGrantGuid, sequenceNumber, authorizationDetails);
        return DpopUtil.covertToDPoPBoundAccessTokenIfNecessary(token, attributes);
    }

    void addAttributeForGrantManagement(String tokenManagerId, Map<String, AttributeValue> attributes, Scope scope, AccessGrant accessGrant, Client client) {
        boolean reuseAccessGrant;
        if (accessGrant == null) {
            return;
        }
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        boolean bl = reuseAccessGrant = client.isOverrideReusePersistentGrantType() ? client.isReusePersistentGrantTypeAllowed(accessGrant.getGrantType()) : authzServerManager.reuseExistingPersistentGrant(accessGrant.getGrantType());
        if ("implicit".equals(accessGrant.getGrantType()) && !reuseAccessGrant) {
            return;
        }
        String atmIdForOAuthGrantManagement = authzServerManager.getAtmIdForOAuthGrantManagement();
        String scopeForOAuthGrantManagementStr = authzServerManager.getScopeForOAuthGrantManagement();
        Scope scopeForOAuthGrantManagement = Scope.getScope((String)scopeForOAuthGrantManagementStr);
        if (tokenManagerId != null && tokenManagerId.equals(atmIdForOAuthGrantManagement) && scope != null && scope.hasAllScopes(scopeForOAuthGrantManagement)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding attribute pi.uk to access token with value: " + accessGrant.getUniqueUserIdentifer()));
            }
            attributes.put("pi.uk", new AttributeValue(accessGrant.getUniqueUserIdentifer()));
        }
    }

    @Override
    public AccessTokenWrapper validateAccessToken(List<String> tokenManagerIds, String accessTokenString) {
        AccessToken accessToken = null;
        String tokenManagerIdUsed = null;
        AccessTokenWrapper accessTokenWrapper = new AccessTokenWrapper();
        for (String tokenManagerId : tokenManagerIds) {
            BearerAccessTokenManagementPlugin plugin = this.getPlugin(tokenManagerId);
            if (plugin == null) {
                throw new IllegalArgumentException("Unrecognized token manager ID: " + tokenManagerId);
            }
            int managerSequenceNumber = this.getSequenceNumber(tokenManagerId);
            if (plugin.issuedToken(accessTokenString, managerSequenceNumber)) {
                accessToken = plugin.validateAccessToken(accessTokenString);
            }
            if (accessToken == null) continue;
            tokenManagerIdUsed = tokenManagerId;
            this.log.debug((Object)("The token manager id used to validate and produce an access token: " + tokenManagerIdUsed));
            break;
        }
        BearerAccessTokenMgmtPluginInstance atm = this.getInstance(tokenManagerIdUsed);
        if (accessToken != null && accessToken.getAttributes() != null && accessToken.getAttributes().get("pi.sri") != null) {
            String sri = ((AttributeValue)accessToken.getAttributes().get("pi.sri")).getValue();
            try {
                AuthenticationSessionValidator authenticationSessionValidator = new AuthenticationSessionValidator(StateMgmtFactory.getSessionRevocationService());
                authenticationSessionValidator.handleSessionValidation(atm, sri);
            }
            catch (AuthnSessionValidationException e) {
                this.log.debug((Object)e.getMessage());
                return accessTokenWrapper;
            }
        }
        accessTokenWrapper.setAccessToken(accessToken);
        accessTokenWrapper.setTokenManager(atm);
        return accessTokenWrapper;
    }

    @Override
    public void onAccessGrantRevoked(String accessGrantGuid) {
        for (BearerAccessTokenManagementPlugin plugin : this.getPlugins()) {
            try {
                AccessTokenRevocable revoker = (AccessTokenRevocable)plugin;
                revoker.revokeAllAccessTokens(accessGrantGuid);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    @Override
    public boolean supportsPluginHierarchies() {
        return true;
    }

    @Override
    public boolean revokeAccessToken(Client client, String token) {
        for (BearerAccessTokenManagementPlugin plugin : this.getPlugins()) {
            try {
                AccessTokenRevocable revoker = (AccessTokenRevocable)plugin;
                AccessToken accessToken = revoker.getAccessToken(token);
                if (accessToken == null) continue;
                boolean revoked = false;
                String tokenClientId = accessToken.getClientId();
                String accessGrantGuid = accessToken.getAccessGrantGuid();
                if (client.getClientId() == null) {
                    if (tokenClientId == null) {
                        revoked = revoker.revokeAccessToken(token);
                    }
                } else if (tokenClientId != null && client.getClientId().equals(tokenClientId) && (revoked = revoker.revokeAccessToken(token))) {
                    AccessGrantManager accessGrantMgr;
                    AccessGrant accessGrant;
                    boolean reuseGrant;
                    AuthzServerManager authzServerMgr = MgmtFactory.getAuthzServerManager();
                    boolean bl = reuseGrant = client.isOverrideReusePersistentGrantType() ? client.isReusePersistentGrantTypeAllowed("implicit") : authzServerMgr.reuseExistingPersistentGrant("implicit");
                    if (!reuseGrant && accessGrantGuid != null && (accessGrant = (accessGrantMgr = MgmtFactory.getAccessGrantManager()).getByGuid(accessGrantGuid)) != null && "implicit".equals(accessGrant.getGrantType())) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("An access token was revoked for IMPLICIT access grant '" + accessGrantGuid + "'. Revoking the IMPLICIT access grant as well."));
                        }
                        accessGrantMgr.revokeGrant(accessGrantGuid);
                    }
                }
                return revoked;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return false;
    }

    @Override
    public boolean revokeAccessTokens(Client client) {
        for (BearerAccessTokenManagementPlugin plugin : this.getPlugins()) {
            try {
                AccessTokenRevocable revoker = (AccessTokenRevocable)plugin;
                revoker.revokeAllAccessTokensByClient(client.getClientId());
            }
            catch (ClassCastException classCastException) {}
        }
        return false;
    }

    @Override
    public boolean isRevocableAccessTokenExistAndWithClient(String token) {
        for (BearerAccessTokenManagementPlugin plugin : this.getPlugins()) {
            try {
                AccessTokenRevocable revoker = (AccessTokenRevocable)plugin;
                AccessToken accessToken = revoker.getAccessToken(token);
                if (accessToken == null) continue;
                return accessToken.getClientId() != null;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return false;
    }

    @Override
    public int getSequenceNumber(String tokenManagerId) {
        int sequenceNumber = 0;
        try {
            Map sequenceMap = this.pluginMgmtSupport.getConfigStore().getMapValue(TOKEN_MANAGEMENT_PLUGIN_SEQUENCE);
            if (sequenceMap.containsKey(tokenManagerId)) {
                sequenceNumber = Integer.parseInt(((String)sequenceMap.get(tokenManagerId)).toString());
            }
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        return sequenceNumber;
    }

    @Override
    public void setSequenceNumber(String tokenManagerId, int sequenceNumber) {
        HashMap<String, String> sequenceMap;
        try {
            sequenceMap = this.pluginMgmtSupport.getConfigStore().getMapValue(TOKEN_MANAGEMENT_PLUGIN_SEQUENCE);
        }
        catch (NoSuchValueException ex) {
            sequenceMap = new HashMap<String, String>();
        }
        sequenceMap.put(tokenManagerId, Integer.toString(sequenceNumber));
        this.pluginMgmtSupport.getConfigStore().setMapValue(TOKEN_MANAGEMENT_PLUGIN_SEQUENCE, sequenceMap);
    }

    @Override
    public String isSequenceNumberInUse(int sequenceNumber) {
        HashMap sequenceMap;
        try {
            sequenceMap = this.pluginMgmtSupport.getConfigStore().getMapValue(TOKEN_MANAGEMENT_PLUGIN_SEQUENCE);
        }
        catch (NoSuchValueException ex) {
            sequenceMap = new HashMap();
        }
        return sequenceMap.entrySet().stream().filter(entry -> sequenceNumber == Integer.parseInt((String)entry.getValue())).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    @Override
    public void registerForConfigEvents(ConfigEventListener listener) {
        ListenerRegistry.getInstance().addListener(ConfigEventType.ACCESS_TOKEN_MANAGERS_UPDATED, listener, l -> l.onConfigUpdated());
    }

    private void buildSequenceNumberMap() {
        boolean buildMap = false;
        try {
            this.pluginMgmtSupport.getConfigStore().getMapValue(TOKEN_MANAGEMENT_PLUGIN_SEQUENCE);
        }
        catch (NoSuchValueException ex) {
            buildMap = true;
        }
        if (buildMap) {
            HashMap<String, String> sequenceMap = new HashMap<String, String>();
            List names = this.getInstances().stream().map(ConfigAbstract::getId).sorted().collect(Collectors.toList());
            int sequenceNumber = 1;
            for (String name : names) {
                sequenceMap.put(name, String.valueOf(sequenceNumber));
                ++sequenceNumber;
            }
            this.pluginMgmtSupport.getConfigStore().setMapValue(TOKEN_MANAGEMENT_PLUGIN_SEQUENCE, sequenceMap);
        }
    }

    private static String findSequenceNumber(Collection<String> existing) {
        int random;
        Random rnd = new Random();
        int end = 1679615;
        while ((random = rnd.nextInt(end)) == 0 || existing.contains(String.valueOf(random))) {
        }
        return String.valueOf(random);
    }

    @Override
    public boolean supportsDefaultInstance() {
        return true;
    }

    private Collection<BearerAccessTokenManagementPlugin> getPlugins() {
        ArrayList<BearerAccessTokenManagementPlugin> plugins = new ArrayList<BearerAccessTokenManagementPlugin>();
        for (BearerAccessTokenMgmtPluginInstance instance : this.getInstances()) {
            BearerAccessTokenManagementPlugin plugin = (BearerAccessTokenManagementPlugin)this.pluginMgmtSupport.getPlugin(instance.getId());
            if (plugin == null) continue;
            plugins.add(plugin);
        }
        return plugins;
    }

    @Override
    public Collection<BearerAccessTokenMgmtPluginInstance> getVirtualInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getVirtualPlugins();
        return instances;
    }

    @Override
    public Map<String, Integer> getTokenMapSizes() {
        Map<String, Integer> map = new HashMap<String, Integer>();
        for (BearerAccessTokenMgmtPluginInstance instance : this.getInstances()) {
            BearerAccessTokenManagementPlugin plugin = this.getPlugin(instance.getId());
            if (!plugin.getClass().equals(ReferenceBearerAccessTokenManagementPlugin.class)) continue;
            if (map.isEmpty()) {
                map = ((ReferenceBearerAccessTokenManagementPlugin)plugin).getSize();
            }
            if (map.containsKey(instance.getId())) continue;
            map.put(instance.getId(), 0);
        }
        return map;
    }

    private synchronized void populateJwkKeyIdsToPublish() {
        this.accessTokenManagementIdToKeyIdCert.clear();
        Collection<BearerAccessTokenMgmtPluginInstance> instances = this.getInstances();
        for (BearerAccessTokenMgmtPluginInstance instance : instances) {
            this.updatePublishableJwkKeyIdCertId(instance);
        }
    }

    private void updatePublishableJwkKeyIdCertId(BearerAccessTokenMgmtPluginInstance instance) {
        BearerAccessTokenManagementPlugin atmPlugin = this.getPlugin(instance.getId());
        if (atmPlugin instanceof AccessTokenMgmtPublishableJwk) {
            Map<String, String> keyIdToCertId = ((AccessTokenMgmtPublishableJwk)atmPlugin).getKeyIdToCertAlias(instance.getConfiguration());
            if (keyIdToCertId == null || keyIdToCertId.isEmpty()) {
                this.accessTokenManagementIdToKeyIdCert.remove(instance.getId());
            } else {
                this.accessTokenManagementIdToKeyIdCert.put(instance.getId(), keyIdToCertId);
            }
        }
    }

    @Override
    public Map<String, Map<String, String>> getPublishableJwkKeyIdCertAlias() {
        return Map.copyOf(this.accessTokenManagementIdToKeyIdCert);
    }
}

