/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.FieldObfuscator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.CaptchaSettings;
import org.sourceid.saml20.domain.mgmt.CaptchaManager;

public class CaptchaManagerImpl
implements CaptchaManager {
    private ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());
    private static final String SITE_KEY = "SiteKey";
    private static final String SECRET_KEY = "SiteSecret";

    @Override
    public synchronized CaptchaSettings getCaptchaSettings() {
        String siteKey = this.configStore.getStringValue(SITE_KEY, null);
        String obfuscatedSecretKey = this.configStore.getStringValue(SECRET_KEY, null);
        String deobfuscatedSecretKey = null;
        if (!StringUtils.isBlank((String)obfuscatedSecretKey)) {
            deobfuscatedSecretKey = FieldObfuscator.REAL.deobfuscate(obfuscatedSecretKey);
        }
        CaptchaSettings captchaSettings = new CaptchaSettings();
        captchaSettings.setSiteKey(siteKey);
        captchaSettings.setSecretKey(deobfuscatedSecretKey);
        return captchaSettings;
    }

    @Override
    public synchronized void saveCaptchaSettings(CaptchaSettings captchaSettings) {
        if (captchaSettings != null) {
            this.configStore.setStringValue(SITE_KEY, captchaSettings.getSiteKey());
            String secretKey = captchaSettings.getSecretKey();
            if (!StringUtils.isBlank((String)secretKey)) {
                String obfuscatedSecretKey = FieldObfuscator.REAL.obfuscate(secretKey);
                this.configStore.setStringValue(SECRET_KEY, obfuscatedSecretKey);
            }
        }
    }
}

