/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.SysDirInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.CollectSupportDataManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.collectsupportdata.CsdArguments;

public class CsdCollectionTask
implements Runnable {
    private static final Log log = LogFactory.getLog(CsdCollectionTask.class);
    private final String CSD_CLASS_NAME = "com.pingidentity.csd.server.tools.CollectSupportData";
    private final String archiveId;
    private final CsdArguments csdArgs;
    private final SysDirInfo sysDirInfo;
    private final CollectSupportDataManager collectSupportDataManager;

    public CsdCollectionTask(String archiveId, CsdArguments csdArgs) {
        this(archiveId, csdArgs, MgmtFactory.getSysDirInfo(), MgmtFactory.getCollectSupportDataManager());
    }

    public CsdCollectionTask(String archiveId, CsdArguments args, SysDirInfo sysDirInfo, CollectSupportDataManager collectSupportDataManager) {
        this.archiveId = archiveId;
        this.csdArgs = args;
        this.sysDirInfo = sysDirInfo;
        this.collectSupportDataManager = collectSupportDataManager;
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive on try-with-resource block")
    public void run() {
        String archiveOutputPath = this.sysDirInfo.getInstanceDataDirectory() + File.separator + this.archiveId;
        log.info((Object)("Archive output path: " + archiveOutputPath));
        this.csdArgs.addArgument("outputPath", archiveOutputPath);
        this.csdArgs.addArgument("productType", "PingFederate");
        this.csdArgs.addArgument("serverRoot", Paths.get(System.getProperty("pf.home"), new String[0]).toAbsolutePath().normalize().toString());
        String binPath = System.getProperty("pf.home") + File.separator + "bin";
        File binDirectory = new File(binPath);
        ArrayList<String> processArgs = new ArrayList<String>();
        String javaPath = System.getProperty("pf.java");
        String csdConfigPath = this.sysDirInfo.getConfigDirectory() + File.separator + "collect-support-data";
        processArgs.add(javaPath);
        processArgs.add("-Dcsd.config.path=" + csdConfigPath);
        processArgs.add("-cp");
        processArgs.add(this.buildClasspath());
        processArgs.add("com.pingidentity.csd.server.tools.CollectSupportData");
        processArgs.addAll(this.csdArgs.getArguments());
        log.info((Object)"Running the CSD Utility with the following arguments: ");
        log.info((Object)this.csdArgs.getArgumentString());
        ProcessBuilder processBuilder = new ProcessBuilder(processArgs);
        processBuilder.directory(binDirectory);
        try {
            Process process = processBuilder.start();
            try (InputStream inputStream = process.getInputStream();
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                 BufferedReader reader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.info((Object)line);
                }
            }
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            log.error((Object)"Error running CSD collection task", (Throwable)e);
            throw new RuntimeException(e);
        }
        log.info((Object)"Finished running CSD collection task");
        this.collectSupportDataManager.notifyCollectionFinished(this.archiveId);
    }

    private String buildClasspath() {
        StringBuilder classpath = new StringBuilder();
        File libDir = Paths.get(System.getProperty("pf.home"), "bin", "csd", "lib").toFile();
        File[] files = libDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".jar")) continue;
                classpath.append(file.getAbsolutePath()).append(File.pathSeparator);
            }
        } else {
            log.error((Object)("No files found in " + libDir.getAbsolutePath()));
        }
        return classpath.toString();
    }
}

