/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sources.SourceDescriptor;
import java.util.Collection;
import java.util.Collections;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.mgmt.CustomDataSourceManager;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.impl.DataSourceManagerImpl;

public class CustomDataSourceManagerImpl
implements CustomDataSourceManager,
AutoReloadable {
    private final DataSourceManager dataSourceManager;

    public CustomDataSourceManagerImpl(DataSourceManager dataSourceManager) {
        this.dataSourceManager = dataSourceManager;
    }

    @Override
    public Collection<PluginDescriptor> getInstalledDescriptors() {
        Collection<SourceDescriptor> descriptors = this.dataSourceManager.discoverSourceDescriptors();
        return descriptors;
    }

    @Override
    public boolean isDuplicateId(String instanceId) {
        return this.dataSourceManager.getCustomDataSource(instanceId) != null;
    }

    @Override
    public Collection<CustomDataSource> getInstances() {
        return this.dataSourceManager.getCustomDataSources();
    }

    @Override
    public CustomDataSource getInstance(String instanceId) {
        return this.dataSourceManager.getCustomDataSource(instanceId);
    }

    @Override
    public void saveInstance(ConfigurablePluginInstance instance) {
        this.dataSourceManager.saveCustomDataSource((CustomDataSource)instance);
    }

    @Override
    public void deleteInstance(ConfigurablePluginInstance instance) {
        this.dataSourceManager.deleteCustomDataSource((CustomDataSource)instance);
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        CustomDataSource dataSource = this.dataSourceManager.getCustomDataSource(pluginId);
        return this.dataSourceManager.isInUse(dataSource);
    }

    @Override
    public boolean isPluginInUseInternally(String pluginId) {
        return this.isPluginInUse(pluginId);
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        return this.isPluginInUse(pluginId);
    }

    @Override
    public CustomDataSource newInstance() {
        return new CustomDataSource();
    }

    @Override
    public void loadConfigurations() {
        if (this.dataSourceManager instanceof DataSourceManagerImpl) {
            ((DataSourceManagerImpl)this.dataSourceManager).loadCustomAttributeSources();
        }
    }

    @Override
    public boolean supportsPluginHierarchies() {
        return false;
    }

    @Override
    public boolean supportsDefaultInstance() {
        return false;
    }

    @Override
    public CustomDataSource getDefaultInstance() {
        return null;
    }

    @Override
    public void setDefaultInstance(String pluginId) {
    }

    @Override
    public Collection<CustomDataSource> getVirtualInstances() {
        return Collections.emptyList();
    }
}

